/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.SecureRandom;
import java.util.Date;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.bcpg.ArmoredInputStream;
import org.bouncycastle.bcpg.BCPGInputStream;
import org.bouncycastle.bcpg.HashAlgorithmTags;
import org.bouncycastle.bcpg.MPInteger;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPLiteralDataGenerator;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.encoders.Base64;
import org.bouncycastle.util.encoders.DecoderException;

public class PGPUtil
implements HashAlgorithmTags {
    private static String defProvider = "BC";
    private static final int READ_AHEAD = 60;

    public static String getDigestName(int n) throws PGPException {
        switch (n) {
            case 2: {
                return "SHA1";
            }
            case 5: {
                return "MD2";
            }
            case 1: {
                return "MD5";
            }
            case 3: {
                return "RIPEMD160";
            }
            case 8: {
                return "SHA256";
            }
            case 9: {
                return "SHA384";
            }
            case 10: {
                return "SHA512";
            }
            case 11: {
                return "SHA224";
            }
            case 6: {
                return "TIGER";
            }
        }
        throw new PGPException("unknown hash algorithm tag in getDigestName: " + n);
    }

    public static String getSignatureName(int n, int n2) throws PGPException {
        String string;
        switch (n) {
            case 1: 
            case 3: {
                string = "RSA";
                break;
            }
            case 17: {
                string = "DSA";
                break;
            }
            case 16: 
            case 20: {
                string = "ElGamal";
                break;
            }
            default: {
                throw new PGPException("unknown algorithm tag in signature:" + n);
            }
        }
        return PGPUtil.getDigestName(n2) + "with" + string;
    }

    public static String getSymmetricCipherName(int n) {
        switch (n) {
            case 0: {
                return null;
            }
            case 2: {
                return "DESEDE";
            }
            case 1: {
                return "IDEA";
            }
            case 3: {
                return "CAST5";
            }
            case 4: {
                return "Blowfish";
            }
            case 5: {
                return "SAFER";
            }
            case 6: {
                return "DES";
            }
            case 7: {
                return "AES";
            }
            case 8: {
                return "AES";
            }
            case 9: {
                return "AES";
            }
            case 11: {
                return "Camellia";
            }
            case 12: {
                return "Camellia";
            }
            case 13: {
                return "Camellia";
            }
            case 10: {
                return "Twofish";
            }
        }
        throw new IllegalArgumentException("unknown symmetric algorithm: " + n);
    }

    public static String getDefaultProvider() {
        return defProvider;
    }

    public static void setDefaultProvider(String string) {
        defProvider = string;
    }

    static MPInteger[] dsaSigToMpi(byte[] byArray) throws PGPException {
        ASN1Integer aSN1Integer;
        ASN1Integer aSN1Integer2;
        MPInteger[] mPIntegerArray;
        ASN1InputStream aSN1InputStream = new ASN1InputStream(byArray);
        try {
            mPIntegerArray = ASN1Sequence.getInstance(aSN1InputStream.readObject());
            aSN1Integer2 = ASN1Integer.getInstance(mPIntegerArray.getObjectAt(0));
            aSN1Integer = ASN1Integer.getInstance(mPIntegerArray.getObjectAt(1));
        }
        catch (IOException iOException) {
            throw new PGPException("exception decoding signature", iOException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new PGPException("exception decoding signature", illegalArgumentException);
        }
        mPIntegerArray = new MPInteger[]{new MPInteger(aSN1Integer2.getValue()), new MPInteger(aSN1Integer.getValue())};
        return mPIntegerArray;
    }

    public static boolean isKeyRing(byte[] byArray) throws IOException {
        BCPGInputStream bCPGInputStream = new BCPGInputStream(new ByteArrayInputStream(byArray));
        int n = bCPGInputStream.nextPacketTag();
        return n == 6 || n == 14 || n == 5 || n == 5;
    }

    public static boolean isKeyBox(byte[] byArray) throws IOException {
        if (byArray.length < 12) {
            return false;
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        for (int i = 0; i != 8; ++i) {
            ((InputStream)byteArrayInputStream).read();
        }
        return ((InputStream)byteArrayInputStream).read() == 75 && ((InputStream)byteArrayInputStream).read() == 66 && ((InputStream)byteArrayInputStream).read() == 88 && ((InputStream)byteArrayInputStream).read() == 102;
    }

    public static byte[] makeRandomKey(int n, SecureRandom secureRandom) throws PGPException {
        int n2 = 0;
        switch (n) {
            case 2: {
                n2 = 192;
                break;
            }
            case 1: {
                n2 = 128;
                break;
            }
            case 3: {
                n2 = 128;
                break;
            }
            case 4: {
                n2 = 128;
                break;
            }
            case 5: {
                n2 = 128;
                break;
            }
            case 6: {
                n2 = 64;
                break;
            }
            case 7: {
                n2 = 128;
                break;
            }
            case 8: {
                n2 = 192;
                break;
            }
            case 9: {
                n2 = 256;
                break;
            }
            case 11: {
                n2 = 128;
                break;
            }
            case 12: {
                n2 = 192;
                break;
            }
            case 13: {
                n2 = 256;
                break;
            }
            case 10: {
                n2 = 256;
                break;
            }
            default: {
                throw new PGPException("unknown symmetric algorithm: " + n);
            }
        }
        byte[] byArray = new byte[(n2 + 7) / 8];
        secureRandom.nextBytes(byArray);
        return byArray;
    }

    public static void writeFileToLiteralData(OutputStream outputStream2, char c, File file2) throws IOException {
        PGPLiteralDataGenerator pGPLiteralDataGenerator = new PGPLiteralDataGenerator();
        OutputStream outputStream3 = pGPLiteralDataGenerator.open(outputStream2, c, file2);
        PGPUtil.pipeFileContents(file2, outputStream3, 32768);
    }

    public static void writeFileToLiteralData(OutputStream outputStream2, char c, File file2, byte[] byArray) throws IOException {
        PGPLiteralDataGenerator pGPLiteralDataGenerator = new PGPLiteralDataGenerator();
        OutputStream outputStream3 = pGPLiteralDataGenerator.open(outputStream2, c, file2.getName(), new Date(file2.lastModified()), byArray);
        PGPUtil.pipeFileContents(file2, outputStream3, byArray.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void pipeFileContents(File file2, OutputStream outputStream2, int n) throws IOException {
        byte[] byArray = new byte[n];
        FileInputStream fileInputStream = new FileInputStream(file2);
        try {
            int n2;
            while ((n2 = fileInputStream.read(byArray)) > 0) {
                outputStream2.write(byArray, 0, n2);
            }
            outputStream2.close();
        }
        finally {
            Arrays.fill(byArray, (byte)0);
            try {
                fileInputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    private static boolean isPossiblyBase64(int n) {
        return n >= 65 && n <= 90 || n >= 97 && n <= 122 || n >= 48 && n <= 57 || n == 43 || n == 47 || n == 13 || n == 10;
    }

    public static InputStream getDecoderStream(InputStream inputStream) throws IOException {
        int n;
        if (!inputStream.markSupported()) {
            inputStream = new BufferedInputStreamExt(inputStream);
        }
        inputStream.mark(60);
        int n2 = inputStream.read();
        if ((n2 & 0x80) != 0) {
            inputStream.reset();
            return inputStream;
        }
        if (!PGPUtil.isPossiblyBase64(n2)) {
            inputStream.reset();
            return new ArmoredInputStream(inputStream);
        }
        byte[] byArray = new byte[60];
        int n3 = 1;
        byArray[0] = (byte)n2;
        for (n = 1; n != 60 && (n2 = inputStream.read()) >= 0; ++n) {
            if (!PGPUtil.isPossiblyBase64(n2)) {
                inputStream.reset();
                return new ArmoredInputStream(inputStream);
            }
            if (n2 == 10 || n2 == 13) continue;
            byArray[n3++] = (byte)n2;
        }
        inputStream.reset();
        if (n < 4) {
            return new ArmoredInputStream(inputStream);
        }
        byte[] byArray2 = new byte[8];
        System.arraycopy(byArray, 0, byArray2, 0, byArray2.length);
        try {
            byte[] byArray3 = Base64.decode(byArray2);
            if ((byArray3[0] & 0x80) != 0) {
                return new ArmoredInputStream(inputStream, false);
            }
            return new ArmoredInputStream(inputStream);
        }
        catch (DecoderException decoderException) {
            throw new IOException(decoderException.getMessage());
        }
    }

    static class BufferedInputStreamExt
    extends BufferedInputStream {
        BufferedInputStreamExt(InputStream inputStream) {
            super(inputStream);
        }

        public synchronized int available() throws IOException {
            int n = super.available();
            if (n < 0) {
                n = Integer.MAX_VALUE;
            }
            return n;
        }
    }
}

