/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.github.core.client;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class DateFormatter
implements JsonDeserializer<Date>,
JsonSerializer<Date> {
    private final DateFormat[] formats = new DateFormat[3];

    public DateFormatter() {
        this.formats[0] = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        this.formats[1] = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss Z");
        this.formats[2] = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        TimeZone timeZone = TimeZone.getTimeZone("Zulu");
        DateFormat[] dateFormatArray = this.formats;
        int n = this.formats.length;
        int n2 = 0;
        while (n2 < n) {
            DateFormat format = dateFormatArray[n2];
            format.setTimeZone(timeZone);
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Date deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonParseException exception = null;
        String value2 = json.getAsString();
        DateFormat[] dateFormatArray = this.formats;
        int n = this.formats.length;
        int n2 = 0;
        while (n2 < n) {
            DateFormat format = dateFormatArray[n2];
            try {
                DateFormat dateFormat = format;
                synchronized (dateFormat) {
                    return format.parse(value2);
                }
            }
            catch (ParseException e) {
                exception = new JsonParseException(e);
                ++n2;
            }
        }
        if (exception != null) {
            throw exception;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JsonElement serialize(Date date, Type type2, JsonSerializationContext context) {
        String formatted;
        DateFormat primary;
        DateFormat dateFormat = primary = this.formats[0];
        synchronized (dateFormat) {
            formatted = primary.format(date);
        }
        return new JsonPrimitive(formatted);
    }
}

