/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.github.core.client;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.Date;
import org.eclipse.egit.github.core.client.DateFormatter;
import org.eclipse.egit.github.core.event.CommitCommentPayload;
import org.eclipse.egit.github.core.event.CreatePayload;
import org.eclipse.egit.github.core.event.DeletePayload;
import org.eclipse.egit.github.core.event.DownloadPayload;
import org.eclipse.egit.github.core.event.Event;
import org.eclipse.egit.github.core.event.EventPayload;
import org.eclipse.egit.github.core.event.FollowPayload;
import org.eclipse.egit.github.core.event.ForkApplyPayload;
import org.eclipse.egit.github.core.event.ForkPayload;
import org.eclipse.egit.github.core.event.GistPayload;
import org.eclipse.egit.github.core.event.GollumPayload;
import org.eclipse.egit.github.core.event.IssueCommentPayload;
import org.eclipse.egit.github.core.event.IssuesPayload;
import org.eclipse.egit.github.core.event.MemberPayload;
import org.eclipse.egit.github.core.event.PublicPayload;
import org.eclipse.egit.github.core.event.PullRequestPayload;
import org.eclipse.egit.github.core.event.PullRequestReviewCommentPayload;
import org.eclipse.egit.github.core.event.PushPayload;
import org.eclipse.egit.github.core.event.ReleasePayload;
import org.eclipse.egit.github.core.event.TeamAddPayload;
import org.eclipse.egit.github.core.event.WatchPayload;

public class EventFormatter
implements JsonDeserializer<Event> {
    private final Gson gson = new GsonBuilder().registerTypeAdapter((Type)((Object)Date.class), new DateFormatter()).setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).create();

    @Override
    public Event deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        Class payloadClass;
        Event event = this.gson.fromJson(json, Event.class);
        if (event == null || !json.isJsonObject()) {
            return event;
        }
        JsonElement rawPayload = json.getAsJsonObject().get("payload");
        if (rawPayload == null || !rawPayload.isJsonObject()) {
            return event;
        }
        String type2 = event.getType();
        if (type2 == null || type2.length() == 0) {
            return event;
        }
        if ("CommitCommentEvent".equals(type2)) {
            payloadClass = CommitCommentPayload.class;
        } else if ("CreateEvent".equals(type2)) {
            payloadClass = CreatePayload.class;
        } else if ("DeleteEvent".equals(type2)) {
            payloadClass = DeletePayload.class;
        } else if ("DownloadEvent".equals(type2)) {
            payloadClass = DownloadPayload.class;
        } else if ("FollowEvent".equals(type2)) {
            payloadClass = FollowPayload.class;
        } else if ("ForkEvent".equals(type2)) {
            payloadClass = ForkPayload.class;
        } else if ("ForkApplyEvent".equals(type2)) {
            payloadClass = ForkApplyPayload.class;
        } else if ("GistEvent".equals(type2)) {
            payloadClass = GistPayload.class;
        } else if ("GollumEvent".equals(type2)) {
            payloadClass = GollumPayload.class;
        } else if ("IssueCommentEvent".equals(type2)) {
            payloadClass = IssueCommentPayload.class;
        } else if ("IssuesEvent".equals(type2)) {
            payloadClass = IssuesPayload.class;
        } else if ("MemberEvent".equals(type2)) {
            payloadClass = MemberPayload.class;
        } else if ("PublicEvent".equals(type2)) {
            payloadClass = PublicPayload.class;
        } else if ("PullRequestEvent".equals(type2)) {
            payloadClass = PullRequestPayload.class;
        } else if ("PullRequestReviewCommentEvent".equals(type2)) {
            payloadClass = PullRequestReviewCommentPayload.class;
        } else if ("PushEvent".equals(type2)) {
            payloadClass = PushPayload.class;
        } else if ("ReleaseEvent".equals(type2)) {
            payloadClass = ReleasePayload.class;
        } else if ("TeamAddEvent".equals(type2)) {
            payloadClass = TeamAddPayload.class;
        } else if ("WatchEvent".equals(type2)) {
            payloadClass = WatchPayload.class;
        } else {
            return event;
        }
        try {
            EventPayload typedPayload = (EventPayload)context.deserialize(rawPayload, (Type)((Object)payloadClass));
            return event.setPayload(typedPayload);
        }
        catch (JsonParseException jpe) {
            return event;
        }
    }
}

