/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.github.core.client;

import com.google.gson.Gson;
import com.google.gson.JsonParseException;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import org.eclipse.egit.github.core.RequestError;
import org.eclipse.egit.github.core.client.GitHubRequest;
import org.eclipse.egit.github.core.client.GitHubResponse;
import org.eclipse.egit.github.core.client.GsonUtils;
import org.eclipse.egit.github.core.client.RequestException;
import org.eclipse.egit.github.core.util.EncodingUtils;

public class GitHubClient {
    protected static final String HEADER_CONTENT_TYPE = "Content-Type";
    protected static final String HEADER_ACCEPT = "Accept";
    protected static final String HEADER_AUTHORIZATION = "Authorization";
    protected static final String HEADER_USER_AGENT = "User-Agent";
    protected static final String METHOD_GET = "GET";
    protected static final String METHOD_PUT = "PUT";
    protected static final String METHOD_POST = "POST";
    protected static final String METHOD_DELETE = "DELETE";
    protected static final String USER_AGENT = "GitHubJava/2.1.0";
    protected static final int HTTP_UNPROCESSABLE_ENTITY = 422;
    protected final String baseUri;
    protected final String prefix;
    protected Gson gson = GsonUtils.getGson();
    private String user;
    private String credentials;
    private Proxy proxy;
    private String userAgent = "GitHubJava/2.1.0";
    private String headerAccept = "application/vnd.github.v3.full+json";
    private int bufferSize = 8192;
    private int requestLimit = -1;
    private int remainingRequests = -1;

    public static GitHubClient createClient(String url2) {
        try {
            String host = new URL(url2).getHost();
            if ("github.com".equals(host) || "gist.github.com".equals(host)) {
                host = "api.github.com";
            }
            return new GitHubClient(host);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public GitHubClient() {
        this("api.github.com");
    }

    public GitHubClient(String hostname) {
        this(hostname, -1, "https");
    }

    public GitHubClient(String hostname, int port, String scheme) {
        StringBuilder uri = new StringBuilder(scheme);
        uri.append("://");
        uri.append(hostname);
        if (port > 0) {
            uri.append(':').append(port);
        }
        this.baseUri = uri.toString();
        this.prefix = "api.github.com".equals(hostname) ? null : "/api/v3";
    }

    public GitHubClient setSerializeNulls(boolean serializeNulls) {
        this.gson = GsonUtils.getGson(serializeNulls);
        return this;
    }

    public GitHubClient setUserAgent(String agent) {
        this.userAgent = agent != null && agent.length() > 0 ? agent : USER_AGENT;
        return this;
    }

    public GitHubClient setHeaderAccept(String header) {
        this.headerAccept = header != null && header.length() > 0 ? header : "application/vnd.github.v3.full+json";
        return this;
    }

    public String getHeaderAccept() {
        if (this.headerAccept != null && this.headerAccept.length() > 0) {
            return this.headerAccept;
        }
        return "application/vnd.github.v3.full+json";
    }

    protected HttpURLConnection configureRequest(HttpURLConnection request2) {
        if (this.credentials != null) {
            request2.setRequestProperty(HEADER_AUTHORIZATION, this.credentials);
        }
        request2.setRequestProperty(HEADER_USER_AGENT, this.userAgent);
        request2.setRequestProperty(HEADER_ACCEPT, this.getHeaderAccept());
        return request2;
    }

    protected String configureUri(String uri) {
        if (this.prefix == null || uri.startsWith(this.prefix)) {
            return uri;
        }
        return String.valueOf(this.prefix) + uri;
    }

    protected HttpURLConnection createConnection(String uri) throws IOException {
        URL url2 = new URL(this.createUri(uri));
        if (this.proxy != null) {
            return (HttpURLConnection)url2.openConnection(this.proxy);
        }
        return (HttpURLConnection)url2.openConnection();
    }

    protected HttpURLConnection createConnection(String uri, String method) throws IOException {
        HttpURLConnection connection = this.createConnection(uri);
        connection.setRequestMethod(method);
        return this.configureRequest(connection);
    }

    protected HttpURLConnection createGet(String uri) throws IOException {
        return this.createConnection(uri, METHOD_GET);
    }

    protected HttpURLConnection createPost(String uri) throws IOException {
        return this.createConnection(uri, METHOD_POST);
    }

    protected HttpURLConnection createPut(String uri) throws IOException {
        return this.createConnection(uri, METHOD_PUT);
    }

    protected HttpURLConnection createDelete(String uri) throws IOException {
        return this.createConnection(uri, METHOD_DELETE);
    }

    public GitHubClient setCredentials(String user2, String password2) {
        this.user = user2;
        this.credentials = user2 != null && user2.length() > 0 && password2 != null && password2.length() > 0 ? "Basic " + EncodingUtils.toBase64(String.valueOf(user2) + ':' + password2) : null;
        return this;
    }

    public GitHubClient setProxy(Proxy proxy) {
        this.proxy = proxy;
        return this;
    }

    public GitHubClient setOAuth2Token(String token) {
        this.credentials = token != null && token.length() > 0 ? "token " + token : null;
        return this;
    }

    public GitHubClient setBufferSize(int bufferSize) {
        if (bufferSize < 1) {
            throw new IllegalArgumentException("Buffer size must be greater than zero");
        }
        this.bufferSize = bufferSize;
        return this;
    }

    public String getUser() {
        return this.user;
    }

    protected String toJson(Object object) throws IOException {
        try {
            return this.gson.toJson(object);
        }
        catch (JsonParseException jpe) {
            IOException ioe = new IOException("Parse exception converting object to JSON");
            ioe.initCause(jpe);
            throw ioe;
        }
    }

    protected <V> V parseJson(InputStream stream, Type type2) throws IOException {
        return this.parseJson(stream, type2, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected <V> V parseJson(InputStream stream, Type type2, Type listType) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream, "UTF-8"), this.bufferSize);
        if (listType == null) {
            try {
                Object t = this.gson.fromJson((Reader)reader, type2);
                return (V)t;
            }
            catch (JsonParseException jpe) {
                IOException ioe = new IOException("Parse exception converting JSON to object");
                ioe.initCause(jpe);
                throw ioe;
            }
            finally {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
        JsonReader jsonReader = new JsonReader(reader);
        try {
            if (jsonReader.peek() == JsonToken.BEGIN_ARRAY) {
                Object t = this.gson.fromJson(jsonReader, listType);
                return (V)t;
            }
            Object t = this.gson.fromJson(jsonReader, type2);
            return (V)t;
        }
        catch (JsonParseException jpe) {
            IOException ioe = new IOException("Parse exception converting JSON to object");
            ioe.initCause(jpe);
            throw ioe;
        }
        finally {
            try {
                jsonReader.close();
            }
            catch (IOException iOException) {}
        }
    }

    protected boolean isError(int code) {
        switch (code) {
            case 400: 
            case 401: 
            case 403: 
            case 404: 
            case 409: 
            case 410: 
            case 422: 
            case 500: {
                return true;
            }
        }
        return false;
    }

    protected boolean isOk(int code) {
        switch (code) {
            case 200: 
            case 201: 
            case 202: {
                return true;
            }
        }
        return false;
    }

    protected boolean isEmpty(int code) {
        return 204 == code;
    }

    protected RequestError parseError(InputStream response2) throws IOException {
        return (RequestError)this.parseJson(response2, (Type)((Object)RequestError.class));
    }

    protected Object getBody(GitHubRequest request2, InputStream stream) throws IOException {
        Type type2 = request2.getType();
        if (type2 != null) {
            return this.parseJson(stream, type2, request2.getArrayType());
        }
        return null;
    }

    protected IOException createException(InputStream response2, int code, String status) {
        if (this.isError(code)) {
            RequestError error;
            try {
                error = this.parseError(response2);
            }
            catch (IOException e) {
                return e;
            }
            if (error != null) {
                return new RequestException(error, code);
            }
        } else {
            try {
                response2.close();
            }
            catch (IOException error) {
                // empty catch block
            }
        }
        String message = status != null && status.length() > 0 ? String.valueOf(status) + " (" + code + ')' : "Unknown error occurred (" + code + ')';
        return new IOException(message);
    }

    public void post(String uri) throws IOException {
        this.post(uri, null, null);
    }

    public void put(String uri) throws IOException {
        this.put(uri, null, null);
    }

    public void delete(String uri) throws IOException {
        this.delete(uri, null);
    }

    protected void sendParams(HttpURLConnection request2, Object params2) throws IOException {
        request2.setDoOutput(true);
        if (params2 != null) {
            request2.setRequestProperty(HEADER_CONTENT_TYPE, "application/json; charset=UTF-8");
            byte[] data2 = this.toJson(params2).getBytes("UTF-8");
            request2.setFixedLengthStreamingMode(data2.length);
            BufferedOutputStream output = new BufferedOutputStream(request2.getOutputStream(), this.bufferSize);
            try {
                output.write(data2);
                output.flush();
            }
            finally {
                try {
                    output.close();
                }
                catch (IOException iOException) {}
            }
        }
        request2.setFixedLengthStreamingMode(0);
        request2.setRequestProperty("Content-Length", "0");
    }

    private <V> V sendJson(HttpURLConnection request2, Object params2, Type type2) throws IOException {
        this.sendParams(request2, params2);
        int code = request2.getResponseCode();
        this.updateRateLimits(request2);
        if (this.isOk(code)) {
            if (type2 != null) {
                return this.parseJson(this.getStream(request2), type2);
            }
            return null;
        }
        if (this.isEmpty(code)) {
            return null;
        }
        throw this.createException(this.getStream(request2), code, request2.getResponseMessage());
    }

    protected String createUri(String path) {
        return String.valueOf(this.baseUri) + this.configureUri(path);
    }

    public InputStream getStream(GitHubRequest request2) throws IOException {
        HttpURLConnection httpRequest = this.createGet(request2.generateUri());
        String accept = request2.getResponseContentType();
        if (accept != null) {
            httpRequest.setRequestProperty(HEADER_ACCEPT, accept);
        }
        return this.getResponseStream(httpRequest);
    }

    public InputStream postStream(String uri, Object params2) throws IOException {
        HttpURLConnection connection = this.createPost(uri);
        this.sendParams(connection, params2);
        return this.getResponseStream(connection);
    }

    protected InputStream getResponseStream(HttpURLConnection request2) throws IOException {
        InputStream stream = this.getStream(request2);
        int code = request2.getResponseCode();
        this.updateRateLimits(request2);
        if (this.isOk(code)) {
            return stream;
        }
        throw this.createException(stream, code, request2.getResponseMessage());
    }

    protected InputStream getStream(HttpURLConnection request2) throws IOException {
        if (request2.getResponseCode() < 400) {
            return request2.getInputStream();
        }
        InputStream stream = request2.getErrorStream();
        return stream != null ? stream : request2.getInputStream();
    }

    public GitHubResponse get(GitHubRequest request2) throws IOException {
        HttpURLConnection httpRequest = this.createGet(request2.generateUri());
        String accept = request2.getResponseContentType();
        if (accept != null) {
            httpRequest.setRequestProperty(HEADER_ACCEPT, accept);
        }
        int code = httpRequest.getResponseCode();
        this.updateRateLimits(httpRequest);
        if (this.isOk(code)) {
            return new GitHubResponse(httpRequest, this.getBody(request2, this.getStream(httpRequest)));
        }
        if (this.isEmpty(code)) {
            return new GitHubResponse(httpRequest, null);
        }
        throw this.createException(this.getStream(httpRequest), code, httpRequest.getResponseMessage());
    }

    public <V> V post(String uri, Object params2, Type type2) throws IOException {
        HttpURLConnection request2 = this.createPost(uri);
        return this.sendJson(request2, params2, type2);
    }

    public <V> V put(String uri, Object params2, Type type2) throws IOException {
        HttpURLConnection request2 = this.createPut(uri);
        return this.sendJson(request2, params2, type2);
    }

    public void delete(String uri, Object params2) throws IOException {
        HttpURLConnection request2 = this.createDelete(uri);
        if (params2 != null) {
            this.sendParams(request2, params2);
        }
        int code = request2.getResponseCode();
        this.updateRateLimits(request2);
        if (!this.isEmpty(code)) {
            throw new RequestException(this.parseError(this.getStream(request2)), code);
        }
    }

    protected GitHubClient updateRateLimits(HttpURLConnection request2) {
        String remaining;
        String limit = request2.getHeaderField("X-RateLimit-Limit");
        if (limit != null && limit.length() > 0) {
            try {
                this.requestLimit = Integer.parseInt(limit);
            }
            catch (NumberFormatException nfe) {
                this.requestLimit = -1;
            }
        } else {
            this.requestLimit = -1;
        }
        if ((remaining = request2.getHeaderField("X-RateLimit-Remaining")) != null && remaining.length() > 0) {
            try {
                this.remainingRequests = Integer.parseInt(remaining);
            }
            catch (NumberFormatException nfe) {
                this.remainingRequests = -1;
            }
        } else {
            this.remainingRequests = -1;
        }
        return this;
    }

    public int getRemainingRequests() {
        return this.remainingRequests;
    }

    public int getRequestLimit() {
        return this.requestLimit;
    }
}

