/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.github.core.client;

import java.lang.reflect.Type;
import java.util.Map;
import org.eclipse.egit.github.core.util.UrlUtils;

public class GitHubRequest {
    private String uri;
    private Map<String, String> params;
    private Type type;
    private String responseContentType;
    private Type arrayType;

    public GitHubRequest setArrayType(Type arrayType) {
        this.arrayType = arrayType;
        return this;
    }

    public Type getArrayType() {
        return this.arrayType;
    }

    public String getUri() {
        return this.uri;
    }

    protected void addParams(StringBuilder uri) {
        UrlUtils.addParams(this.getParams(), uri);
    }

    public String generateUri() {
        String baseUri = this.uri;
        if (baseUri == null) {
            return null;
        }
        if (baseUri.indexOf(63) != -1) {
            return baseUri;
        }
        StringBuilder params2 = new StringBuilder();
        this.addParams(params2);
        if (params2.length() > 0) {
            return String.valueOf(baseUri) + '?' + params2;
        }
        return baseUri;
    }

    public GitHubRequest setUri(StringBuilder uri) {
        return this.setUri(uri != null ? uri.toString() : null);
    }

    public GitHubRequest setUri(String uri) {
        this.uri = uri;
        return this;
    }

    public Map<String, String> getParams() {
        return this.params;
    }

    public GitHubRequest setParams(Map<String, String> params2) {
        this.params = params2;
        return this;
    }

    public Type getType() {
        return this.type;
    }

    public GitHubRequest setType(Type type2) {
        this.type = type2;
        return this;
    }

    public String getResponseContentType() {
        return this.responseContentType;
    }

    public GitHubRequest setResponseContentType(String responseContentType) {
        this.responseContentType = responseContentType;
        return this;
    }

    public int hashCode() {
        String fullUri = this.generateUri();
        return fullUri != null ? fullUri.hashCode() : super.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof GitHubRequest)) {
            return false;
        }
        String fullUri = this.generateUri();
        String objUri = ((GitHubRequest)obj).generateUri();
        return fullUri != null && objUri != null && fullUri.equals(objUri);
    }

    public String toString() {
        String fullUri = this.generateUri();
        return fullUri != null ? fullUri : super.toString();
    }
}

