/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.github.core.client;

import org.eclipse.egit.github.core.client.GitHubResponse;

public class PageLinks {
    private static final String DELIM_LINKS = ",";
    private static final String DELIM_LINK_PARAM = ";";
    private String first;
    private String last;
    private String next;
    private String prev;

    public PageLinks(GitHubResponse response2) {
        String linkHeader = response2.getHeader("Link");
        if (linkHeader != null) {
            String[] links;
            String[] stringArray = links = linkHeader.split(DELIM_LINKS);
            int n = links.length;
            int n2 = 0;
            while (n2 < n) {
                String linkPart;
                String link = stringArray[n2];
                String[] segments = link.split(DELIM_LINK_PARAM);
                if (segments.length >= 2 && (linkPart = segments[0].trim()).startsWith("<") && linkPart.endsWith(">")) {
                    linkPart = linkPart.substring(1, linkPart.length() - 1);
                    int i = 1;
                    while (i < segments.length) {
                        String[] rel = segments[i].trim().split("=");
                        if (rel.length >= 2 && "rel".equals(rel[0])) {
                            String relValue = rel[1];
                            if (relValue.startsWith("\"") && relValue.endsWith("\"")) {
                                relValue = relValue.substring(1, relValue.length() - 1);
                            }
                            if ("first".equals(relValue)) {
                                this.first = linkPart;
                            } else if ("last".equals(relValue)) {
                                this.last = linkPart;
                            } else if ("next".equals(relValue)) {
                                this.next = linkPart;
                            } else if ("prev".equals(relValue)) {
                                this.prev = linkPart;
                            }
                        }
                        ++i;
                    }
                }
                ++n2;
            }
        } else {
            this.next = response2.getHeader("X-Next");
            this.last = response2.getHeader("X-Last");
        }
    }

    public String getFirst() {
        return this.first;
    }

    public String getLast() {
        return this.last;
    }

    public String getNext() {
        return this.next;
    }

    public String getPrev() {
        return this.prev;
    }
}

