/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.github.core.service;

import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.lang.reflect.Type;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.egit.github.core.Comment;
import org.eclipse.egit.github.core.IRepositoryIdProvider;
import org.eclipse.egit.github.core.IResourceProvider;
import org.eclipse.egit.github.core.Issue;
import org.eclipse.egit.github.core.IssueEvent;
import org.eclipse.egit.github.core.Label;
import org.eclipse.egit.github.core.Milestone;
import org.eclipse.egit.github.core.RepositoryIssue;
import org.eclipse.egit.github.core.SearchIssue;
import org.eclipse.egit.github.core.User;
import org.eclipse.egit.github.core.client.GitHubClient;
import org.eclipse.egit.github.core.client.GitHubRequest;
import org.eclipse.egit.github.core.client.PageIterator;
import org.eclipse.egit.github.core.client.PagedRequest;
import org.eclipse.egit.github.core.service.GitHubService;

public class IssueService
extends GitHubService {
    public static final String FIELD_FILTER = "filter";
    public static final String FILTER_ASSIGNEE = "assignee";
    public static final String FILTER_MILESTONE = "milestone";
    public static final String FILTER_MENTIONED = "mentioned";
    public static final String FILTER_SUBSCRIBED = "subscribed";
    public static final String FILTER_CREATED = "created";
    public static final String FILTER_ASSIGNED = "assigned";
    public static final String FILTER_LABELS = "labels";
    public static final String FILTER_STATE = "state";
    public static final String STATE_OPEN = "open";
    public static final String STATE_CLOSED = "closed";
    public static final String FIELD_BODY = "body";
    public static final String FIELD_TITLE = "title";
    public static final String FIELD_SINCE = "since";
    public static final String FIELD_DIRECTION = "direction";
    public static final String DIRECTION_ASCENDING = "asc";
    public static final String DIRECTION_DESCENDING = "desc";
    public static final String FIELD_SORT = "sort";
    public static final String SORT_CREATED = "created";
    public static final String SORT_UPDATED = "updated";
    public static final String SORT_COMMENTS = "comments";

    public IssueService() {
    }

    public IssueService(GitHubClient client2) {
        super(client2);
    }

    public List<RepositoryIssue> getIssues() throws IOException {
        return this.getIssues(null);
    }

    public List<RepositoryIssue> getIssues(Map<String, String> filterData) throws IOException {
        return this.getAll(this.pageIssues(filterData));
    }

    public PageIterator<RepositoryIssue> pageIssues() {
        return this.pageIssues((Map<String, String>)null);
    }

    public PageIterator<RepositoryIssue> pageIssues(Map<String, String> filterData) {
        return this.pageIssues(filterData, 100);
    }

    public PageIterator<RepositoryIssue> pageIssues(Map<String, String> filterData, int size2) {
        return this.pageIssues(filterData, 1, size2);
    }

    public PageIterator<RepositoryIssue> pageIssues(Map<String, String> filterData, int start, int size2) {
        PagedRequest request2 = this.createPagedRequest(start, size2);
        request2.setParams(filterData);
        request2.setUri("/issues");
        request2.setType(new TypeToken<List<RepositoryIssue>>(){}.getType());
        return this.createPageIterator(request2);
    }

    public Issue getIssue(String user2, String repository, int issueNumber) throws IOException {
        return this.getIssue(user2, repository, Integer.toString(issueNumber));
    }

    public Issue getIssue(String user2, String repository, String issueNumber) throws IOException {
        this.verifyRepository(user2, repository);
        String repoId = String.valueOf(user2) + '/' + repository;
        return this.getIssue(repoId, issueNumber);
    }

    public Issue getIssue(IRepositoryIdProvider repository, int issueNumber) throws IOException {
        return this.getIssue(repository, Integer.toString(issueNumber));
    }

    public Issue getIssue(IRepositoryIdProvider repository, String issueNumber) throws IOException {
        String repoId = this.getId(repository);
        return this.getIssue(repoId, issueNumber);
    }

    private Issue getIssue(String repoId, String issueNumber) throws IOException {
        if (issueNumber == null) {
            throw new IllegalArgumentException("Issue number cannot be null");
        }
        if (issueNumber.length() == 0) {
            throw new IllegalArgumentException("Issue number cannot be empty");
        }
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(repoId);
        uri.append("/issues");
        uri.append('/').append(issueNumber);
        GitHubRequest request2 = this.createRequest();
        request2.setUri(uri);
        request2.setType((Type)((Object)Issue.class));
        return (Issue)this.client.get(request2).getBody();
    }

    public List<Comment> getComments(String user2, String repository, int issueNumber) throws IOException {
        return this.getComments(user2, repository, Integer.toString(issueNumber));
    }

    public List<Comment> getComments(String user2, String repository, String issueNumber) throws IOException {
        this.verifyRepository(user2, repository);
        String repoId = String.valueOf(user2) + '/' + repository;
        return this.getComments(repoId, issueNumber);
    }

    public List<Comment> getComments(IRepositoryIdProvider repository, int issueNumber) throws IOException {
        return this.getComments(repository, Integer.toString(issueNumber));
    }

    public List<Comment> getComments(IRepositoryIdProvider repository, String issueNumber) throws IOException {
        String repoId = this.getId(repository);
        return this.getComments(repoId, issueNumber);
    }

    private List<Comment> getComments(String repoId, String issueNumber) throws IOException {
        if (issueNumber == null) {
            throw new IllegalArgumentException("Issue number cannot be null");
        }
        if (issueNumber.length() == 0) {
            throw new IllegalArgumentException("Issue number cannot be empty");
        }
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(repoId);
        uri.append("/issues");
        uri.append('/').append(issueNumber);
        uri.append("/comments");
        PagedRequest request2 = this.createPagedRequest();
        request2.setUri(uri);
        request2.setType(new TypeToken<List<Comment>>(){}.getType());
        return this.getAll(request2);
    }

    protected PagedRequest<Issue> createIssuesRequest(String repoId, Map<String, String> filterData, int start, int size2) {
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(repoId);
        uri.append("/issues");
        PagedRequest<Issue> request2 = this.createPagedRequest(start, size2);
        request2.setParams(filterData).setUri(uri);
        request2.setType(new TypeToken<List<Issue>>(){}.getType());
        return request2;
    }

    public List<Issue> getIssues(String user2, String repository, Map<String, String> filterData) throws IOException {
        return this.getAll(this.pageIssues(user2, repository, filterData));
    }

    public List<Issue> getIssues(IRepositoryIdProvider repository, Map<String, String> filterData) throws IOException {
        return this.getAll(this.pageIssues(repository, filterData));
    }

    public PageIterator<Issue> pageIssues(String user2, String repository) {
        return this.pageIssues(user2, repository, null);
    }

    public PageIterator<Issue> pageIssues(String user2, String repository, Map<String, String> filterData) {
        return this.pageIssues(user2, repository, filterData, 100);
    }

    public PageIterator<Issue> pageIssues(String user2, String repository, Map<String, String> filterData, int size2) {
        return this.pageIssues(user2, repository, filterData, 1, size2);
    }

    public PageIterator<Issue> pageIssues(String user2, String repository, Map<String, String> filterData, int start, int size2) {
        this.verifyRepository(user2, repository);
        String repoId = String.valueOf(user2) + '/' + repository;
        PagedRequest<Issue> request2 = this.createIssuesRequest(repoId, filterData, start, size2);
        return this.createPageIterator(request2);
    }

    public PageIterator<Issue> pageIssues(IRepositoryIdProvider repository) {
        return this.pageIssues(repository, null);
    }

    public PageIterator<Issue> pageIssues(IRepositoryIdProvider repository, Map<String, String> filterData) {
        return this.pageIssues(repository, filterData, 100);
    }

    public PageIterator<Issue> pageIssues(IRepositoryIdProvider repository, Map<String, String> filterData, int size2) {
        return this.pageIssues(repository, filterData, 1, size2);
    }

    public PageIterator<Issue> pageIssues(IRepositoryIdProvider repository, Map<String, String> filterData, int start, int size2) {
        String repoId = this.getId(repository);
        PagedRequest<Issue> request2 = this.createIssuesRequest(repoId, filterData, start, size2);
        return this.createPageIterator(request2);
    }

    protected Map<Object, Object> createIssueMap(Issue issue, boolean newIssue) {
        HashMap<Object, Object> params2 = new HashMap<Object, Object>();
        if (issue != null) {
            List<Label> labels;
            Milestone milestone;
            params2.put(FIELD_BODY, issue.getBody());
            params2.put(FIELD_TITLE, issue.getTitle());
            User assignee = issue.getAssignee();
            if (assignee != null) {
                params2.put(FILTER_ASSIGNEE, assignee.getLogin());
            }
            if ((milestone = issue.getMilestone()) != null) {
                int number = milestone.getNumber();
                if (number > 0) {
                    params2.put(FILTER_MILESTONE, number);
                } else if (!newIssue) {
                    params2.put(FILTER_MILESTONE, null);
                }
            }
            if ((labels = issue.getLabels()) != null) {
                ArrayList<String> labelNames = new ArrayList<String>(labels.size());
                for (Label label : labels) {
                    labelNames.add(label.getName());
                }
                params2.put(FILTER_LABELS, labelNames);
            }
        }
        return params2;
    }

    public Issue createIssue(String user2, String repository, Issue issue) throws IOException {
        this.verifyRepository(user2, repository);
        String repoId = String.valueOf(user2) + '/' + repository;
        return this.createIssue(repoId, issue);
    }

    public Issue createIssue(IRepositoryIdProvider repository, Issue issue) throws IOException {
        String repoId = this.getId(repository);
        return this.createIssue(repoId, issue);
    }

    private Issue createIssue(String repoId, Issue issue) throws IOException {
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(repoId);
        uri.append("/issues");
        Map<Object, Object> params2 = this.createIssueMap(issue, true);
        return (Issue)this.client.post(uri.toString(), params2, (Type)((Object)Issue.class));
    }

    public Issue editIssue(String user2, String repository, Issue issue) throws IOException {
        this.verifyRepository(user2, repository);
        String repoId = String.valueOf(user2) + '/' + repository;
        return this.editIssue(repoId, issue);
    }

    public Issue editIssue(IRepositoryIdProvider repository, Issue issue) throws IOException {
        String repoId = this.getId(repository);
        return this.editIssue(repoId, issue);
    }

    private Issue editIssue(String repoId, Issue issue) throws IOException {
        if (issue == null) {
            throw new IllegalArgumentException("Issue cannot be null");
        }
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(repoId);
        uri.append("/issues");
        uri.append('/').append(issue.getNumber());
        Map<Object, Object> params2 = this.createIssueMap(issue, false);
        String state = issue.getState();
        if (state != null) {
            params2.put(FILTER_STATE, state);
        }
        return (Issue)this.client.post(uri.toString(), params2, (Type)((Object)Issue.class));
    }

    public Comment createComment(String user2, String repository, int issueNumber, String comment) throws IOException {
        return this.createComment(user2, repository, Integer.toString(issueNumber), comment);
    }

    public Comment createComment(String user2, String repository, String issueNumber, String comment) throws IOException {
        this.verifyRepository(user2, repository);
        String repoId = String.valueOf(user2) + '/' + repository;
        return this.createComment(repoId, issueNumber, comment);
    }

    public Comment createComment(IRepositoryIdProvider repository, int issueNumber, String comment) throws IOException {
        return this.createComment(repository, Integer.toString(issueNumber), comment);
    }

    public Comment createComment(IRepositoryIdProvider repository, String issueNumber, String comment) throws IOException {
        String repoId = this.getId(repository);
        return this.createComment(repoId, issueNumber, comment);
    }

    private Comment createComment(String repoId, String issueNumber, String comment) throws IOException {
        if (issueNumber == null) {
            throw new IllegalArgumentException("Issue number cannot be null");
        }
        if (issueNumber.length() == 0) {
            throw new IllegalArgumentException("Issue number cannot be empty");
        }
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(repoId);
        uri.append("/issues");
        uri.append('/').append(issueNumber);
        uri.append("/comments");
        HashMap<String, String> params2 = new HashMap<String, String>(1, 1.0f);
        params2.put(FIELD_BODY, comment);
        return (Comment)this.client.post(uri.toString(), params2, (Type)((Object)Comment.class));
    }

    public Comment getComment(String user2, String repository, long commentId) throws IOException {
        this.verifyRepository(user2, repository);
        GitHubRequest request2 = this.createRequest();
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(user2).append('/').append(repository);
        uri.append("/issues").append("/comments");
        uri.append('/').append(commentId);
        request2.setUri(uri);
        request2.setType((Type)((Object)Comment.class));
        return (Comment)this.client.get(request2).getBody();
    }

    public Comment editComment(String user2, String repository, Comment comment) throws IOException {
        this.verifyRepository(user2, repository);
        String repoId = String.valueOf(user2) + '/' + repository;
        return this.editComment(repoId, comment);
    }

    public Comment editComment(IRepositoryIdProvider repository, Comment comment) throws IOException {
        String repoId = this.getId(repository);
        return this.editComment(repoId, comment);
    }

    private Comment editComment(String repoId, Comment comment) throws IOException {
        if (comment == null) {
            throw new IllegalArgumentException("Comment cannot be null");
        }
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(repoId);
        uri.append("/issues").append("/comments");
        uri.append('/').append(comment.getId());
        return (Comment)this.client.post(uri.toString(), comment, (Type)((Object)Comment.class));
    }

    public void deleteComment(String user2, String repository, long commentId) throws IOException {
        this.deleteComment(user2, repository, Long.toString(commentId));
    }

    public void deleteComment(String user2, String repository, String commentId) throws IOException {
        this.verifyRepository(user2, repository);
        String repoId = String.valueOf(user2) + '/' + repository;
        this.deleteComment(repoId, commentId);
    }

    public void deleteComment(IRepositoryIdProvider repository, long commentId) throws IOException {
        this.deleteComment(repository, Long.toString(commentId));
    }

    public void deleteComment(IRepositoryIdProvider repository, String commentId) throws IOException {
        String repoId = this.getId(repository);
        this.deleteComment(repoId, commentId);
    }

    private void deleteComment(String repoId, String commentId) throws IOException {
        if (commentId == null) {
            throw new IllegalArgumentException("Comment cannot be null");
        }
        if (commentId.length() == 0) {
            throw new IllegalArgumentException("Comment cannot be empty");
        }
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(repoId);
        uri.append("/issues").append("/comments");
        uri.append('/').append(commentId);
        this.client.delete(uri.toString());
    }

    public PageIterator<IssueEvent> pageEvents(String user2, String repository) {
        return this.pageEvents(user2, repository, 100);
    }

    public PageIterator<IssueEvent> pageEvents(String user2, String repository, int size2) {
        return this.pageEvents(user2, repository, 1, size2);
    }

    public PageIterator<IssueEvent> pageEvents(String user2, String repository, int start, int size2) {
        this.verifyRepository(user2, repository);
        PagedRequest request2 = this.createPagedRequest(start, size2);
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(user2).append('/').append(repository);
        uri.append("/issues");
        uri.append("/events");
        request2.setUri(uri);
        request2.setType(new TypeToken<List<IssueEvent>>(){}.getType());
        return this.createPageIterator(request2);
    }

    public PageIterator<IssueEvent> pageIssueEvents(String user2, String repository, int issueId) {
        return this.pageIssueEvents(user2, repository, issueId, 100);
    }

    public PageIterator<IssueEvent> pageIssueEvents(String user2, String repository, int issueId, int size2) {
        return this.pageIssueEvents(user2, repository, issueId, 1, size2);
    }

    public PageIterator<IssueEvent> pageIssueEvents(String user2, String repository, int issueId, int start, int size2) {
        this.verifyRepository(user2, repository);
        PagedRequest request2 = this.createPagedRequest(start, size2);
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(user2).append('/').append(repository);
        uri.append("/issues");
        uri.append('/').append(issueId);
        uri.append("/events");
        request2.setUri(uri);
        request2.setType(new TypeToken<List<IssueEvent>>(){}.getType());
        return this.createPageIterator(request2);
    }

    public IssueEvent getIssueEvent(String user2, String repository, long eventId) throws IOException {
        this.verifyRepository(user2, repository);
        GitHubRequest request2 = this.createRequest();
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(user2).append('/').append(repository);
        uri.append("/issues");
        uri.append("/events");
        uri.append('/').append(eventId);
        request2.setUri(uri);
        request2.setType((Type)((Object)IssueEvent.class));
        return (IssueEvent)this.client.get(request2).getBody();
    }

    public List<SearchIssue> searchIssues(IRepositoryIdProvider repository, String state, String query) throws IOException {
        String id2 = this.getId(repository);
        if (state == null) {
            throw new IllegalArgumentException("State cannot be null");
        }
        if (state.length() == 0) {
            throw new IllegalArgumentException("State cannot be empty");
        }
        if (query == null) {
            throw new IllegalArgumentException("Query cannot be null");
        }
        if (query.length() == 0) {
            throw new IllegalArgumentException("Query cannot be empty");
        }
        StringBuilder uri = new StringBuilder("/legacy/issues/search");
        uri.append('/').append(id2);
        uri.append('/').append(state);
        String encodedQuery = URLEncoder.encode(query, "UTF-8").replace("+", "%20").replace(".", "%2E");
        uri.append('/').append(encodedQuery);
        PagedRequest request2 = this.createPagedRequest();
        request2.setUri(uri);
        request2.setType((Type)((Object)IssueContainer.class));
        return this.getAll(request2);
    }

    private static class IssueContainer
    implements IResourceProvider<SearchIssue> {
        private List<SearchIssue> issues;

        private IssueContainer() {
        }

        @Override
        public List<SearchIssue> getResources() {
            return this.issues;
        }
    }
}

