/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.github.core.service;

import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import org.eclipse.egit.github.core.User;
import org.eclipse.egit.github.core.client.GitHubClient;
import org.eclipse.egit.github.core.client.GitHubRequest;
import org.eclipse.egit.github.core.client.PagedRequest;
import org.eclipse.egit.github.core.service.GitHubService;

public class OrganizationService
extends GitHubService {
    public OrganizationService() {
    }

    public OrganizationService(GitHubClient client2) {
        super(client2);
    }

    protected PagedRequest<User> createOrgRequest(String user2, int start, int size2) {
        PagedRequest<User> request2 = new PagedRequest<User>(start, size2);
        if (user2 == null) {
            request2.setUri("/user/orgs");
        } else {
            StringBuilder uri = new StringBuilder("/users");
            uri.append('/').append(user2);
            uri.append("/orgs");
            request2.setUri(uri);
        }
        request2.setType(new TypeToken<List<User>>(){}.getType());
        return request2;
    }

    public List<User> getOrganizations() throws IOException {
        PagedRequest<User> request2 = this.createOrgRequest(null, 1, 100);
        return this.getAll(request2);
    }

    public List<User> getOrganizations(String user2) throws IOException {
        if (user2 == null) {
            throw new IllegalArgumentException("User cannot be null");
        }
        if (user2.length() == 0) {
            throw new IllegalArgumentException("User cannot be empty");
        }
        PagedRequest<User> request2 = this.createOrgRequest(user2, 1, 100);
        return this.getAll(request2);
    }

    public User getOrganization(String name) throws IOException {
        if (name == null) {
            throw new IllegalArgumentException("Name cannot be null");
        }
        if (name.length() == 0) {
            throw new IllegalArgumentException("Name cannot be empty");
        }
        StringBuilder uri = new StringBuilder("/orgs");
        uri.append('/').append(name);
        GitHubRequest request2 = this.createRequest();
        request2.setUri(uri);
        request2.setType((Type)((Object)User.class));
        return (User)this.client.get(request2).getBody();
    }

    public User editOrganization(User organization) throws IOException {
        if (organization == null) {
            throw new IllegalArgumentException("Organization cannot be null");
        }
        String name = organization.getLogin();
        if (name == null) {
            throw new IllegalArgumentException("Organization login cannot be null");
        }
        if (name.length() == 0) {
            throw new IllegalArgumentException("Organization login cannot be empty");
        }
        StringBuilder uri = new StringBuilder("/orgs");
        uri.append('/').append(name);
        return (User)this.client.post(uri.toString(), organization, (Type)((Object)User.class));
    }

    public List<User> getMembers(String organization) throws IOException {
        return this.getMembers(organization, null);
    }

    public List<User> getMembers(String organization, RoleFilter roleFilter) throws IOException {
        if (organization == null) {
            throw new IllegalArgumentException("Organization cannot be null");
        }
        if (organization.length() == 0) {
            throw new IllegalArgumentException("Organization cannot be empty");
        }
        HashMap<String, String> params2 = new HashMap<String, String>();
        if (roleFilter != null) {
            params2.put("role", roleFilter.toString());
        }
        StringBuilder uri = new StringBuilder("/orgs");
        uri.append('/').append(organization);
        uri.append("/members");
        PagedRequest request2 = this.createPagedRequest();
        request2.setParams(params2);
        request2.setUri(uri);
        request2.setType(new TypeToken<List<User>>(){}.getType());
        return this.getAll(request2);
    }

    public List<User> getPublicMembers(String organization) throws IOException {
        if (organization == null) {
            throw new IllegalArgumentException("Organization cannot be null");
        }
        if (organization.length() == 0) {
            throw new IllegalArgumentException("Organization cannot be empty");
        }
        StringBuilder uri = new StringBuilder("/orgs");
        uri.append('/').append(organization);
        uri.append("/public_members");
        PagedRequest request2 = this.createPagedRequest();
        request2.setUri(uri);
        request2.setType(new TypeToken<List<User>>(){}.getType());
        return this.getAll(request2);
    }

    public boolean isMember(String organization, String user2) throws IOException {
        if (organization == null) {
            throw new IllegalArgumentException("Organization cannot be null");
        }
        if (organization.length() == 0) {
            throw new IllegalArgumentException("Organization cannot be empty");
        }
        if (user2 == null) {
            throw new IllegalArgumentException("User cannot be null");
        }
        if (user2.length() == 0) {
            throw new IllegalArgumentException("User cannot be empty");
        }
        StringBuilder uri = new StringBuilder("/orgs");
        uri.append('/').append(organization);
        uri.append("/members");
        uri.append('/').append(user2);
        return this.check(uri.toString());
    }

    public boolean isPublicMember(String organization, String user2) throws IOException {
        if (organization == null) {
            throw new IllegalArgumentException("Organization cannot be null");
        }
        if (organization.length() == 0) {
            throw new IllegalArgumentException("Organization cannot be empty");
        }
        if (user2 == null) {
            throw new IllegalArgumentException("User cannot be null");
        }
        if (user2.length() == 0) {
            throw new IllegalArgumentException("User cannot be empty");
        }
        StringBuilder uri = new StringBuilder("/orgs");
        uri.append('/').append(organization);
        uri.append("/public_members");
        uri.append('/').append(user2);
        return this.check(uri.toString());
    }

    public void showMembership(String organization, String user2) throws IOException {
        if (organization == null) {
            throw new IllegalArgumentException("Organization cannot be null");
        }
        if (organization.length() == 0) {
            throw new IllegalArgumentException("Organization cannot be empty");
        }
        if (user2 == null) {
            throw new IllegalArgumentException("User cannot be null");
        }
        if (user2.length() == 0) {
            throw new IllegalArgumentException("User cannot be empty");
        }
        StringBuilder uri = new StringBuilder("/orgs");
        uri.append('/').append(organization);
        uri.append("/public_members");
        uri.append('/').append(user2);
        this.client.put(uri.toString());
    }

    public void hideMembership(String organization, String user2) throws IOException {
        if (organization == null) {
            throw new IllegalArgumentException("Organization cannot be null");
        }
        if (organization.length() == 0) {
            throw new IllegalArgumentException("Organization cannot be empty");
        }
        if (user2 == null) {
            throw new IllegalArgumentException("User cannot be null");
        }
        if (user2.length() == 0) {
            throw new IllegalArgumentException("User cannot be empty");
        }
        StringBuilder uri = new StringBuilder("/orgs");
        uri.append('/').append(organization);
        uri.append("/public_members");
        uri.append('/').append(user2);
        this.client.delete(uri.toString());
    }

    public void removeMember(String organization, String user2) throws IOException {
        if (organization == null) {
            throw new IllegalArgumentException("Organization cannot be null");
        }
        if (organization.length() == 0) {
            throw new IllegalArgumentException("Organization cannot be empty");
        }
        if (user2 == null) {
            throw new IllegalArgumentException("User cannot be null");
        }
        if (user2.length() == 0) {
            throw new IllegalArgumentException("User cannot be empty");
        }
        StringBuilder uri = new StringBuilder("/orgs");
        uri.append('/').append(organization);
        uri.append("/members");
        uri.append('/').append(user2);
        this.client.delete(uri.toString());
    }

    public static enum RoleFilter {
        all,
        admin,
        member;

    }
}

