/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.hooks;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.Callable;
import org.bouncycastle.util.io.TeeOutputStream;
import org.eclipse.jgit.api.errors.AbortedByHookException;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.ProcessResult;

abstract class GitHook<T>
implements Callable<T> {
    private final Repository repo;
    protected final PrintStream outputStream;
    protected final PrintStream errorStream;

    protected GitHook(Repository repo, PrintStream outputStream2) {
        this(repo, outputStream2, null);
    }

    protected GitHook(Repository repo, PrintStream outputStream2, PrintStream errorStream) {
        this.repo = repo;
        this.outputStream = outputStream2;
        this.errorStream = errorStream;
    }

    @Override
    public abstract T call() throws IOException, AbortedByHookException;

    public abstract String getHookName();

    protected Repository getRepository() {
        return this.repo;
    }

    protected String[] getParameters() {
        return new String[0];
    }

    protected String getStdinArgs() {
        return null;
    }

    protected PrintStream getOutputStream() {
        return this.outputStream == null ? System.out : this.outputStream;
    }

    protected PrintStream getErrorStream() {
        return this.errorStream == null ? System.err : this.errorStream;
    }

    protected void doRun() throws AbortedByHookException {
        ProcessResult result2;
        ByteArrayOutputStream errorByteArray = new ByteArrayOutputStream();
        TeeOutputStream stderrStream = new TeeOutputStream(errorByteArray, this.getErrorStream());
        PrintStream hookErrRedirect = null;
        try {
            hookErrRedirect = new PrintStream((OutputStream)stderrStream, false, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        Repository repository = this.getRepository();
        FS fs = repository.getFS();
        if (fs == null) {
            fs = FS.DETECTED;
        }
        if ((result2 = fs.runHookIfPresent(repository, this.getHookName(), this.getParameters(), this.getOutputStream(), hookErrRedirect, this.getStdinArgs())).isExecutedWithError()) {
            throw new AbortedByHookException(new String(errorByteArray.toByteArray(), StandardCharsets.UTF_8), this.getHookName(), result2.getExitCode());
        }
    }

    public boolean isNativeHookPresent() {
        FS fs = this.getRepository().getFS();
        if (fs == null) {
            fs = FS.DETECTED;
        }
        return fs.findHook(this.getRepository(), this.getHookName()) != null;
    }
}

