/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.nls;

import java.util.Locale;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.jgit.nls.GlobalBundleCache;
import org.eclipse.jgit.nls.TranslationBundle;

public class NLS {
    public static final Locale ROOT_LOCALE = new Locale("", "", "");
    private static final InheritableThreadLocal<NLS> local = new InheritableThreadLocal();
    private final Locale locale;
    private final ConcurrentHashMap<Class, TranslationBundle> map = new ConcurrentHashMap();

    public static void setLocale(Locale locale) {
        local.set(new NLS(locale));
    }

    public static void useJVMDefaultLocale() {
        NLS.useJVMDefaultInternal();
    }

    private static NLS useJVMDefaultInternal() {
        NLS b = new NLS(Locale.getDefault());
        local.set(b);
        return b;
    }

    public static <T extends TranslationBundle> T getBundleFor(Class<T> type2) {
        NLS b = (NLS)local.get();
        if (b == null) {
            b = NLS.useJVMDefaultInternal();
        }
        return b.get(type2);
    }

    private NLS(Locale locale) {
        this.locale = locale;
    }

    private <T extends TranslationBundle> T get(Class<T> type2) {
        TranslationBundle old;
        TranslationBundle bundle = this.map.get(type2);
        if (bundle == null && (old = this.map.putIfAbsent(type2, bundle = GlobalBundleCache.lookupBundle(this.locale, type2))) != null) {
            bundle = old;
        }
        return (T)bundle;
    }
}

