/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.util.io;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.jgit.diff.RawText;

public class AutoLFInputStream
extends InputStream {
    private final byte[] single = new byte[1];
    private final byte[] buf = new byte[8096];
    private final InputStream in;
    private int cnt;
    private int ptr;
    private boolean isBinary;
    private boolean detectBinary;
    private boolean abortIfBinary;

    public AutoLFInputStream(InputStream in, boolean detectBinary) {
        this(in, detectBinary, false);
    }

    public AutoLFInputStream(InputStream in, boolean detectBinary, boolean abortIfBinary) {
        this.in = in;
        this.detectBinary = detectBinary;
        this.abortIfBinary = abortIfBinary;
    }

    @Override
    public int read() throws IOException {
        int read2 = this.read(this.single, 0, 1);
        return read2 == 1 ? this.single[0] & 0xFF : -1;
    }

    @Override
    public int read(byte[] bs, int off, int len) throws IOException {
        if (len == 0) {
            return 0;
        }
        if (this.cnt == -1) {
            return -1;
        }
        int i = off;
        int end = off + len;
        while (i < end) {
            if (this.ptr == this.cnt && !this.fillBuffer()) break;
            byte b = this.buf[this.ptr++];
            if (this.isBinary || b != 13) {
                bs[i++] = b;
                continue;
            }
            if (this.ptr == this.cnt && !this.fillBuffer()) {
                bs[i++] = 13;
                break;
            }
            if (this.buf[this.ptr] == 10) {
                bs[i++] = 10;
                ++this.ptr;
                continue;
            }
            bs[i++] = 13;
        }
        return i == off ? -1 : i - off;
    }

    public boolean isBinary() {
        return this.isBinary;
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    private boolean fillBuffer() throws IOException {
        this.cnt = 0;
        while (this.cnt < this.buf.length) {
            int n = this.in.read(this.buf, this.cnt, this.buf.length - this.cnt);
            if (n < 0) break;
            this.cnt += n;
        }
        if (this.cnt < 1) {
            this.cnt = -1;
            return false;
        }
        if (this.detectBinary) {
            this.isBinary = RawText.isBinary(this.buf, this.cnt);
            this.detectBinary = false;
            if (this.isBinary && this.abortIfBinary) {
                throw new IsBinaryException();
            }
        }
        this.ptr = 0;
        return true;
    }

    public static class IsBinaryException
    extends IOException {
        private static final long serialVersionUID = 1L;

        IsBinaryException() {
        }
    }
}

