/*
 * Decompiled with CFR 0.152.
 */
package org.danilopianini.upgradle;

import java.io.File;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.danilopianini.upgradle.UpGradle;
import org.danilopianini.upgradle.api.Change;
import org.danilopianini.upgradle.api.Credentials;
import org.danilopianini.upgradle.api.OnFile;
import org.danilopianini.upgradle.api.Operation;
import org.danilopianini.upgradle.api.Pattern;
import org.danilopianini.upgradle.config.CommitAuthor;
import org.danilopianini.upgradle.remote.Branch;
import org.danilopianini.upgradle.remote.Repository;
import org.eclipse.egit.github.core.IRepositoryIdProvider;
import org.eclipse.egit.github.core.Label;
import org.eclipse.egit.github.core.PullRequest;
import org.eclipse.egit.github.core.PullRequestMarker;
import org.eclipse.egit.github.core.SearchRepository;
import org.eclipse.egit.github.core.service.GitHubService;
import org.eclipse.egit.github.core.service.LabelService;
import org.eclipse.egit.github.core.service.PullRequestService;
import org.eclipse.jgit.api.AddCommand;
import org.eclipse.jgit.api.CloneCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.PushCommand;
import org.eclipse.jgit.api.TransportCommand;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.transport.PushResult;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.RemoteRefUpdate;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u001a(\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001*\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u001a(\u0010\t\u001a\u00020\n*\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012\u001a\f\u0010\u0013\u001a\u00020\u0014*\u00020\u000bH\u0002\u001a\"\u0010\u0015\u001a\u00020\u0003*\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0012\u001a\"\u0010\u0019\u001a\n \u0002*\u0004\u0018\u00010\u001a0\u001a*\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e\u001a2\u0010\u001f\u001a\n \u0002*\u0004\u0018\u00010\u00100\u0010*\u00020\u000b2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020\u001c2\u0006\u0010\u0011\u001a\u00020\u0012\u001a \u0010$\u001a\b\u0012\u0004\u0012\u00020&0%*\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u001c2\u0006\u0010\u0011\u001a\u00020\u0012\u00a8\u0006'"}, d2={"add", "Lorg/eclipse/jgit/dircache/DirCache;", "kotlin.jvm.PlatformType", "Lorg/eclipse/jgit/api/Git;", "location", "Ljava/io/File;", "changes", "", "Lorg/danilopianini/upgradle/api/Change;", "applyLabels", "", "Lorg/danilopianini/upgradle/remote/Repository;", "labels", "", "Lorg/eclipse/egit/github/core/Label;", "pr", "Lorg/eclipse/egit/github/core/PullRequest;", "credentials", "Lorg/danilopianini/upgradle/api/Credentials;", "asIdProvider", "Lorg/eclipse/egit/github/core/IRepositoryIdProvider;", "clone", "branch", "Lorg/danilopianini/upgradle/remote/Branch;", "destination", "commit", "Lorg/eclipse/jgit/revwalk/RevCommit;", "message", "", "author", "Lorg/danilopianini/upgradle/config/CommitAuthor;", "createPullRequest", "update", "Lorg/danilopianini/upgradle/api/Operation;", "head", "base", "pushTo", "", "Lorg/eclipse/jgit/transport/RemoteRefUpdate;", "upgradle"})
public final class GitKt {
    @NotNull
    public static final Git clone(@NotNull Repository $this$clone, @NotNull Branch branch, @NotNull File destination, @NotNull Credentials credentials2) {
        Intrinsics.checkParameterIsNotNull((Object)$this$clone, (String)"$this$clone");
        Intrinsics.checkParameterIsNotNull((Object)branch, (String)"branch");
        Intrinsics.checkParameterIsNotNull((Object)destination, (String)"destination");
        Intrinsics.checkParameterIsNotNull((Object)credentials2, (String)"credentials");
        Git git = ((CloneCommand)Credentials.Companion.authenticated((TransportCommand)Git.cloneRepository(), credentials2)).setURI($this$clone.getCloneUri()).setBranch(branch.getName()).setDirectory(destination).call();
        Intrinsics.checkExpressionValueIsNotNull((Object)git, (String)"Git.cloneRepository()\n  \u2026tination)\n        .call()");
        return git;
    }

    public static final DirCache add(@NotNull Git $this$add, @NotNull File location, @NotNull Iterable<? extends Change> changes) {
        Intrinsics.checkParameterIsNotNull((Object)$this$add, (String)"$this$add");
        Intrinsics.checkParameterIsNotNull((Object)location, (String)"location");
        Intrinsics.checkParameterIsNotNull(changes, (String)"changes");
        AddCommand addCommand = $this$add.add();
        boolean bl = false;
        boolean bl2 = false;
        AddCommand $this$apply = addCommand;
        boolean bl3 = false;
        Iterable<? extends Change> $this$forEach$iv = changes;
        boolean $i$f$forEach = false;
        Iterator<? extends Change> iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            String string;
            Change element$iv;
            Change it = element$iv = iterator.next();
            boolean bl4 = false;
            Change change = it;
            if (change instanceof OnFile) {
                string = FilesKt.relativeTo((File)((OnFile)it).getFile(), (File)location).getPath();
            } else if (change instanceof Pattern) {
                String string2 = ((Pattern)it).getPattern();
                String string3 = location.getAbsolutePath();
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"location.absolutePath");
                string = StringsKt.replace$default((String)string2, (String)string3, (String)"", (boolean)false, (int)4, null);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            $this$apply.addFilepattern(string);
        }
        return addCommand.call();
    }

    public static final RevCommit commit(@NotNull Git $this$commit, @NotNull String message, @NotNull CommitAuthor author) {
        Intrinsics.checkParameterIsNotNull((Object)$this$commit, (String)"$this$commit");
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        Intrinsics.checkParameterIsNotNull((Object)author, (String)"author");
        return $this$commit.commit().setMessage(message).setAuthor(new PersonIdent(author.getName(), author.getEmail())).call();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<RemoteRefUpdate> pushTo(@NotNull Git $this$pushTo, @NotNull String branch, @NotNull Credentials credentials2) {
        void $this$flatMapTo$iv$iv;
        Object object;
        Object object2;
        Intrinsics.checkParameterIsNotNull((Object)$this$pushTo, (String)"$this$pushTo");
        Intrinsics.checkParameterIsNotNull((Object)branch, (String)"branch");
        Intrinsics.checkParameterIsNotNull((Object)credentials2, (String)"credentials");
        PushCommand pushCommand = ((PushCommand)Credentials.Companion.authenticated((TransportCommand)$this$pushTo.push(), credentials2)).setForce(false).setRemote("origin").setRefSpecs(new RefSpec[]{new RefSpec(branch)});
        boolean bl = false;
        boolean bl2 = false;
        PushCommand it = pushCommand;
        boolean bl3 = false;
        Object object3 = $this$pushTo;
        boolean bl4 = false;
        try {
            object2 = Result.Companion;
            Object $this$runCatching = object3;
            boolean bl5 = false;
            $this$runCatching = it.call();
            bl5 = false;
            object2 = Result.constructor-impl((Object)$this$runCatching);
        }
        catch (Throwable $this$runCatching) {
            Result.Companion bl5 = Result.Companion;
            boolean bl6 = false;
            object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)$this$runCatching));
        }
        object3 = object2;
        bl4 = false;
        boolean bl7 = false;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object3);
        if (throwable == null) {
            object = object3;
        } else {
            Throwable it2 = throwable;
            boolean bl8 = false;
            UpGradle.Companion.getLogger$upgradle().warn("Push failed: is the project archived?", it2);
            object = CollectionsKt.emptyList();
        }
        Iterable iterable = (Iterable)object;
        Intrinsics.checkExpressionValueIsNotNull((Object)iterable, (String)"push()\n    .authenticate\u2026ptyList()\n        }\n    }");
        Iterable $this$flatMap$iv = iterable;
        boolean $i$f$flatMap = false;
        Iterable iterable2 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            PushResult it3 = (PushResult)element$iv$iv;
            boolean bl9 = false;
            PushResult pushResult = it3;
            Intrinsics.checkExpressionValueIsNotNull((Object)pushResult, (String)"it");
            Iterable list$iv$iv = pushResult.getRemoteUpdates();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public static final PullRequest createPullRequest(@NotNull Repository $this$createPullRequest, @NotNull Operation update, @NotNull String head, @NotNull String base, @NotNull Credentials credentials2) {
        Intrinsics.checkParameterIsNotNull((Object)$this$createPullRequest, (String)"$this$createPullRequest");
        Intrinsics.checkParameterIsNotNull((Object)update, (String)"update");
        Intrinsics.checkParameterIsNotNull((Object)head, (String)"head");
        Intrinsics.checkParameterIsNotNull((Object)base, (String)"base");
        Intrinsics.checkParameterIsNotNull((Object)credentials2, (String)"credentials");
        return ((PullRequestService)Credentials.Companion.authenticated((GitHubService)new PullRequestService(), credentials2)).createPullRequest(GitKt.asIdProvider($this$createPullRequest), new PullRequest().setBase(new PullRequestMarker().setRef(base).setLabel(base)).setHead(new PullRequestMarker().setRef(head).setLabel(head)).setTitle(update.getPullRequestTitle()).setBody(update.getPullRequestMessage()).setBodyText(update.getPullRequestMessage()));
    }

    /*
     * WARNING - void declaration
     */
    public static final void applyLabels(@NotNull Repository $this$applyLabels, @NotNull Collection<? extends Label> labels, @NotNull PullRequest pr, @NotNull Credentials credentials2) {
        Intrinsics.checkParameterIsNotNull((Object)$this$applyLabels, (String)"$this$applyLabels");
        Intrinsics.checkParameterIsNotNull(labels, (String)"labels");
        Intrinsics.checkParameterIsNotNull((Object)pr, (String)"pr");
        Intrinsics.checkParameterIsNotNull((Object)credentials2, (String)"credentials");
        Collection<? extends Label> collection = labels;
        boolean bl = false;
        if (!collection.isEmpty()) {
            Collection<String> collection2;
            String string;
            Label desiredLabel;
            Collection collection3;
            Iterable $this$mapTo$iv$iv;
            LabelService labelService = (LabelService)Credentials.Companion.authenticated((GitHubService)new LabelService(), credentials2);
            List availableLabels = labelService.getLabels(GitKt.asIdProvider($this$applyLabels));
            Iterable $this$map$iv = labels;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                Object object;
                Object v3;
                boolean bl2;
                Iterable iterable2;
                block5: {
                    Label label = (Label)item$iv$iv;
                    collection3 = destination$iv$iv;
                    boolean bl3 = false;
                    List list = availableLabels;
                    Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"availableLabels");
                    iterable2 = list;
                    bl2 = false;
                    Iterable iterable3 = iterable2;
                    boolean bl4 = false;
                    for (Object t : iterable3) {
                        Label it = (Label)t;
                        boolean bl5 = false;
                        String string2 = desiredLabel.getName();
                        Label label2 = it;
                        Intrinsics.checkExpressionValueIsNotNull((Object)label2, (String)"it");
                        if (!Intrinsics.areEqual((Object)string2, (Object)label2.getName())) continue;
                        v3 = t;
                        break block5;
                    }
                    v3 = null;
                }
                if ((object = (Label)v3) == null) {
                    iterable2 = labelService.createLabel(GitKt.asIdProvider($this$applyLabels), desiredLabel);
                    bl2 = false;
                    boolean bl6 = false;
                    Iterable it = iterable2;
                    boolean bl7 = false;
                    UpGradle.Companion.getLogger$upgradle().info("Created new label " + desiredLabel);
                    object = iterable2;
                }
                string = object;
                collection3.add(string);
            }
            List actualLabels = (List)destination$iv$iv;
            $this$map$iv = actualLabels;
            String string3 = "labels";
            string = "/repos/" + $this$applyLabels.getOwner() + '/' + $this$applyLabels.getName() + "/issues/" + pr.getNumber() + "/labels";
            collection3 = labelService.getClient();
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                desiredLabel = (Label)item$iv$iv;
                collection2 = destination$iv$iv;
                boolean bl8 = false;
                void v5 = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)v5, (String)"it");
                String string4 = v5.getName();
                collection2.add(string4);
            }
            collection2 = (List)destination$iv$iv;
            collection3.post(string, MapsKt.mapOf((Pair)TuplesKt.to((Object)string3, (Object)collection2)), (Type)((Object)List.class));
        }
    }

    private static final IRepositoryIdProvider asIdProvider(@NotNull Repository $this$asIdProvider) {
        return $this$asIdProvider instanceof IRepositoryIdProvider ? (IRepositoryIdProvider)$this$asIdProvider : (IRepositoryIdProvider)new SearchRepository($this$asIdProvider.getOwner(), $this$asIdProvider.getName());
    }
}

