/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.joran.action;

import ch.qos.logback.core.joran.action.Action;
import ch.qos.logback.core.joran.spi.ActionException;
import ch.qos.logback.core.joran.spi.InterpretationContext;
import ch.qos.logback.core.model.Model;
import org.xml.sax.Attributes;

public abstract class BaseModelAction
extends Action {
    Model parentModel;
    Model currentModel;
    boolean inError = false;

    @Override
    public void begin(InterpretationContext intercon, String name, Attributes attributes) throws ActionException {
        this.parentModel = null;
        this.inError = false;
        if (!this.validPreconditions(intercon, name, attributes)) {
            this.inError = true;
            return;
        }
        this.currentModel = this.buildCurrentModel(intercon, name, attributes);
        this.currentModel.setTag(name);
        if (!intercon.isModelStackEmpty()) {
            this.parentModel = intercon.peekModel();
        }
        int lineNumber = BaseModelAction.getLineNumber(intercon);
        this.currentModel.setLineNumber(lineNumber);
        intercon.pushModel(this.currentModel);
    }

    protected abstract Model buildCurrentModel(InterpretationContext var1, String var2, Attributes var3);

    protected boolean validPreconditions(InterpretationContext intercon, String name, Attributes attributes) {
        return true;
    }

    @Override
    public void body(InterpretationContext ec, String body2) {
        String finalBody = ec.subst(body2);
        this.currentModel.addText(finalBody);
    }

    @Override
    public void end(InterpretationContext interpretationContext, String name) throws ActionException {
        if (this.inError) {
            return;
        }
        Model m3 = interpretationContext.peekModel();
        if (m3 != this.currentModel) {
            this.addWarn("The object at the of the stack is not the model [" + this.currentModel.idString() + "] pushed earlier.");
            this.addWarn("This is wholly unexpected.");
        }
        if (this.parentModel != null) {
            this.parentModel.addSubModel(this.currentModel);
            interpretationContext.popModel();
        }
    }
}

