/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.joran.action;

import ch.qos.logback.core.joran.action.Action;
import ch.qos.logback.core.joran.spi.ActionException;
import ch.qos.logback.core.joran.spi.InterpretationContext;
import ch.qos.logback.core.spi.BasicSequenceNumberGenerator;
import ch.qos.logback.core.spi.SequenceNumberGenerator;
import ch.qos.logback.core.util.OptionHelper;
import org.xml.sax.Attributes;

public class SequenceNumberGeneratorAction
extends Action {
    SequenceNumberGenerator sequenceNumberGenerator;
    private boolean inError;

    @Override
    public void begin(InterpretationContext ic, String name, Attributes attributes) throws ActionException {
        this.sequenceNumberGenerator = null;
        this.inError = false;
        String className = attributes.getValue("class");
        if (OptionHelper.isNullOrEmpty(className)) {
            className = BasicSequenceNumberGenerator.class.getName();
            this.addInfo("Assuming className [" + className + "]");
        }
        try {
            this.addInfo("About to instantiate SequenceNumberGenerator of type [" + className + "]");
            this.sequenceNumberGenerator = (SequenceNumberGenerator)OptionHelper.instantiateByClassName(className, SequenceNumberGenerator.class, this.context);
            this.sequenceNumberGenerator.setContext(this.context);
            ic.pushObject(this.sequenceNumberGenerator);
        }
        catch (Exception e) {
            this.inError = true;
            this.addError("Could not create a SequenceNumberGenerator of type [" + className + "].", e);
            throw new ActionException(e);
        }
    }

    @Override
    public void end(InterpretationContext ic, String name) throws ActionException {
        if (this.inError) {
            return;
        }
        Object o = ic.peekObject();
        if (o != this.sequenceNumberGenerator) {
            this.addWarn("The object at the of the stack is not the hook pushed earlier.");
        } else {
            ic.popObject();
            this.addInfo("Registering sequenceNumberGenerator with context.");
            this.context.setSequenceNumberGenerator(this.sequenceNumberGenerator);
        }
    }
}

