/*
 * Decompiled with CFR 0.152.
 */
package checkers.flow;

import checkers.basetype.BaseTypeChecker;
import checkers.flow.CFAbstractStore;
import checkers.flow.CFAbstractTransfer;
import checkers.flow.CFAbstractValue;
import checkers.flow.CFValue;
import checkers.source.SourceChecker;
import checkers.types.AbstractBasicAnnotatedTypeFactory;
import checkers.types.AnnotatedTypeMirror;
import checkers.types.QualifierHierarchy;
import checkers.types.TypeHierarchy;
import checkers.util.AnnotatedTypes;
import dataflow.analysis.Analysis;
import dataflow.cfg.CFGDOTVisualizer;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import javacutils.ErrorReporter;
import javacutils.Pair;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;

public abstract class CFAbstractAnalysis<V extends CFAbstractValue<V>, S extends CFAbstractStore<V, S>, T extends CFAbstractTransfer<V, S, T>>
extends Analysis<V, S, T> {
    protected final QualifierHierarchy qualifierHierarchy;
    protected final TypeHierarchy typeHierarchy;
    protected final AbstractBasicAnnotatedTypeFactory<V, S, T, ? extends CFAbstractAnalysis<V, S, T>> atypeFactory;
    protected final SourceChecker checker;
    protected final List<Pair<VariableElement, V>> fieldValues;
    protected final int expectedNumberOfAnnotations;

    public CFAbstractAnalysis(BaseTypeChecker checker, AbstractBasicAnnotatedTypeFactory<V, S, T, ? extends CFAbstractAnalysis<V, S, T>> factory, List<Pair<VariableElement, V>> fieldValues) {
        super(checker.getProcessingEnvironment());
        this.qualifierHierarchy = factory.getQualifierHierarchy();
        this.typeHierarchy = factory.getTypeHierarchy();
        this.atypeFactory = factory;
        this.checker = checker;
        this.transferFunction = this.createTransferFunction();
        this.expectedNumberOfAnnotations = this.qualifierHierarchy.getWidth();
        this.fieldValues = fieldValues;
    }

    public List<Pair<VariableElement, V>> getFieldValues() {
        return this.fieldValues;
    }

    public T createTransferFunction() {
        return this.atypeFactory.createFlowTransferFunction(this);
    }

    public abstract S createEmptyStore(boolean var1);

    public abstract S createCopiedStore(S var1);

    public abstract V createAbstractValue(AnnotatedTypeMirror var1);

    public CFValue defaultCreateAbstractValue(CFAbstractAnalysis<CFValue, ?, ?> analysis, AnnotatedTypeMirror type2) {
        if (!AnnotatedTypes.isValidType(this.qualifierHierarchy, type2)) {
            return null;
        }
        return new CFValue(analysis, type2);
    }

    public TypeHierarchy getTypeHierarchy() {
        return this.typeHierarchy;
    }

    public AbstractBasicAnnotatedTypeFactory<V, S, T, ? extends CFAbstractAnalysis<V, S, T>> getTypeFactory() {
        return this.atypeFactory;
    }

    public void outputToDotFile(String outputFile) {
        String s2 = CFGDOTVisualizer.visualize(this.cfg.getEntryBlock(), this);
        try {
            FileWriter fstream = new FileWriter(outputFile);
            BufferedWriter out = new BufferedWriter(fstream);
            out.write(s2);
            out.close();
        }
        catch (IOException e) {
            ErrorReporter.errorAbort("Error creating dot file: " + outputFile + "; ensure the path is valid", e);
        }
    }

    public V createSingleAnnotationValue(AnnotationMirror anno, TypeMirror underlyingType) {
        AnnotatedTypeMirror type2 = AnnotatedTypeMirror.createType(underlyingType, this.getTypeFactory());
        Set<? extends AnnotationMirror> tops = this.getTypeFactory().getQualifierHierarchy().getTopAnnotations();
        this.makeTop(type2, tops);
        type2.replaceAnnotation(anno);
        return this.createAbstractValue(type2);
    }

    private void makeTop(AnnotatedTypeMirror type2, Set<? extends AnnotationMirror> tops) {
        TypeKind kind = type2.getKind();
        if (kind == TypeKind.ARRAY) {
            AnnotatedTypeMirror.AnnotatedArrayType a = (AnnotatedTypeMirror.AnnotatedArrayType)type2;
            this.makeTop(a.getComponentType(), tops);
        } else if (kind == TypeKind.TYPEVAR) {
            AnnotatedTypeMirror.AnnotatedTypeVariable a = (AnnotatedTypeMirror.AnnotatedTypeVariable)type2;
            this.makeTop(a.getUpperBound(), tops);
        } else if (kind == TypeKind.WILDCARD) {
            AnnotatedTypeMirror.AnnotatedWildcardType a = (AnnotatedTypeMirror.AnnotatedWildcardType)type2;
            this.makeTop(a.getExtendsBound(), tops);
        }
        if (kind != TypeKind.TYPEVAR && kind != TypeKind.WILDCARD) {
            type2.addAnnotations(tops);
        }
    }
}

