/*
 * Decompiled with CFR 0.152.
 */
package checkers.oigj;

import checkers.basetype.BaseAnnotatedTypeFactory;
import checkers.basetype.BaseTypeChecker;
import checkers.oigj.OIGJMutabilityBottom;
import checkers.oigj.quals.AssignsFields;
import checkers.oigj.quals.I;
import checkers.oigj.quals.Immutable;
import checkers.oigj.quals.Mutable;
import checkers.oigj.quals.ReadOnly;
import checkers.types.AnnotatedTypeMirror;
import checkers.types.QualifierHierarchy;
import checkers.types.TreeAnnotator;
import checkers.types.TypeAnnotator;
import checkers.types.TypeHierarchy;
import checkers.types.visitors.AnnotatedTypeScanner;
import checkers.types.visitors.SimpleAnnotatedTypeVisitor;
import checkers.util.AnnotatedTypes;
import checkers.util.GraphQualifierHierarchy;
import checkers.util.MultiGraphQualifierHierarchy;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeCastTree;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javacutils.AnnotationUtils;
import javacutils.ElementUtils;
import javacutils.ErrorReporter;
import javacutils.Pair;
import javacutils.TreeUtils;
import javacutils.TypesUtils;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeVariable;

public class ImmutabilityAnnotatedTypeFactory
extends BaseAnnotatedTypeFactory {
    protected final AnnotationMirror READONLY;
    protected final AnnotationMirror MUTABLE;
    protected final AnnotationMirror IMMUTABLE;
    protected final AnnotationMirror I;
    protected final AnnotationMirror BOTTOM_QUAL;
    protected final AnnotationMirror ASSIGNS_FIELDS;
    protected static final String IMMUTABILITY_KEY = "value";

    public ImmutabilityAnnotatedTypeFactory(BaseTypeChecker checker) {
        super(checker);
        this.READONLY = AnnotationUtils.fromClass(this.elements, ReadOnly.class);
        this.MUTABLE = AnnotationUtils.fromClass(this.elements, Mutable.class);
        this.IMMUTABLE = AnnotationUtils.fromClass(this.elements, Immutable.class);
        this.I = AnnotationUtils.fromClass(this.elements, I.class);
        this.ASSIGNS_FIELDS = AnnotationUtils.fromClass(this.elements, AssignsFields.class);
        this.BOTTOM_QUAL = AnnotationUtils.fromClass(this.elements, OIGJMutabilityBottom.class);
        this.postInit();
    }

    @Override
    protected TreeAnnotator createTreeAnnotator() {
        return new IGJTreePreAnnotator(this);
    }

    @Override
    protected TypeAnnotator createTypeAnnotator() {
        return new IGJTypePostAnnotator(this);
    }

    @Override
    protected AnnotatedTypeMirror.AnnotatedDeclaredType getImplicitReceiverType(ExpressionTree tree) {
        AnnotatedTypeMirror.AnnotatedDeclaredType receiver = super.getImplicitReceiverType(tree);
        if (receiver != null && !this.isMostEnclosingThisDeref(tree)) {
            receiver.removeAnnotation(this.ASSIGNS_FIELDS);
            receiver.addAnnotation(this.READONLY);
        }
        return receiver;
    }

    @Override
    public AnnotatedTypeMirror.AnnotatedDeclaredType getSelfType(Tree tree) {
        AnnotatedTypeMirror.AnnotatedDeclaredType act = this.getCurrentClassType(tree);
        AnnotatedTypeMirror.AnnotatedDeclaredType methodReceiver = this.getCurrentMethodReceiver(tree);
        if (methodReceiver == null) {
            return act;
        }
        if (this.isWithinConstructor(tree) && !methodReceiver.hasEffectiveAnnotation(this.MUTABLE)) {
            methodReceiver.replaceAnnotation(this.ASSIGNS_FIELDS);
        }
        if (methodReceiver.hasEffectiveAnnotation(this.MUTABLE) || methodReceiver.hasEffectiveAnnotation(this.IMMUTABLE)) {
            return methodReceiver;
        }
        if (act.hasEffectiveAnnotation(this.I) || act.hasEffectiveAnnotation(this.IMMUTABLE)) {
            if (methodReceiver.hasEffectiveAnnotation(this.ASSIGNS_FIELDS)) {
                act.addAnnotation(this.ASSIGNS_FIELDS);
            }
            return act;
        }
        return methodReceiver;
    }

    @Override
    protected void postDirectSuperTypes(AnnotatedTypeMirror type2, List<? extends AnnotatedTypeMirror> supertypes2) {
        super.postDirectSuperTypes(type2, supertypes2);
        Map templateMapping = (Map)new ImmutabilityTemplateCollector().visit(type2);
        new ImmutabilityResolver().visit(supertypes2, templateMapping);
        for (AnnotatedTypeMirror annotatedTypeMirror : supertypes2) {
            this.typeAnnotator.visit(annotatedTypeMirror, null);
        }
    }

    @Override
    public void postAsMemberOf(AnnotatedTypeMirror elementType, AnnotatedTypeMirror owner, Element element) {
        this.resolveImmutabilityTypeVar(elementType, owner);
    }

    @Override
    public Pair<AnnotatedTypeMirror.AnnotatedExecutableType, List<AnnotatedTypeMirror>> methodFromUse(MethodInvocationTree tree) {
        Pair<AnnotatedTypeMirror.AnnotatedExecutableType, List<AnnotatedTypeMirror>> mfuPair = super.methodFromUse(tree);
        AnnotatedTypeMirror.AnnotatedExecutableType type2 = (AnnotatedTypeMirror.AnnotatedExecutableType)mfuPair.first;
        if (TreeUtils.isEnumSuper(tree)) {
            return mfuPair;
        }
        ImmutabilityTemplateCollector collector = new ImmutabilityTemplateCollector();
        List<AnnotatedTypeMirror> requiredArgs = AnnotatedTypes.expandVarArgs(this, type2, tree.getArguments());
        List<AnnotatedTypeMirror> arguments2 = AnnotatedTypes.getAnnotatedTypes(this, requiredArgs, tree.getArguments());
        Map<String, AnnotationMirror> matchingMapping = collector.visit(arguments2, requiredArgs);
        if (!matchingMapping.isEmpty()) {
            new ImmutabilityResolver().visit(type2, matchingMapping);
        }
        Map fromReceiver = (Map)collector.visit(this.getReceiverType(tree));
        final Map<String, AnnotationMirror> mapping = collector.reduce(matchingMapping, fromReceiver);
        new AnnotatedTypeScanner<Void, Void>(){

            @Override
            public Void visitDeclared(AnnotatedTypeMirror.AnnotatedDeclaredType type2, Void p) {
                AnnotationMirror anno;
                if (type2.hasEffectiveAnnotation(ImmutabilityAnnotatedTypeFactory.this.I) && !mapping.containsValue(anno = type2.getAnnotation(I.class))) {
                    type2.removeAnnotation(ImmutabilityAnnotatedTypeFactory.this.I);
                    type2.addAnnotation(ImmutabilityAnnotatedTypeFactory.this.BOTTOM_QUAL);
                }
                return (Void)super.visitDeclared(type2, p);
            }
        }.visit(type2);
        return mfuPair;
    }

    private boolean resolveImmutabilityTypeVar(AnnotatedTypeMirror type2, AnnotatedTypeMirror ... provided) {
        ImmutabilityTemplateCollector collector = new ImmutabilityTemplateCollector();
        Map<String, AnnotationMirror> templateMapping = Collections.emptyMap();
        for (AnnotatedTypeMirror pt : provided) {
            templateMapping = collector.reduce(templateMapping, (Map)collector.visit(pt));
        }
        if (templateMapping.isEmpty()) {
            return false;
        }
        new ImmutabilityResolver().visit(type2, templateMapping);
        return true;
    }

    private AnnotationMirror getImmutabilityAnnotation(AnnotatedTypeMirror type2) {
        if (type2.hasEffectiveAnnotation(this.I)) {
            return type2.getAnnotation(I.class);
        }
        return type2.getAnnotations().iterator().next();
    }

    private boolean hasImmutabilityAnnotation(AnnotatedTypeMirror type2) {
        return type2.isAnnotatedInHierarchy(this.READONLY);
    }

    @Override
    public QualifierHierarchy createQualifierHierarchy(MultiGraphQualifierHierarchy.MultiGraphFactory factory) {
        return new ImmutabilityQualifierHierarchy(factory);
    }

    @Override
    protected TypeHierarchy createTypeHierarchy() {
        return new OIGJImmutabilityTypeHierarchy(this.checker, this.getQualifierHierarchy());
    }

    static {
        FLOW_BY_DEFAULT = true;
    }

    private final class ImmutabilityQualifierHierarchy
    extends GraphQualifierHierarchy {
        public ImmutabilityQualifierHierarchy(MultiGraphQualifierHierarchy.MultiGraphFactory factory) {
            super(factory, ImmutabilityAnnotatedTypeFactory.this.BOTTOM_QUAL);
        }

        @Override
        public boolean isSubtype(Collection<? extends AnnotationMirror> rhs, Collection<? extends AnnotationMirror> lhs) {
            if (lhs.isEmpty() || rhs.isEmpty()) {
                ErrorReporter.errorAbort("GraphQualifierHierarchy: Empty annotations in lhs: " + lhs + " or rhs: " + rhs);
            }
            for (AnnotationMirror annotationMirror : lhs) {
                for (AnnotationMirror annotationMirror2 : rhs) {
                    if (!this.isSubtype(annotationMirror2, annotationMirror)) continue;
                    return true;
                }
            }
            return false;
        }
    }

    private final class OIGJImmutabilityTypeHierarchy
    extends TypeHierarchy {
        public OIGJImmutabilityTypeHierarchy(BaseTypeChecker checker, QualifierHierarchy qualifierHierarchy) {
            super(checker, qualifierHierarchy);
        }

        @Override
        protected boolean isSubtypeTypeArguments(AnnotatedTypeMirror.AnnotatedDeclaredType rhs, AnnotatedTypeMirror.AnnotatedDeclaredType lhs) {
            if (this.ignoreRawTypeArguments(rhs, lhs)) {
                return true;
            }
            if (lhs.hasEffectiveAnnotation(ImmutabilityAnnotatedTypeFactory.this.MUTABLE)) {
                return super.isSubtypeTypeArguments(rhs, lhs);
            }
            if (!lhs.getTypeArguments().isEmpty() && !rhs.getTypeArguments().isEmpty()) {
                assert (lhs.getTypeArguments().size() == rhs.getTypeArguments().size());
                for (int i = 0; i < lhs.getTypeArguments().size(); ++i) {
                    if (this.isSubtype(rhs.getTypeArguments().get(i), lhs.getTypeArguments().get(i))) continue;
                    return false;
                }
            }
            return true;
        }
    }

    private class ImmutabilityTemplateCollector
    extends SimpleAnnotatedTypeVisitor<Map<String, AnnotationMirror>, AnnotatedTypeMirror> {
        private final Set<TypeVariable> typeVar = new HashSet<TypeVariable>();

        private ImmutabilityTemplateCollector() {
        }

        public Map<String, AnnotationMirror> reduce(Map<String, AnnotationMirror> r1, Map<String, AnnotationMirror> r2) {
            HashMap<String, AnnotationMirror> result2 = new HashMap<String, AnnotationMirror>();
            if (r1 != null) {
                result2.putAll(r1);
            }
            if (r2 != null) {
                for (String key : r2.keySet()) {
                    if (!result2.containsKey(key)) {
                        result2.put(key, r2.get(key));
                        continue;
                    }
                    if (AnnotationUtils.areSame((AnnotationMirror)result2.get(key), r2.get(key))) continue;
                    result2.put(key, ImmutabilityAnnotatedTypeFactory.this.READONLY);
                }
            }
            return result2;
        }

        public Map<String, AnnotationMirror> visit(Iterable<? extends AnnotatedTypeMirror> types, Iterable<? extends AnnotatedTypeMirror> actualTypes) {
            Map<String, AnnotationMirror> result2 = new HashMap<String, AnnotationMirror>();
            Iterator<? extends AnnotatedTypeMirror> itert = types.iterator();
            Iterator<? extends AnnotatedTypeMirror> itera = actualTypes.iterator();
            while (itert.hasNext() && itera.hasNext()) {
                AnnotatedTypeMirror type2 = itert.next();
                AnnotatedTypeMirror actualType = itera.next();
                result2 = this.reduce(result2, (Map)this.visit(type2, actualType));
            }
            return result2;
        }

        @Override
        public Map<String, AnnotationMirror> visitDeclared(AnnotatedTypeMirror.AnnotatedDeclaredType type2, AnnotatedTypeMirror actualType) {
            if (actualType == null) {
                TypeElement elem = (TypeElement)type2.getUnderlyingType().asElement();
                actualType = ImmutabilityAnnotatedTypeFactory.this.getAnnotatedType(elem);
            }
            if (actualType.getKind() == TypeKind.TYPEVAR) {
                if (this.typeVar.contains(actualType.getUnderlyingType())) {
                    return Collections.emptyMap();
                }
                this.typeVar.add((TypeVariable)actualType.getUnderlyingType());
                Map result2 = (Map)this.visit(type2, ((AnnotatedTypeMirror.AnnotatedTypeVariable)actualType).getUpperBound());
                this.typeVar.remove(actualType.getUnderlyingType());
                return result2;
            }
            if (actualType.getKind() == TypeKind.WILDCARD) {
                return (Map)this.visit(type2, ((AnnotatedTypeMirror.AnnotatedWildcardType)actualType).getExtendsBound());
            }
            if (actualType.getKind() != type2.getKind()) {
                return Collections.emptyMap();
            }
            assert (actualType.getKind() == type2.getKind());
            type2 = (AnnotatedTypeMirror.AnnotatedDeclaredType)AnnotatedTypes.asSuper(ImmutabilityAnnotatedTypeFactory.this.types, ImmutabilityAnnotatedTypeFactory.this, type2, actualType);
            if (type2 == null) {
                return Collections.emptyMap();
            }
            AnnotatedTypeMirror.AnnotatedDeclaredType dcType = (AnnotatedTypeMirror.AnnotatedDeclaredType)actualType;
            Map<String, AnnotationMirror> result3 = new HashMap<String, AnnotationMirror>();
            if (dcType.hasEffectiveAnnotation(ImmutabilityAnnotatedTypeFactory.this.I)) {
                String immutableString = AnnotationUtils.getElementValue(ImmutabilityAnnotatedTypeFactory.this.getImmutabilityAnnotation(dcType), ImmutabilityAnnotatedTypeFactory.IMMUTABILITY_KEY, String.class, true);
                AnnotationMirror immutability = ImmutabilityAnnotatedTypeFactory.this.getImmutabilityAnnotation(type2);
                if (immutability != null && !immutability.equals(ImmutabilityAnnotatedTypeFactory.this.ASSIGNS_FIELDS)) {
                    result3.put(immutableString, immutability);
                }
            }
            if (type2 != dcType && !type2.wasRaw() && !dcType.wasRaw()) {
                result3 = this.reduce(result3, this.visit(type2.getTypeArguments(), dcType.getTypeArguments()));
            }
            return result3;
        }

        @Override
        public Map<String, AnnotationMirror> visitArray(AnnotatedTypeMirror.AnnotatedArrayType type2, AnnotatedTypeMirror actualType) {
            if (actualType == null) {
                return (Map)this.visit(type2.getComponentType(), null);
            }
            if (actualType.getKind() == TypeKind.DECLARED) {
                return (Map)this.visit(AnnotatedTypes.asSuper(ImmutabilityAnnotatedTypeFactory.this.types, ImmutabilityAnnotatedTypeFactory.this, type2, actualType), actualType);
            }
            if (actualType.getKind() == TypeKind.TYPEVAR) {
                if (this.typeVar.contains(actualType.getUnderlyingType())) {
                    return Collections.emptyMap();
                }
                this.typeVar.add((TypeVariable)actualType.getUnderlyingType());
                Map result2 = (Map)this.visit(type2, ((AnnotatedTypeMirror.AnnotatedTypeVariable)actualType).getUpperBound());
                this.typeVar.remove(actualType.getUnderlyingType());
                return result2;
            }
            if (actualType.getKind() == TypeKind.WILDCARD) {
                return (Map)this.visit(type2, ((AnnotatedTypeMirror.AnnotatedWildcardType)actualType).getExtendsBound());
            }
            if (type2.getKind() != actualType.getKind()) {
                return (Map)this.visit(type2, null);
            }
            assert (type2.getKind() == actualType.getKind());
            AnnotatedTypeMirror.AnnotatedArrayType arType = (AnnotatedTypeMirror.AnnotatedArrayType)actualType;
            Map<String, AnnotationMirror> result3 = new HashMap<String, AnnotationMirror>();
            if (arType.hasEffectiveAnnotation(ImmutabilityAnnotatedTypeFactory.this.I)) {
                String immutableString = AnnotationUtils.getElementValue(ImmutabilityAnnotatedTypeFactory.this.getImmutabilityAnnotation(arType), ImmutabilityAnnotatedTypeFactory.IMMUTABILITY_KEY, String.class, true);
                AnnotationMirror immutability = ImmutabilityAnnotatedTypeFactory.this.getImmutabilityAnnotation(type2);
                assert (immutability != null);
                if (!type2.hasEffectiveAnnotation(ImmutabilityAnnotatedTypeFactory.this.ASSIGNS_FIELDS)) {
                    result3.put(immutableString, immutability);
                }
            }
            result3 = this.reduce(result3, (Map)this.visit(type2.getComponentType(), arType.getComponentType()));
            return result3;
        }

        @Override
        public Map<String, AnnotationMirror> visitTypeVariable(AnnotatedTypeMirror.AnnotatedTypeVariable type2, AnnotatedTypeMirror actualType) {
            AnnotatedTypeMirror typeSuper;
            if (actualType == null) {
                return Collections.emptyMap();
            }
            if (actualType.getKind() == TypeKind.WILDCARD && ((AnnotatedTypeMirror.AnnotatedWildcardType)actualType).getSuperBound() != null) {
                actualType = ((AnnotatedTypeMirror.AnnotatedWildcardType)actualType).getSuperBound();
            }
            if ((typeSuper = this.findType(type2, actualType)).getKind() != TypeKind.TYPEVAR) {
                return (Map)this.visit(typeSuper, actualType);
            }
            assert (typeSuper.getKind() == actualType.getKind()) : actualType;
            assert (type2.getKind() == actualType.getKind()) : actualType;
            AnnotatedTypeMirror.AnnotatedTypeVariable tvType = (AnnotatedTypeMirror.AnnotatedTypeVariable)typeSuper;
            this.typeVar.add(type2.getUnderlyingType());
            Map result2 = (Map)this.visit(type2.getUpperBound(), tvType.getUpperBound());
            this.typeVar.remove(type2.getUnderlyingType());
            return result2;
        }

        @Override
        public Map<String, AnnotationMirror> visitWildcard(AnnotatedTypeMirror.AnnotatedWildcardType type2, AnnotatedTypeMirror actualType) {
            if (actualType == null) {
                return Collections.emptyMap();
            }
            AnnotatedTypeMirror typeSuper = this.findType(type2, actualType);
            if (typeSuper.getKind() != TypeKind.WILDCARD) {
                return (Map)this.visit(typeSuper, actualType);
            }
            if (typeSuper.getKind() != actualType.getKind()) {
                return Collections.emptyMap();
            }
            assert (typeSuper.getKind() == actualType.getKind()) : actualType;
            AnnotatedTypeMirror.AnnotatedWildcardType wcType = (AnnotatedTypeMirror.AnnotatedWildcardType)typeSuper;
            if (type2.getExtendsBound() != null && wcType.getExtendsBound() != null) {
                return (Map)this.visit(type2.getExtendsBound(), wcType.getExtendsBound());
            }
            if (type2.getSuperBound() != null && wcType.getSuperBound() != null) {
                return (Map)this.visit(type2.getSuperBound(), wcType.getSuperBound());
            }
            return new HashMap<String, AnnotationMirror>();
        }

        private AnnotatedTypeMirror findType(AnnotatedTypeMirror type2, AnnotatedTypeMirror actualType) {
            AnnotatedTypeMirror result2 = AnnotatedTypes.asSuper(ImmutabilityAnnotatedTypeFactory.this.types, ImmutabilityAnnotatedTypeFactory.this, type2, actualType);
            return result2 != null ? result2 : type2;
        }
    }

    private class ImmutabilityResolver
    extends AnnotatedTypeScanner<Void, Map<String, AnnotationMirror>> {
        private ImmutabilityResolver() {
        }

        public void visit(Iterable<? extends AnnotatedTypeMirror> types, Map<String, AnnotationMirror> templateMapping) {
            if (templateMapping != null && !templateMapping.isEmpty()) {
                for (AnnotatedTypeMirror annotatedTypeMirror : types) {
                    this.visit(annotatedTypeMirror, templateMapping);
                }
            }
        }

        @Override
        public Void visitDeclared(AnnotatedTypeMirror.AnnotatedDeclaredType type2, Map<String, AnnotationMirror> p) {
            String immutableString;
            if (type2.hasEffectiveAnnotation(ImmutabilityAnnotatedTypeFactory.this.I) && p.containsKey(immutableString = AnnotationUtils.getElementValue(ImmutabilityAnnotatedTypeFactory.this.getImmutabilityAnnotation(type2), ImmutabilityAnnotatedTypeFactory.IMMUTABILITY_KEY, String.class, true))) {
                type2.removeAnnotation(ImmutabilityAnnotatedTypeFactory.this.I);
                type2.addAnnotation(p.get(immutableString));
            }
            return (Void)super.visitDeclared(type2, p);
        }
    }

    private class IGJTreePreAnnotator
    extends TreeAnnotator {
        public IGJTreePreAnnotator(ImmutabilityAnnotatedTypeFactory atypeFactory) {
            super(atypeFactory);
        }

        @Override
        public Void visitNewClass(NewClassTree node, AnnotatedTypeMirror p) {
            if (!ImmutabilityAnnotatedTypeFactory.this.hasImmutabilityAnnotation(p)) {
                AnnotatedTypeMirror ct = ImmutabilityAnnotatedTypeFactory.this.fromElement(((AnnotatedTypeMirror.AnnotatedDeclaredType)p).getUnderlyingType().asElement());
                if (!ImmutabilityAnnotatedTypeFactory.this.hasImmutabilityAnnotation(ct) || ct.hasEffectiveAnnotation(ImmutabilityAnnotatedTypeFactory.this.I)) {
                    AnnotatedTypeMirror.AnnotatedExecutableType con = ImmutabilityAnnotatedTypeFactory.this.getAnnotatedType(TreeUtils.elementFromUse(node));
                    if (con.getReceiverType().hasEffectiveAnnotation(ImmutabilityAnnotatedTypeFactory.this.IMMUTABLE)) {
                        p.addAnnotation(ImmutabilityAnnotatedTypeFactory.this.IMMUTABLE);
                    } else {
                        p.addAnnotation(ImmutabilityAnnotatedTypeFactory.this.MUTABLE);
                    }
                } else {
                    p.addAnnotations(ct.getAnnotations());
                }
            }
            return null;
        }

        @Override
        public Void visitTypeCast(TypeCastTree node, AnnotatedTypeMirror p) {
            if (!ImmutabilityAnnotatedTypeFactory.this.hasImmutabilityAnnotation(p)) {
                AnnotatedTypeMirror castedType = ImmutabilityAnnotatedTypeFactory.this.getAnnotatedType(node.getExpression());
                p.addAnnotations(castedType.getAnnotations());
            }
            return null;
        }
    }

    private class IGJTypePostAnnotator
    extends TypeAnnotator {
        public IGJTypePostAnnotator(ImmutabilityAnnotatedTypeFactory atypeFactory) {
            super(atypeFactory);
        }

        @Override
        public Void visitDeclared(AnnotatedTypeMirror.AnnotatedDeclaredType type2, Element elem) {
            if (!ImmutabilityAnnotatedTypeFactory.this.hasImmutabilityAnnotation(type2)) {
                ElementKind elemKind;
                TypeElement element = (TypeElement)type2.getUnderlyingType().asElement();
                AnnotatedTypeMirror.AnnotatedDeclaredType elementType = ImmutabilityAnnotatedTypeFactory.this.fromElement(element);
                ElementKind elementKind = elemKind = elem != null ? elem.getKind() : ElementKind.OTHER;
                if (TypesUtils.isBoxedPrimitive(type2.getUnderlyingType()) || element.getQualifiedName().contentEquals("java.lang.String") || ElementUtils.isObject(element)) {
                    type2.addAnnotation(ImmutabilityAnnotatedTypeFactory.this.BOTTOM_QUAL);
                } else if (elementType.hasEffectiveAnnotation(ImmutabilityAnnotatedTypeFactory.this.IMMUTABLE)) {
                    type2.addAnnotation(ImmutabilityAnnotatedTypeFactory.this.IMMUTABLE);
                } else if (elemKind == ElementKind.LOCAL_VARIABLE) {
                    type2.addAnnotation(ImmutabilityAnnotatedTypeFactory.this.READONLY);
                } else if (elementType.hasEffectiveAnnotation(ImmutabilityAnnotatedTypeFactory.this.MUTABLE)) {
                    type2.addAnnotation(ImmutabilityAnnotatedTypeFactory.this.MUTABLE);
                } else if (elemKind.isClass() || elemKind.isInterface()) {
                    type2.addAnnotation(ImmutabilityAnnotatedTypeFactory.this.BOTTOM_QUAL);
                } else if (elemKind.isField()) {
                    if (elem != null && ImmutabilityAnnotatedTypeFactory.this.getAnnotatedType(ElementUtils.enclosingClass(elem)).hasEffectiveAnnotation(ImmutabilityAnnotatedTypeFactory.this.IMMUTABLE)) {
                        type2.addAnnotation(ImmutabilityAnnotatedTypeFactory.this.IMMUTABLE);
                    } else {
                        type2.addAnnotation(ImmutabilityAnnotatedTypeFactory.this.MUTABLE);
                    }
                } else if (element.getKind().isClass() || element.getKind().isInterface()) {
                    type2.addAnnotation(ImmutabilityAnnotatedTypeFactory.this.MUTABLE);
                } else assert (false) : "shouldn't be here!";
            }
            return (Void)super.visitDeclared(type2, elem);
        }

        @Override
        public Void visitExecutable(AnnotatedTypeMirror.AnnotatedExecutableType type2, Element elem) {
            if (ImmutabilityAnnotatedTypeFactory.this.hasImmutabilityAnnotation(type2.getReceiverType())) {
                return super.visitExecutable(type2, elem);
            }
            AnnotatedTypeMirror.AnnotatedDeclaredType receiver = type2.getReceiverType();
            TypeElement ownerElement = ElementUtils.enclosingClass(type2.getElement());
            AnnotatedTypeMirror.AnnotatedDeclaredType ownerType = ImmutabilityAnnotatedTypeFactory.this.getAnnotatedType(ownerElement);
            if (type2.getElement().getKind() == ElementKind.CONSTRUCTOR) {
                if (ownerType.hasEffectiveAnnotation(ImmutabilityAnnotatedTypeFactory.this.MUTABLE) || ownerType.hasEffectiveAnnotation(ImmutabilityAnnotatedTypeFactory.this.BOTTOM_QUAL)) {
                    receiver.addAnnotation(ImmutabilityAnnotatedTypeFactory.this.MUTABLE);
                } else {
                    receiver.addAnnotation(ImmutabilityAnnotatedTypeFactory.this.ASSIGNS_FIELDS);
                }
            } else if (ElementUtils.isObject(ownerElement) || ownerType.hasEffectiveAnnotation(ImmutabilityAnnotatedTypeFactory.this.IMMUTABLE)) {
                receiver.addAnnotation(ImmutabilityAnnotatedTypeFactory.this.BOTTOM_QUAL);
            } else {
                receiver.addAnnotation(ImmutabilityAnnotatedTypeFactory.this.MUTABLE);
            }
            return super.visitExecutable(type2, elem);
        }

        @Override
        public Void visitTypeVariable(AnnotatedTypeMirror.AnnotatedTypeVariable type2, Element elem) {
            if (type2.getUpperBoundField() != null && !ImmutabilityAnnotatedTypeFactory.this.hasImmutabilityAnnotation(type2.getUpperBound())) {
                ElementKind elemKind;
                ElementKind elementKind = elemKind = elem != null ? elem.getKind() : ElementKind.OTHER;
                if (elemKind.isClass() || elemKind.isInterface() || elemKind == ElementKind.CONSTRUCTOR || elemKind == ElementKind.METHOD) {
                    type2.getUpperBound().addAnnotation(ImmutabilityAnnotatedTypeFactory.this.READONLY);
                } else if (TypesUtils.isObject(type2.getUnderlyingType())) {
                    type2.getUpperBound().addAnnotation(ImmutabilityAnnotatedTypeFactory.this.MUTABLE);
                }
            }
            return (Void)super.visitTypeVariable(type2, elem);
        }

        @Override
        public Void visitWildcard(AnnotatedTypeMirror.AnnotatedWildcardType type2, Element elem) {
            if (type2.getExtendsBound() != null && !ImmutabilityAnnotatedTypeFactory.this.hasImmutabilityAnnotation(type2.getExtendsBound())) {
                ElementKind elemKind;
                ElementKind elementKind = elemKind = elem != null ? elem.getKind() : ElementKind.OTHER;
                if (elemKind.isClass() || elemKind.isInterface() || elemKind == ElementKind.CONSTRUCTOR || elemKind == ElementKind.METHOD) {
                    type2.getExtendsBound().addAnnotation(ImmutabilityAnnotatedTypeFactory.this.READONLY);
                } else if (TypesUtils.isObject(type2.getUnderlyingType())) {
                    type2.getExtendsBound().addAnnotation(ImmutabilityAnnotatedTypeFactory.this.MUTABLE);
                }
            }
            return (Void)super.visitWildcard(type2, elem);
        }
    }
}

