/*
 * Decompiled with CFR 0.152.
 */
package checkers.propkey;

import checkers.basetype.BaseAnnotatedTypeFactory;
import checkers.basetype.BaseTypeChecker;
import checkers.propkey.quals.PropertyKey;
import checkers.quals.Bottom;
import checkers.types.AnnotatedTypeMirror;
import checkers.types.TreeAnnotator;
import checkers.util.GraphQualifierHierarchy;
import checkers.util.MultiGraphQualifierHierarchy;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.Tree;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import javacutils.AnnotationUtils;
import javax.lang.model.element.AnnotationMirror;

public class PropertyKeyAnnotatedTypeFactory
extends BaseAnnotatedTypeFactory {
    private final Set<String> lookupKeys = Collections.unmodifiableSet(this.buildLookupKeys());

    public PropertyKeyAnnotatedTypeFactory(BaseTypeChecker checker) {
        super(checker);
        AnnotationMirror BOTTOM = AnnotationUtils.fromClass(this.elements, Bottom.class);
        this.postInit();
        this.treeAnnotator.addTreeKind(Tree.Kind.NULL_LITERAL, BOTTOM);
        this.typeAnnotator.addTypeName(Void.class, BOTTOM);
    }

    @Override
    public TreeAnnotator createTreeAnnotator() {
        return new KeyLookupTreeAnnotator(this, PropertyKey.class);
    }

    private static boolean strContains(Set<String> messages, String messageKey) {
        String key = messageKey;
        while (!messages.contains(key)) {
            int dot = key.indexOf(46);
            if (dot < 0) {
                return false;
            }
            key = key.substring(dot + 1);
        }
        return true;
    }

    public Set<String> getLookupKeys() {
        return this.lookupKeys;
    }

    private Set<String> buildLookupKeys() {
        HashSet<String> result2 = new HashSet<String>();
        if (this.checker.hasOption("propfiles")) {
            result2.addAll(this.keysOfPropertyFiles(this.checker.getOption("propfiles")));
        }
        if (this.checker.hasOption("bundlenames")) {
            result2.addAll(this.keysOfResourceBundle(this.checker.getOption("bundlenames")));
        }
        return result2;
    }

    private Set<String> keysOfPropertyFiles(String names) {
        String[] namesArr = names.split(":");
        if (namesArr == null) {
            System.err.println("Couldn't parse the properties files: <" + names + ">");
            return Collections.emptySet();
        }
        HashSet<String> result2 = new HashSet<String>();
        for (String name : namesArr) {
            try {
                Properties prop = new Properties();
                InputStream in = null;
                ClassLoader cl = this.getClass().getClassLoader();
                if (cl == null) {
                    cl = ClassLoader.getSystemClassLoader();
                }
                if ((in = cl.getResourceAsStream(name)) == null) {
                    try {
                        in = new FileInputStream(name);
                    }
                    catch (FileNotFoundException e) {
                        // empty catch block
                    }
                }
                if (in == null) {
                    System.err.println("Couldn't find the properties file: " + name);
                    continue;
                }
                prop.load(in);
                result2.addAll(prop.stringPropertyNames());
            }
            catch (Exception e) {
                System.err.println("Exception in PropertyKeyChecker.keysOfPropertyFile: " + e);
                e.printStackTrace();
            }
        }
        return result2;
    }

    private Set<String> keysOfResourceBundle(String bundleNames) {
        String[] namesArr = bundleNames.split(":");
        if (namesArr == null) {
            System.err.println("Couldn't parse the resource bundles: <" + bundleNames + ">");
            return Collections.emptySet();
        }
        HashSet<String> result2 = new HashSet<String>();
        for (String bundleName : namesArr) {
            ResourceBundle bundle = ResourceBundle.getBundle(bundleName);
            if (bundle == null) {
                System.err.println("Couldn't find the resource bundle: <" + bundleName + "> for locale <" + Locale.getDefault() + ">");
                continue;
            }
            result2.addAll(bundle.keySet());
        }
        return result2;
    }

    @Override
    public GraphQualifierHierarchy createQualifierHierarchy(MultiGraphQualifierHierarchy.MultiGraphFactory factory) {
        return new GraphQualifierHierarchy(factory, AnnotationUtils.fromClass(this.elements, Bottom.class));
    }

    protected class KeyLookupTreeAnnotator
    extends TreeAnnotator {
        AnnotationMirror theAnnot;

        public KeyLookupTreeAnnotator(BaseAnnotatedTypeFactory atf, Class<? extends Annotation> annot) {
            super(atf);
            this.theAnnot = AnnotationUtils.fromClass(PropertyKeyAnnotatedTypeFactory.this.elements, annot);
        }

        @Override
        public Void visitLiteral(LiteralTree tree, AnnotatedTypeMirror type2) {
            if (!type2.isAnnotatedInHierarchy(this.theAnnot) && tree.getKind() == Tree.Kind.STRING_LITERAL && PropertyKeyAnnotatedTypeFactory.strContains(PropertyKeyAnnotatedTypeFactory.this.lookupKeys, tree.getValue().toString())) {
                type2.addAnnotation(this.theAnnot);
            }
            return super.visitLiteral(tree, type2);
        }

        @Override
        public Void visitBinary(BinaryTree node, AnnotatedTypeMirror type2) {
            type2.removeAnnotation(this.theAnnot);
            return null;
        }

        @Override
        public Void visitCompoundAssignment(CompoundAssignmentTree node, AnnotatedTypeMirror type2) {
            type2.removeAnnotation(this.theAnnot);
            return null;
        }
    }
}

