/*
 * Decompiled with CFR 0.152.
 */
package checkers.regex;

import checkers.basetype.BaseTypeChecker;
import checkers.flow.CFStore;
import checkers.flow.CFValue;
import checkers.regex.RegexAnalysis;
import checkers.regex.RegexTransfer;
import checkers.regex.quals.PartialRegex;
import checkers.regex.quals.PolyRegex;
import checkers.regex.quals.Regex;
import checkers.regex.quals.RegexBottom;
import checkers.types.AbstractBasicAnnotatedTypeFactory;
import checkers.types.AnnotatedTypeFactory;
import checkers.types.AnnotatedTypeMirror;
import checkers.types.QualifierHierarchy;
import checkers.types.TreeAnnotator;
import checkers.util.AnnotationBuilder;
import checkers.util.GraphQualifierHierarchy;
import checkers.util.MultiGraphQualifierHierarchy;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javacutils.AnnotationUtils;
import javacutils.Pair;
import javacutils.TreeUtils;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;

public class RegexAnnotatedTypeFactory
extends AbstractBasicAnnotatedTypeFactory<CFValue, CFStore, RegexTransfer, RegexAnalysis> {
    private final ExecutableElement patternCompile;
    private final ExecutableElement partialRegexValue;
    static final String[] regexUtilClasses = new String[]{"checkers.regex.RegexUtil", "plume.RegexUtil", "daikon.util.RegexUtil"};
    protected final AnnotationMirror REGEX;
    protected final AnnotationMirror REGEXBOTTOM;
    protected final AnnotationMirror PARTIALREGEX;
    protected final ExecutableElement regexValueElement;

    public RegexAnnotatedTypeFactory(BaseTypeChecker checker) {
        super(checker);
        this.patternCompile = TreeUtils.getMethod("java.util.regex.Pattern", "compile", 1, this.processingEnv);
        this.partialRegexValue = TreeUtils.getMethod("checkers.regex.quals.PartialRegex", "value", 0, this.processingEnv);
        this.REGEX = AnnotationUtils.fromClass(this.elements, Regex.class);
        this.REGEXBOTTOM = AnnotationUtils.fromClass(this.elements, RegexBottom.class);
        this.PARTIALREGEX = AnnotationUtils.fromClass(this.elements, PartialRegex.class);
        this.regexValueElement = TreeUtils.getMethod("checkers.regex.quals.Regex", "value", 0, this.processingEnv);
        this.postInit();
    }

    @Override
    protected RegexAnalysis createFlowAnalysis(List<Pair<VariableElement, CFValue>> fieldValues) {
        return new RegexAnalysis(this.checker, this, fieldValues);
    }

    @Override
    public TreeAnnotator createTreeAnnotator() {
        return new RegexTreeAnnotator(this);
    }

    AnnotationMirror createRegexAnnotation(int groupCount) {
        AnnotationBuilder builder = new AnnotationBuilder(this.processingEnv, Regex.class);
        builder.setValue((CharSequence)"value", groupCount);
        return builder.build();
    }

    @Override
    public QualifierHierarchy createQualifierHierarchy(MultiGraphQualifierHierarchy.MultiGraphFactory factory) {
        return new RegexQualifierHierarchy(factory, this.REGEXBOTTOM);
    }

    public int getGroupCount(AnnotationMirror anno) {
        AnnotationValue groupCountValue = AnnotationUtils.getElementValuesWithDefaults(anno).get(this.regexValueElement);
        return groupCountValue == null ? 0 : (Integer)groupCountValue.getValue();
    }

    public static int getGroupCount(String regex) {
        return Pattern.compile(regex).matcher("").groupCount();
    }

    private static boolean isRegex(String s2) {
        try {
            Pattern.compile(s2);
        }
        catch (PatternSyntaxException e) {
            return false;
        }
        return true;
    }

    private class RegexTreeAnnotator
    extends TreeAnnotator {
        public RegexTreeAnnotator(AnnotatedTypeFactory atypeFactory) {
            super(atypeFactory);
        }

        @Override
        public Void visitLiteral(LiteralTree tree, AnnotatedTypeMirror type2) {
            if (!type2.isAnnotatedInHierarchy(RegexAnnotatedTypeFactory.this.REGEX)) {
                String regex = null;
                if (tree.getKind() == Tree.Kind.STRING_LITERAL) {
                    regex = (String)tree.getValue();
                } else if (tree.getKind() == Tree.Kind.CHAR_LITERAL) {
                    regex = Character.toString(((Character)tree.getValue()).charValue());
                }
                if (regex != null) {
                    if (RegexAnnotatedTypeFactory.isRegex(regex)) {
                        int groupCount = RegexAnnotatedTypeFactory.getGroupCount(regex);
                        type2.addAnnotation(RegexAnnotatedTypeFactory.this.createRegexAnnotation(groupCount));
                    } else {
                        type2.addAnnotation(this.createPartialRegexAnnotation(regex));
                    }
                }
            }
            return super.visitLiteral(tree, type2);
        }

        @Override
        public Void visitBinary(BinaryTree tree, AnnotatedTypeMirror type2) {
            if (!type2.isAnnotatedInHierarchy(RegexAnnotatedTypeFactory.this.REGEX) && TreeUtils.isStringConcatenation(tree)) {
                AnnotatedTypeMirror lExpr = RegexAnnotatedTypeFactory.this.getAnnotatedType(tree.getLeftOperand());
                AnnotatedTypeMirror rExpr = RegexAnnotatedTypeFactory.this.getAnnotatedType(tree.getRightOperand());
                boolean lExprRE = lExpr.hasAnnotation(Regex.class);
                boolean rExprRE = rExpr.hasAnnotation(Regex.class);
                boolean lExprPart = lExpr.hasAnnotation(PartialRegex.class);
                boolean rExprPart = rExpr.hasAnnotation(PartialRegex.class);
                boolean lExprPoly = lExpr.hasAnnotation(PolyRegex.class);
                boolean rExprPoly = rExpr.hasAnnotation(PolyRegex.class);
                if (lExprRE && rExprRE) {
                    int lGroupCount = RegexAnnotatedTypeFactory.this.getGroupCount(lExpr.getAnnotation(Regex.class));
                    int rGroupCount = RegexAnnotatedTypeFactory.this.getGroupCount(rExpr.getAnnotation(Regex.class));
                    type2.removeAnnotationInHierarchy(RegexAnnotatedTypeFactory.this.REGEX);
                    type2.addAnnotation(RegexAnnotatedTypeFactory.this.createRegexAnnotation(lGroupCount + rGroupCount));
                } else if (lExprPoly && rExprPoly || lExprPoly && rExprRE || lExprRE && rExprPoly) {
                    type2.addAnnotation(PolyRegex.class);
                } else if (lExprPart && rExprPart) {
                    String lRegex = this.getPartialRegexValue(lExpr);
                    String rRegex = this.getPartialRegexValue(rExpr);
                    String concat = lRegex + rRegex;
                    if (RegexAnnotatedTypeFactory.isRegex(concat)) {
                        int groupCount = RegexAnnotatedTypeFactory.getGroupCount(concat);
                        type2.addAnnotation(RegexAnnotatedTypeFactory.this.createRegexAnnotation(groupCount));
                    } else {
                        type2.addAnnotation(this.createPartialRegexAnnotation(concat));
                    }
                } else if (lExprRE && rExprPart) {
                    String rRegex = this.getPartialRegexValue(rExpr);
                    String concat = "e" + rRegex;
                    type2.addAnnotation(this.createPartialRegexAnnotation(concat));
                } else if (lExprPart && rExprRE) {
                    String lRegex = this.getPartialRegexValue(lExpr);
                    String concat = lRegex + "e";
                    type2.addAnnotation(this.createPartialRegexAnnotation(concat));
                }
            }
            return null;
        }

        @Override
        public Void visitCompoundAssignment(CompoundAssignmentTree node, AnnotatedTypeMirror type2) {
            if (TreeUtils.isStringCompoundConcatenation(node)) {
                AnnotatedTypeMirror rhs = RegexAnnotatedTypeFactory.this.getAnnotatedType(node.getExpression());
                AnnotatedTypeMirror lhs = RegexAnnotatedTypeFactory.this.getAnnotatedType(node.getVariable());
                if (lhs.hasAnnotation(Regex.class) && rhs.hasAnnotation(Regex.class)) {
                    int lCount = RegexAnnotatedTypeFactory.this.getGroupCount(lhs.getAnnotation(Regex.class));
                    int rCount = RegexAnnotatedTypeFactory.this.getGroupCount(rhs.getAnnotation(Regex.class));
                    type2.removeAnnotationInHierarchy(RegexAnnotatedTypeFactory.this.REGEX);
                    type2.addAnnotation(RegexAnnotatedTypeFactory.this.createRegexAnnotation(lCount + rCount));
                }
            }
            return null;
        }

        @Override
        public Void visitMethodInvocation(MethodInvocationTree tree, AnnotatedTypeMirror type2) {
            if (TreeUtils.isMethodInvocation(tree, RegexAnnotatedTypeFactory.this.patternCompile, RegexAnnotatedTypeFactory.this.processingEnv)) {
                ExpressionTree arg0 = tree.getArguments().get(0);
                AnnotationMirror regexAnno = RegexAnnotatedTypeFactory.this.getAnnotatedType(arg0).getAnnotation(Regex.class);
                AnnotationMirror bottomAnno = RegexAnnotatedTypeFactory.this.getAnnotatedType(arg0).getAnnotation(RegexBottom.class);
                if (regexAnno != null) {
                    int groupCount = RegexAnnotatedTypeFactory.this.getGroupCount(regexAnno);
                    type2.replaceAnnotation(RegexAnnotatedTypeFactory.this.createRegexAnnotation(groupCount));
                } else if (bottomAnno != null) {
                    type2.replaceAnnotation(AnnotationUtils.fromClass(RegexAnnotatedTypeFactory.this.elements, RegexBottom.class));
                }
            }
            return (Void)super.visitMethodInvocation(tree, type2);
        }

        private AnnotationMirror createPartialRegexAnnotation(String partial) {
            AnnotationBuilder builder = new AnnotationBuilder(RegexAnnotatedTypeFactory.this.processingEnv, PartialRegex.class);
            builder.setValue((CharSequence)"value", partial);
            return builder.build();
        }

        private String getPartialRegexValue(AnnotatedTypeMirror type2) {
            return (String)AnnotationUtils.getElementValuesWithDefaults(type2.getAnnotation(PartialRegex.class)).get(RegexAnnotatedTypeFactory.this.partialRegexValue).getValue();
        }
    }

    private final class RegexQualifierHierarchy
    extends GraphQualifierHierarchy {
        public RegexQualifierHierarchy(MultiGraphQualifierHierarchy.MultiGraphFactory f, AnnotationMirror bottom) {
            super(f, bottom);
        }

        @Override
        public boolean isSubtype(AnnotationMirror rhs, AnnotationMirror lhs) {
            if (AnnotationUtils.areSameIgnoringValues(rhs, RegexAnnotatedTypeFactory.this.REGEX) && AnnotationUtils.areSameIgnoringValues(lhs, RegexAnnotatedTypeFactory.this.REGEX)) {
                int rhsValue = this.getRegexValue(rhs);
                int lhsValue = this.getRegexValue(lhs);
                return lhsValue <= rhsValue;
            }
            if (AnnotationUtils.areSameIgnoringValues(lhs, RegexAnnotatedTypeFactory.this.REGEX)) {
                lhs = RegexAnnotatedTypeFactory.this.REGEX;
            }
            if (AnnotationUtils.areSameIgnoringValues(rhs, RegexAnnotatedTypeFactory.this.REGEX)) {
                rhs = RegexAnnotatedTypeFactory.this.REGEX;
            }
            if (AnnotationUtils.areSameIgnoringValues(lhs, RegexAnnotatedTypeFactory.this.PARTIALREGEX)) {
                lhs = RegexAnnotatedTypeFactory.this.PARTIALREGEX;
            }
            if (AnnotationUtils.areSameIgnoringValues(rhs, RegexAnnotatedTypeFactory.this.PARTIALREGEX)) {
                rhs = RegexAnnotatedTypeFactory.this.PARTIALREGEX;
            }
            return super.isSubtype(rhs, lhs);
        }

        private int getRegexValue(AnnotationMirror anno) {
            return (Integer)AnnotationUtils.getElementValuesWithDefaults(anno).get(RegexAnnotatedTypeFactory.this.regexValueElement).getValue();
        }
    }
}

