/*
 * Decompiled with CFR 0.152.
 */
package checkers.source;

import dataflow.quals.Pure;
import dataflow.quals.SideEffectFree;
import dataflow.util.HashCodeUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public final class Result {
    private final Type type;
    private final List<DiagMessage> messages;
    public static final Result SUCCESS = new Result(Type.SUCCESS, null);

    public static Result failure(String messageKey, Object ... args2) {
        return new Result(Type.FAILURE, Collections.singleton(new DiagMessage(messageKey, args2)));
    }

    public static Result warning(String messageKey, Object ... args2) {
        return new Result(Type.WARNING, Collections.singleton(new DiagMessage(messageKey, args2)));
    }

    private Result(Type type2, Collection<DiagMessage> messagePairs) {
        this.type = type2;
        this.messages = new LinkedList<DiagMessage>();
        if (messagePairs != null) {
            for (DiagMessage msg : messagePairs) {
                String message = msg.getMessageKey();
                Object[] args2 = msg.getArgs();
                if (args2 != null) {
                    args2 = Arrays.copyOf(msg.getArgs(), args2.length);
                }
                this.messages.add(new DiagMessage(message, args2));
            }
        }
    }

    public Result merge(Result r) {
        if (r == null) {
            return this;
        }
        if (r.isSuccess() && this.isSuccess()) {
            return SUCCESS;
        }
        LinkedList<DiagMessage> messages = new LinkedList<DiagMessage>();
        messages.addAll(this.messages);
        messages.addAll(r.messages);
        return new Result(Type.merge(r.type, this.type), messages);
    }

    public boolean isSuccess() {
        return this.type == Type.SUCCESS;
    }

    public boolean isFailure() {
        return this.type == Type.FAILURE;
    }

    public boolean isWarning() {
        return this.type == Type.WARNING;
    }

    public List<String> getMessageKeys() {
        LinkedList<String> msgKeys = new LinkedList<String>();
        for (DiagMessage msg : this.getDiagMessages()) {
            msgKeys.add(msg.getMessageKey());
        }
        return Collections.unmodifiableList(msgKeys);
    }

    public List<DiagMessage> getDiagMessages() {
        return Collections.unmodifiableList(this.messages);
    }

    @SideEffectFree
    public String toString() {
        switch (this.type) {
            case FAILURE: {
                return "FAILURE: " + this.messages;
            }
            case WARNING: {
                return "WARNING: " + this.messages;
            }
        }
        return "SUCCESS";
    }

    public static class DiagMessage {
        private final String message;
        private Object[] args;

        protected DiagMessage(String message, Object[] args2) {
            this.message = message;
            this.args = args2 == null ? new Object[0] : Arrays.copyOf(args2, args2.length);
        }

        public String getMessageKey() {
            return this.message;
        }

        public Object[] getArgs() {
            return this.args;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof DiagMessage)) {
                return false;
            }
            DiagMessage other = (DiagMessage)obj;
            return this.message.equals(other.message) && Arrays.equals(this.args, other.args);
        }

        @Pure
        public int hashCode() {
            return HashCodeUtils.hash(this.message, this.args);
        }

        @SideEffectFree
        public String toString() {
            if (this.args.length == 0) {
                return this.message;
            }
            return this.message + " : " + Arrays.toString(this.args);
        }
    }

    private static enum Type {
        SUCCESS,
        FAILURE,
        WARNING;


        public static final Type merge(Type a, Type b) {
            if (a == FAILURE || b == FAILURE) {
                return FAILURE;
            }
            if (a == WARNING || b == WARNING) {
                return WARNING;
            }
            return SUCCESS;
        }
    }
}

