/*
 * Decompiled with CFR 0.152.
 */
package checkers.types;

import checkers.types.AnnotatedTypeMirror;
import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.TargetType;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeAnnotationPosition;
import java.util.Collections;
import java.util.List;
import javacutils.ElementUtils;
import javacutils.ErrorReporter;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;

public class TypeFromElement {
    private static final boolean strict = true;
    private static final boolean debug = false;

    public static void annotate(AnnotatedTypeMirror type2, Element element) {
        if (element == null) {
            ErrorReporter.errorAbort("TypeFromElement.annotate: element cannot be null");
        } else if (element.getKind().isField()) {
            TypeFromElement.annotateField(type2, (VariableElement)element);
        } else if (element.getKind() == ElementKind.LOCAL_VARIABLE) {
            TypeFromElement.annotateLocal(type2, (VariableElement)element);
        } else if (element instanceof TypeElement) {
            TypeFromElement.annotateType((AnnotatedTypeMirror.AnnotatedDeclaredType)type2, (TypeElement)element);
        } else if (element instanceof ExecutableElement) {
            TypeFromElement.annotateExec((AnnotatedTypeMirror.AnnotatedExecutableType)type2, (ExecutableElement)element);
        } else if (element.getKind() == ElementKind.PARAMETER) {
            TypeFromElement.annotateParam(type2, element);
        } else if (element.getKind() == ElementKind.TYPE_PARAMETER) {
            TypeFromElement.annotateTypeParam(type2, element);
        } else if (element.getKind() == ElementKind.EXCEPTION_PARAMETER) {
            TypeFromElement.annotateLocal(type2, (VariableElement)element);
        } else if (element.getKind() == ElementKind.RESOURCE_VARIABLE) {
            TypeFromElement.annotateLocal(type2, (VariableElement)element);
        } else {
            ErrorReporter.errorAbort("TypeFromElement.annotate: illegal argument: " + element + " [" + (Object)((Object)element.getKind()) + "]");
        }
    }

    private static void annotateTypeParam(AnnotatedTypeMirror type2, Element element) {
        Element enclosing = element.getEnclosingElement();
        if (enclosing instanceof TypeElement) {
            TypeElement clsElt = (TypeElement)enclosing;
            if (clsElt.getTypeParameters().contains(element)) {
                int param_index = clsElt.getTypeParameters().indexOf(element);
                block8: for (Attribute.TypeCompound typeAnno : ((Symbol.ClassSymbol)clsElt).getRawTypeAttributes()) {
                    switch (typeAnno.position.type) {
                        case CLASS_TYPE_PARAMETER: 
                        case CLASS_TYPE_PARAMETER_BOUND: {
                            if (typeAnno.position.parameter_index != param_index) continue block8;
                            TypeFromElement.annotatePossibleBound(type2, typeAnno, typeAnno.position.type == TargetType.CLASS_TYPE_PARAMETER_BOUND);
                            continue block8;
                        }
                        case CLASS_EXTENDS: {
                            continue block8;
                        }
                    }
                    ErrorReporter.errorAbort("TypeFromElement.annotateTypeParam(class): invalid position " + typeAnno.position + " for annotation: " + typeAnno + " for element: " + ElementUtils.getVerboseName(element));
                }
            } else {
                ErrorReporter.errorAbort("TypeFromElement.annotateTypeParam(class): not found in enclosing element: " + ElementUtils.getVerboseName(element));
            }
        } else if (enclosing instanceof ExecutableElement) {
            ExecutableElement execElt = (ExecutableElement)enclosing;
            if (execElt.getTypeParameters().contains(element)) {
                int param_index = execElt.getTypeParameters().indexOf(element);
                block9: for (Attribute.TypeCompound typeAnno : ((Symbol.MethodSymbol)execElt).getRawTypeAttributes()) {
                    switch (typeAnno.position.type) {
                        case METHOD_TYPE_PARAMETER: 
                        case METHOD_TYPE_PARAMETER_BOUND: {
                            if (typeAnno.position.parameter_index != param_index) continue block9;
                            TypeFromElement.annotatePossibleBound(type2, typeAnno, typeAnno.position.type == TargetType.METHOD_TYPE_PARAMETER_BOUND);
                            continue block9;
                        }
                        case METHOD_RETURN: 
                        case METHOD_FORMAL_PARAMETER: 
                        case METHOD_RECEIVER: 
                        case LOCAL_VARIABLE: 
                        case RESOURCE_VARIABLE: 
                        case EXCEPTION_PARAMETER: 
                        case NEW: 
                        case CAST: 
                        case INSTANCEOF: 
                        case METHOD_INVOCATION_TYPE_ARGUMENT: 
                        case CONSTRUCTOR_INVOCATION_TYPE_ARGUMENT: 
                        case METHOD_REFERENCE: 
                        case CONSTRUCTOR_REFERENCE: 
                        case METHOD_REFERENCE_TYPE_ARGUMENT: 
                        case CONSTRUCTOR_REFERENCE_TYPE_ARGUMENT: {
                            continue block9;
                        }
                    }
                    ErrorReporter.errorAbort("TypeFromElement.annotateTypeParam(method): invalid position " + typeAnno.position + " for annotation: " + typeAnno + " for element: " + ElementUtils.getVerboseName(element));
                }
            } else {
                ErrorReporter.errorAbort("TypeFromElement.annotateTypeParam(method): not found in enclosing element: " + ElementUtils.getVerboseName(element));
            }
        } else if (((Symbol)enclosing).kind != false) {
            ErrorReporter.errorAbort("TypeFromElement.annotateTypeParam: enclosing element not a type or executable: " + enclosing + " [" + (Object)((Object)enclosing.getKind()) + ", " + enclosing.getClass() + ": \"" + enclosing + "\"]");
        }
    }

    private static void annotateParam(AnnotatedTypeMirror type2, Element element) {
        Element enclosing = element.getEnclosingElement();
        if (enclosing instanceof ExecutableElement) {
            ExecutableElement execElt = (ExecutableElement)enclosing;
            if (execElt.getParameters().contains(element)) {
                int param_index = execElt.getParameters().indexOf(element);
                block8: for (Attribute.TypeCompound typeAnno : ((Symbol.MethodSymbol)execElt).getRawTypeAttributes()) {
                    switch (typeAnno.position.type) {
                        case METHOD_FORMAL_PARAMETER: {
                            if (typeAnno.position.parameter_index != param_index) continue block8;
                            TypeFromElement.annotate(type2, typeAnno);
                            continue block8;
                        }
                        case METHOD_TYPE_PARAMETER: 
                        case METHOD_TYPE_PARAMETER_BOUND: 
                        case METHOD_RETURN: 
                        case METHOD_RECEIVER: 
                        case LOCAL_VARIABLE: 
                        case RESOURCE_VARIABLE: 
                        case EXCEPTION_PARAMETER: 
                        case NEW: 
                        case CAST: 
                        case INSTANCEOF: 
                        case METHOD_INVOCATION_TYPE_ARGUMENT: 
                        case CONSTRUCTOR_INVOCATION_TYPE_ARGUMENT: 
                        case METHOD_REFERENCE: 
                        case CONSTRUCTOR_REFERENCE: 
                        case METHOD_REFERENCE_TYPE_ARGUMENT: 
                        case CONSTRUCTOR_REFERENCE_TYPE_ARGUMENT: 
                        case THROWS: {
                            continue block8;
                        }
                    }
                    ErrorReporter.errorAbort("TypeFromElement.annotateParam: invalid position " + typeAnno.position + " for annotation: " + typeAnno + " for element: " + ElementUtils.getVerboseName(element));
                }
            } else if (element.getSimpleName().contentEquals("this")) {
                block9: for (Attribute.TypeCompound typeAnno : ((Symbol.MethodSymbol)execElt).getRawTypeAttributes()) {
                    switch (typeAnno.position.type) {
                        case METHOD_RECEIVER: {
                            TypeFromElement.annotate(type2, typeAnno);
                            continue block9;
                        }
                        case METHOD_TYPE_PARAMETER: 
                        case METHOD_TYPE_PARAMETER_BOUND: 
                        case METHOD_RETURN: 
                        case METHOD_FORMAL_PARAMETER: 
                        case LOCAL_VARIABLE: 
                        case RESOURCE_VARIABLE: 
                        case EXCEPTION_PARAMETER: 
                        case NEW: 
                        case CAST: 
                        case INSTANCEOF: 
                        case METHOD_INVOCATION_TYPE_ARGUMENT: 
                        case CONSTRUCTOR_INVOCATION_TYPE_ARGUMENT: 
                        case METHOD_REFERENCE: 
                        case CONSTRUCTOR_REFERENCE: 
                        case METHOD_REFERENCE_TYPE_ARGUMENT: 
                        case CONSTRUCTOR_REFERENCE_TYPE_ARGUMENT: 
                        case THROWS: {
                            continue block9;
                        }
                    }
                    ErrorReporter.errorAbort("TypeFromElement.annotateParam: invalid position " + typeAnno.position + " for annotation: " + typeAnno + " for element: " + ElementUtils.getVerboseName(element));
                }
            } else {
                ErrorReporter.errorAbort("TypeFromElement.annotateParam: element: " + element + " not found in enclosing executable: " + enclosing);
            }
        } else {
            ErrorReporter.errorAbort("TypeFromElement.annotateParam: enclosing element not an executable: " + enclosing);
        }
    }

    private static void annotateField(AnnotatedTypeMirror type2, VariableElement element) {
        if (!element.getKind().isField()) {
            ErrorReporter.errorAbort("TypeFromElement.annotateField: invalid non-field element " + element + " [" + (Object)((Object)element.getKind()) + "]");
        }
        Symbol.VarSymbol symbol = (Symbol.VarSymbol)element;
        block4: for (Attribute.TypeCompound anno : symbol.getRawTypeAttributes()) {
            TypeAnnotationPosition pos = anno.position;
            switch (pos.type) {
                case FIELD: {
                    TypeFromElement.annotate(type2, anno);
                    continue block4;
                }
                case NEW: 
                case CAST: 
                case INSTANCEOF: 
                case METHOD_INVOCATION_TYPE_ARGUMENT: 
                case CONSTRUCTOR_INVOCATION_TYPE_ARGUMENT: 
                case METHOD_REFERENCE: 
                case CONSTRUCTOR_REFERENCE: 
                case METHOD_REFERENCE_TYPE_ARGUMENT: 
                case CONSTRUCTOR_REFERENCE_TYPE_ARGUMENT: {
                    continue block4;
                }
            }
            ErrorReporter.errorAbort("TypeFromElement.annotateField: invalid position " + (Object)((Object)pos.type) + " for annotation: " + anno + " for element: " + ElementUtils.getVerboseName(element));
        }
    }

    private static void annotateLocal(AnnotatedTypeMirror type2, VariableElement element) {
        if (element.getKind() != ElementKind.LOCAL_VARIABLE && element.getKind() != ElementKind.RESOURCE_VARIABLE && element.getKind() != ElementKind.EXCEPTION_PARAMETER) {
            ErrorReporter.errorAbort("TypeFromElement.annotateLocal: invalid non-local-variable element " + element + " [" + (Object)((Object)element.getKind()) + "]");
        }
        Symbol.VarSymbol symbol = (Symbol.VarSymbol)element;
        block4: for (Attribute.TypeCompound anno : symbol.getRawTypeAttributes()) {
            TypeAnnotationPosition pos = anno.position;
            switch (pos.type) {
                case LOCAL_VARIABLE: 
                case RESOURCE_VARIABLE: 
                case EXCEPTION_PARAMETER: {
                    TypeFromElement.annotate(type2, anno);
                    continue block4;
                }
                case NEW: 
                case CAST: 
                case INSTANCEOF: 
                case METHOD_INVOCATION_TYPE_ARGUMENT: 
                case CONSTRUCTOR_INVOCATION_TYPE_ARGUMENT: 
                case METHOD_REFERENCE: 
                case CONSTRUCTOR_REFERENCE: 
                case METHOD_REFERENCE_TYPE_ARGUMENT: 
                case CONSTRUCTOR_REFERENCE_TYPE_ARGUMENT: {
                    continue block4;
                }
            }
            ErrorReporter.errorAbort("TypeFromElement.annotateLocal: invalid position " + (Object)((Object)pos.type) + " for annotation: " + anno + " for element: " + ElementUtils.getVerboseName(element));
        }
    }

    private static void annotateType(AnnotatedTypeMirror.AnnotatedDeclaredType type2, TypeElement element) {
        Symbol.ClassSymbol symbol = (Symbol.ClassSymbol)element;
        type2.addAnnotations(symbol.getAnnotationMirrors());
        List<AnnotatedTypeMirror> typeParameters2 = type2.getTypeArguments();
        block6: for (Attribute.TypeCompound anno : symbol.getRawTypeAttributes()) {
            TypeAnnotationPosition pos = anno.position;
            switch (pos.type) {
                case CLASS_TYPE_PARAMETER: {
                    if (pos.parameter_index >= 0 && pos.parameter_index < typeParameters2.size()) {
                        AnnotatedTypeMirror typeParam = typeParameters2.get(pos.parameter_index);
                        typeParam.addAnnotation(anno);
                        if (typeParam.getKind() == TypeKind.TYPEVAR) {
                            ((AnnotatedTypeMirror.AnnotatedTypeVariable)typeParam).getUpperBound().addAnnotation(anno);
                            break;
                        }
                        ErrorReporter.errorAbort("TypeFromElement.annotateType: type parameter: " + typeParam + " is not a type variable");
                        break;
                    }
                    ErrorReporter.errorAbort("TypeFromElement.annotateType: invalid parameter index " + pos.parameter_index + " for annotation: " + anno + " for element: " + ElementUtils.getVerboseName(element));
                    break;
                }
                case CLASS_TYPE_PARAMETER_BOUND: {
                    if (pos.parameter_index >= 0 && pos.parameter_index < typeParameters2.size()) {
                        List<AnnotatedTypeMirror> bounds = TypeFromElement.getBounds(typeParameters2.get(pos.parameter_index));
                        int boundIndex = pos.bound_index;
                        if (((Type)bounds.get(0).getUnderlyingType()).isInterface()) {
                            --boundIndex;
                        }
                        if (boundIndex >= 0 && boundIndex < bounds.size()) {
                            TypeFromElement.annotate(bounds.get(boundIndex), anno);
                            break;
                        }
                        ErrorReporter.errorAbort("TypeFromElement.annotateType: invalid bound index " + pos.bound_index + " for annotation: " + anno + " for element: " + ElementUtils.getVerboseName(element));
                        break;
                    }
                    ErrorReporter.errorAbort("TypeFromElement.annotateType: invalid parameter index " + pos.parameter_index + " for annotation: " + anno + " for element: " + ElementUtils.getVerboseName(element));
                    break;
                }
                case CLASS_EXTENDS: {
                    if (pos.type_index < -1 || !pos.location.isEmpty()) continue block6;
                    type2.addAnnotation(anno);
                    break;
                }
                case LOCAL_VARIABLE: 
                case RESOURCE_VARIABLE: 
                case EXCEPTION_PARAMETER: 
                case NEW: 
                case CAST: 
                case INSTANCEOF: 
                case METHOD_INVOCATION_TYPE_ARGUMENT: 
                case CONSTRUCTOR_INVOCATION_TYPE_ARGUMENT: 
                case METHOD_REFERENCE: 
                case CONSTRUCTOR_REFERENCE: 
                case METHOD_REFERENCE_TYPE_ARGUMENT: 
                case CONSTRUCTOR_REFERENCE_TYPE_ARGUMENT: {
                    break;
                }
                default: {
                    ErrorReporter.errorAbort("TypeFromElement.annotateType: invalid position " + (Object)((Object)pos.type) + " for annotation: " + anno + " for element: " + ElementUtils.getVerboseName(element));
                }
            }
        }
    }

    public static void annotateSupers(List<AnnotatedTypeMirror.AnnotatedDeclaredType> supertypes2, TypeElement element) {
        Symbol.ClassSymbol symbol = (Symbol.ClassSymbol)element;
        boolean hasSuperClass = element.getSuperclass().getKind() != TypeKind.NONE;
        AnnotatedTypeMirror.AnnotatedDeclaredType superClassType = hasSuperClass ? supertypes2.get(0) : null;
        List<AnnotatedTypeMirror.AnnotatedDeclaredType> superInterfaces = hasSuperClass ? TypeFromElement.tail(supertypes2) : supertypes2;
        block4: for (Attribute.TypeCompound anno : symbol.getRawTypeAttributes()) {
            TypeAnnotationPosition pos = anno.position;
            switch (pos.type) {
                case CLASS_EXTENDS: {
                    if (pos.type_index == -1 && superClassType != null) {
                        TypeFromElement.annotate((AnnotatedTypeMirror)superClassType, anno);
                        continue block4;
                    }
                    if (pos.type_index >= 0 && pos.type_index < superInterfaces.size()) {
                        TypeFromElement.annotate((AnnotatedTypeMirror)superInterfaces.get(pos.type_index), anno);
                        continue block4;
                    }
                    ErrorReporter.errorAbort("TypeFromElement.annotateSupers: invalid type index " + pos.type_index + " for annotation: " + anno + " for element: " + ElementUtils.getVerboseName(element));
                    continue block4;
                }
                case CLASS_TYPE_PARAMETER: 
                case CLASS_TYPE_PARAMETER_BOUND: {
                    continue block4;
                }
            }
            ErrorReporter.errorAbort("TypeFromElement.annotateSupers: invalid position " + (Object)((Object)pos.type) + " for annotation: " + anno + " for element: " + ElementUtils.getVerboseName(element));
        }
    }

    private static void annotateExec(AnnotatedTypeMirror.AnnotatedExecutableType type2, ExecutableElement element) {
        type2.setElement(element);
        Symbol.MethodSymbol symbol = (Symbol.MethodSymbol)element;
        List<AnnotatedTypeMirror> params2 = type2.getParameterTypes();
        List<AnnotatedTypeMirror.AnnotatedTypeVariable> typeParams = type2.getTypeVariables();
        for (Attribute.TypeCompound typeAnno : symbol.getRawTypeAttributes()) {
            TypeAnnotationPosition pos = typeAnno.position;
            switch (pos.type) {
                case METHOD_RECEIVER: {
                    TypeFromElement.annotate((AnnotatedTypeMirror)type2.getReceiverType(), typeAnno);
                    break;
                }
                case METHOD_RETURN: {
                    TypeFromElement.annotate(type2.getReturnType(), typeAnno);
                    break;
                }
                case METHOD_FORMAL_PARAMETER: {
                    if (pos.parameter_index >= 0 && pos.parameter_index < params2.size()) {
                        TypeFromElement.annotate(params2.get(pos.parameter_index), typeAnno);
                        break;
                    }
                    ErrorReporter.errorAbort("TypeFromElement.annotateExec: invalid parameter index " + pos.parameter_index + " for annotation: " + typeAnno + " for element: " + ElementUtils.getVerboseName(element));
                    break;
                }
                case THROWS: {
                    List<AnnotatedTypeMirror> thrown = type2.getThrownTypes();
                    if (pos.type_index >= 0 && pos.type_index < thrown.size()) {
                        TypeFromElement.annotate(thrown.get(pos.type_index), typeAnno);
                        break;
                    }
                    ErrorReporter.errorAbort("TypeFromElement.annotateExec: invalid throws index " + pos.type_index + " for annotation: " + typeAnno + " for element: " + ElementUtils.getVerboseName(element));
                    break;
                }
                case METHOD_TYPE_PARAMETER: {
                    if (pos.parameter_index >= 0 && pos.parameter_index < typeParams.size()) {
                        TypeFromElement.annotate((AnnotatedTypeMirror)typeParams.get(pos.parameter_index), typeAnno);
                        break;
                    }
                    ErrorReporter.errorAbort("TypeFromElement.annotateExec: invalid method type parameter index " + pos.parameter_index + " for annotation: " + typeAnno + " for element: " + ElementUtils.getVerboseName(element));
                    break;
                }
                case METHOD_TYPE_PARAMETER_BOUND: {
                    if (pos.parameter_index >= 0 && pos.parameter_index < typeParams.size()) {
                        List<AnnotatedTypeMirror> bounds = TypeFromElement.getBounds(typeParams.get(pos.parameter_index));
                        int boundIndex = pos.bound_index;
                        if (((Type)bounds.get(0).getUnderlyingType()).isInterface()) {
                            --boundIndex;
                        }
                        if (boundIndex >= 0 && boundIndex < bounds.size()) {
                            TypeFromElement.annotate(bounds.get(boundIndex), typeAnno);
                            break;
                        }
                        ErrorReporter.errorAbort("TypeFromElement.annotateExec: invalid method type parameter bound index " + pos.bound_index + " for annotation: " + typeAnno + " for element: " + ElementUtils.getVerboseName(element));
                        break;
                    }
                    ErrorReporter.errorAbort("TypeFromElement.annotateExec: invalid method type parameter index (bound) " + pos.parameter_index + " for annotation: " + typeAnno + " for element: " + ElementUtils.getVerboseName(element));
                    break;
                }
                case LOCAL_VARIABLE: 
                case RESOURCE_VARIABLE: 
                case EXCEPTION_PARAMETER: 
                case NEW: 
                case CAST: 
                case INSTANCEOF: 
                case METHOD_INVOCATION_TYPE_ARGUMENT: 
                case CONSTRUCTOR_INVOCATION_TYPE_ARGUMENT: 
                case METHOD_REFERENCE: 
                case CONSTRUCTOR_REFERENCE: 
                case METHOD_REFERENCE_TYPE_ARGUMENT: 
                case CONSTRUCTOR_REFERENCE_TYPE_ARGUMENT: {
                    break;
                }
                default: {
                    ErrorReporter.errorAbort("TypeFromElement.annotateExec: invalid position " + (Object)((Object)pos.type) + " for annotation: " + typeAnno + " for element: " + ElementUtils.getVerboseName(element));
                }
            }
        }
    }

    private static void annotate(AnnotatedTypeMirror type2, Attribute.TypeCompound anno) {
        TypeAnnotationPosition pos = anno.position;
        if (pos.location.isEmpty()) {
            if (type2.getKind() == TypeKind.TYPEVAR) {
                type2.removeAnnotationInHierarchy(anno);
            }
            type2.addAnnotation(anno);
        } else {
            TypeFromElement.annotate(type2, pos.location, Collections.singletonList(anno));
        }
    }

    private static void annotatePossibleBound(AnnotatedTypeMirror type2, Attribute.TypeCompound anno, boolean onBound) {
        if (!onBound) {
            TypeFromElement.annotate(type2, anno);
        } else {
            if (type2.getKind() != TypeKind.TYPEVAR && type2.getKind() != TypeKind.WILDCARD) {
                ErrorReporter.errorAbort("TypeFromElement.annotatePossibleBound: trying to add a bound annotation: " + anno + "to something that is not a type variable or wildcard: " + type2);
                return;
            }
            List<AnnotatedTypeMirror> bounds = TypeFromElement.getBounds(type2);
            int boundIndex = anno.position.bound_index;
            if (((Type)bounds.get(0).getUnderlyingType()).isInterface()) {
                --boundIndex;
            }
            if (boundIndex >= 0 && boundIndex < bounds.size()) {
                TypeFromElement.annotate(bounds.get(boundIndex), anno);
            } else {
                ErrorReporter.errorAbort("TypeFromElement.annotatePossibleBound: invalid boundIndex " + boundIndex + " for annotation: " + anno);
            }
        }
    }

    private static void annotate(AnnotatedTypeMirror type2, List<TypeAnnotationPosition.TypePathEntry> location, List<? extends AnnotationMirror> annotations2) {
        AnnotatedTypeMirror inner = TypeFromElement.getLocationTypeATM(type2, location);
        inner.addAnnotations(annotations2);
    }

    private static AnnotatedTypeMirror getLocationTypeATM(AnnotatedTypeMirror type2, List<TypeAnnotationPosition.TypePathEntry> location) {
        if (location.isEmpty()) {
            return type2;
        }
        if (type2.getKind() == TypeKind.DECLARED) {
            return TypeFromElement.getLocationTypeADT((AnnotatedTypeMirror.AnnotatedDeclaredType)type2, location);
        }
        if (type2.getKind() == TypeKind.WILDCARD) {
            return TypeFromElement.getLocationTypeAWT((AnnotatedTypeMirror.AnnotatedWildcardType)type2, location);
        }
        if (type2.getKind() == TypeKind.ARRAY) {
            return TypeFromElement.getLocationTypeAAT((AnnotatedTypeMirror.AnnotatedArrayType)type2, location);
        }
        ErrorReporter.errorAbort("TypeFromElement.getLocationTypeATM: only declared types and arrays can have annotations with location; found type: " + type2 + " location: " + location);
        return null;
    }

    private static AnnotatedTypeMirror getLocationTypeADT(AnnotatedTypeMirror.AnnotatedDeclaredType type2, List<TypeAnnotationPosition.TypePathEntry> location) {
        if (location.isEmpty()) {
            return type2;
        }
        if (location.get((int)0).tag.equals((Object)TypeAnnotationPosition.TypePathEntryKind.TYPE_ARGUMENT) && location.get((int)0).arg < type2.getTypeArguments().size()) {
            return TypeFromElement.getLocationTypeATM(type2.getTypeArguments().get(location.get((int)0).arg), TypeFromElement.tail(location));
        }
        if (location.get((int)0).tag.equals((Object)TypeAnnotationPosition.TypePathEntryKind.INNER_TYPE)) {
            int totalEncl = TypeFromElement.countEnclosing(type2);
            int totalInner = TypeFromElement.countInner(location);
            if (totalInner > totalEncl) {
                System.out.println("TypeFromElement.getLocationTypeADT: too many INNER_TYPE tags!\n    Found location: " + location + " for type: " + type2);
                return type2;
            }
            if (totalInner == totalEncl) {
                List<TypeAnnotationPosition.TypePathEntry> loc = location;
                for (int i = 0; i < totalEncl; ++i) {
                    loc = TypeFromElement.tail(loc);
                }
                return TypeFromElement.getLocationTypeATM(type2, loc);
            }
            AnnotatedTypeMirror.AnnotatedDeclaredType toret = type2;
            List<TypeAnnotationPosition.TypePathEntry> loc = location;
            for (int i = 0; i < totalEncl - totalInner; ++i) {
                if (toret.getEnclosingType() != null) {
                    toret = toret.getEnclosingType();
                    loc = TypeFromElement.tail(loc);
                    continue;
                }
                System.out.println("TypeFromElement.getLocationTypeADT: not enough enclosing types!\n    Found location: " + location + " for type: " + type2);
            }
            return TypeFromElement.getLocationTypeATM(toret, loc);
        }
        System.out.println("TypeFromElement.getLocationTypeADT: something is wrong!\n    Found location: " + location + " for type: " + type2);
        return type2;
    }

    private static int countInner(List<TypeAnnotationPosition.TypePathEntry> location) {
        int cnt = 0;
        while (!location.isEmpty() && location.get((int)0).tag.equals((Object)TypeAnnotationPosition.TypePathEntryKind.INNER_TYPE)) {
            ++cnt;
            location = TypeFromElement.tail(location);
        }
        return cnt;
    }

    private static int countEnclosing(AnnotatedTypeMirror.AnnotatedDeclaredType type2) {
        int cnt = 0;
        while (type2.getEnclosingType() != null) {
            ++cnt;
            type2 = type2.getEnclosingType();
        }
        return cnt;
    }

    private static AnnotatedTypeMirror getLocationTypeAWT(AnnotatedTypeMirror.AnnotatedWildcardType type2, List<TypeAnnotationPosition.TypePathEntry> location) {
        if (location.isEmpty()) {
            return type2;
        }
        if (location.get((int)0).tag.equals((Object)TypeAnnotationPosition.TypePathEntryKind.WILDCARD)) {
            List<AnnotatedTypeMirror> bounds = TypeFromElement.getBounds(type2);
            return TypeFromElement.getLocationTypeATM(bounds.get(0), TypeFromElement.tail(location));
        }
        System.out.println("TypeFromElement.getLocationTypeAWT: type not handled.\n    Found location: " + location + " for type: " + type2);
        return type2;
    }

    private static AnnotatedTypeMirror getLocationTypeAAT(AnnotatedTypeMirror.AnnotatedArrayType type2, List<TypeAnnotationPosition.TypePathEntry> location) {
        if (location.size() >= 1 && location.get((int)0).tag.equals((Object)TypeAnnotationPosition.TypePathEntryKind.ARRAY)) {
            AnnotatedTypeMirror comptype = type2.getComponentType();
            return TypeFromElement.getLocationTypeATM(comptype, TypeFromElement.tail(location));
        }
        ErrorReporter.errorAbort("TypeFromElement.annotateAAT: invalid location " + location + " for type: " + type2);
        return null;
    }

    private static <T> List<T> tail(List<T> list2) {
        return list2.subList(1, list2.size());
    }

    private static List<AnnotatedTypeMirror> getBounds(AnnotatedTypeMirror type2) {
        AnnotatedTypeMirror bound = null;
        if (type2.getKind() == TypeKind.TYPEVAR) {
            bound = ((AnnotatedTypeMirror.AnnotatedTypeVariable)type2).getUpperBound();
        } else if (type2.getKind() == TypeKind.WILDCARD) {
            AnnotatedTypeMirror.AnnotatedWildcardType wt = (AnnotatedTypeMirror.AnnotatedWildcardType)type2;
            bound = wt.getUnderlyingType().getExtendsBound() != null ? wt.getExtendsBound() : wt.getSuperBound();
            if (bound == null) {
                bound = wt.getExtendsBound();
            }
        } else {
            ErrorReporter.errorAbort("TypeFromElement.getBounds: type has no bounds: " + type2 + " [" + (Object)((Object)type2.getKind()) + "]");
        }
        if (bound == null) {
            return Collections.emptyList();
        }
        if (bound.getKind() == TypeKind.INTERSECTION) {
            return Collections.unmodifiableList(bound.directSuperTypes());
        }
        return Collections.singletonList(bound);
    }
}

