/*
 * Decompiled with CFR 0.152.
 */
package checkers.units;

import checkers.basetype.BaseAnnotatedTypeFactory;
import checkers.basetype.BaseTypeChecker;
import checkers.quals.Bottom;
import checkers.quals.Unqualified;
import checkers.types.AnnotatedTypeMirror;
import checkers.types.QualifierHierarchy;
import checkers.types.TreeAnnotator;
import checkers.units.UnitsRelations;
import checkers.units.UnitsRelationsDefault;
import checkers.units.quals.A;
import checkers.units.quals.Area;
import checkers.units.quals.C;
import checkers.units.quals.Current;
import checkers.units.quals.K;
import checkers.units.quals.Length;
import checkers.units.quals.Luminance;
import checkers.units.quals.Mass;
import checkers.units.quals.MixedUnits;
import checkers.units.quals.Prefix;
import checkers.units.quals.Speed;
import checkers.units.quals.Substance;
import checkers.units.quals.Temperature;
import checkers.units.quals.Time;
import checkers.units.quals.UnitsMultiple;
import checkers.units.quals.cd;
import checkers.units.quals.g;
import checkers.units.quals.h;
import checkers.units.quals.km2;
import checkers.units.quals.kmPERh;
import checkers.units.quals.m;
import checkers.units.quals.m2;
import checkers.units.quals.mPERs;
import checkers.units.quals.min;
import checkers.units.quals.mm2;
import checkers.units.quals.mol;
import checkers.units.quals.s;
import checkers.util.AnnotationBuilder;
import checkers.util.GraphQualifierHierarchy;
import checkers.util.MultiGraphQualifierHierarchy;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.Tree;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javacutils.AnnotationUtils;
import javax.lang.model.element.AnnotationMirror;
import javax.tools.Diagnostic;

public class UnitsAnnotatedTypeFactory
extends BaseAnnotatedTypeFactory {
    protected final AnnotationMirror mixedUnits;
    private Map<String, UnitsRelations> unitsRel;
    private final Map<String, AnnotationMirror> aliasMap;

    public UnitsAnnotatedTypeFactory(BaseTypeChecker checker) {
        super(checker, false);
        this.mixedUnits = AnnotationUtils.fromClass(this.elements, MixedUnits.class);
        this.aliasMap = new HashMap<String, AnnotationMirror>();
        AnnotationMirror BOTTOM = AnnotationUtils.fromClass(this.elements, Bottom.class);
        this.postInit();
        this.treeAnnotator.addTreeKind(Tree.Kind.NULL_LITERAL, BOTTOM);
        this.typeAnnotator.addTypeName(Void.class, BOTTOM);
    }

    protected Map<String, UnitsRelations> getUnitsRel() {
        if (this.unitsRel == null) {
            this.unitsRel = new HashMap<String, UnitsRelations>();
        }
        return this.unitsRel;
    }

    @Override
    public AnnotationMirror aliasedAnnotation(AnnotationMirror a) {
        String aname = a.getAnnotationType().toString();
        if (this.aliasMap.containsKey(aname)) {
            return this.aliasMap.get(aname);
        }
        for (AnnotationMirror annotationMirror : a.getAnnotationType().asElement().getAnnotationMirrors()) {
            if (!annotationMirror.getAnnotationType().toString().equals(UnitsMultiple.class.getCanonicalName())) continue;
            Class<?> theclass = AnnotationUtils.getElementValueClass(annotationMirror, "quantity", true);
            Prefix prefix2 = AnnotationUtils.getElementValueEnum(annotationMirror, "prefix", Prefix.class, true);
            AnnotationBuilder builder = new AnnotationBuilder(this.processingEnv, theclass);
            builder.setValue((CharSequence)"value", prefix2);
            AnnotationMirror res = builder.build();
            this.aliasMap.put(aname, res);
            return res;
        }
        return super.aliasedAnnotation(a);
    }

    @Override
    protected Set<Class<? extends Annotation>> createSupportedTypeQualifiers() {
        HashSet qualSet = new HashSet();
        String qualNames = this.checker.getOption("units");
        if (qualNames != null) {
            for (String qualName : qualNames.split(",")) {
                try {
                    Class<?> q = Class.forName(qualName);
                    qualSet.add(q);
                    this.addUnitsRelations(q);
                }
                catch (ClassNotFoundException e) {
                    String msg = "Could not find class for unit: " + qualName + ". Ignoring unit.";
                    this.checker.message(Diagnostic.Kind.WARNING, this.root, msg, new Object[0]);
                }
            }
        }
        this.getUnitsRel().put("checkers.units.UnitsRelationsDefault", new UnitsRelationsDefault().init(this.processingEnv));
        qualSet.add(Unqualified.class);
        qualSet.add(Length.class);
        qualSet.add(m.class);
        qualSet.add(Time.class);
        qualSet.add(s.class);
        qualSet.add(min.class);
        qualSet.add(h.class);
        qualSet.add(Speed.class);
        qualSet.add(mPERs.class);
        qualSet.add(kmPERh.class);
        qualSet.add(Area.class);
        qualSet.add(mm2.class);
        qualSet.add(m2.class);
        qualSet.add(km2.class);
        qualSet.add(Current.class);
        qualSet.add(A.class);
        qualSet.add(Mass.class);
        qualSet.add(g.class);
        qualSet.add(Substance.class);
        qualSet.add(mol.class);
        qualSet.add(Luminance.class);
        qualSet.add(cd.class);
        qualSet.add(Temperature.class);
        qualSet.add(C.class);
        qualSet.add(K.class);
        qualSet.add(Bottom.class);
        return Collections.unmodifiableSet(qualSet);
    }

    private void addUnitsRelations(Class<? extends Annotation> qual) {
        AnnotationMirror am = AnnotationUtils.fromClass(this.elements, qual);
        for (AnnotationMirror annotationMirror : am.getAnnotationType().asElement().getAnnotationMirrors()) {
            if (!annotationMirror.getAnnotationType().toString().equals(UnitsRelations.class.getCanonicalName())) continue;
            Class<?> theclass = AnnotationUtils.getElementValueClass(annotationMirror, "value", true);
            String classname = theclass.getCanonicalName();
            if (this.getUnitsRel().containsKey(classname)) continue;
            try {
                this.unitsRel.put(classname, ((UnitsRelations)theclass.newInstance()).init(this.processingEnv));
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    protected TreeAnnotator createTreeAnnotator() {
        return new UnitsTreeAnnotator(this);
    }

    @Override
    public QualifierHierarchy createQualifierHierarchy(MultiGraphQualifierHierarchy.MultiGraphFactory factory) {
        return new UnitsQualifierHierarchy(factory, AnnotationUtils.fromClass(this.elements, Bottom.class));
    }

    private AnnotationMirror stripValues(AnnotationMirror anno) {
        return AnnotationUtils.fromName(this.elements, anno.getAnnotationType().toString());
    }

    protected class UnitsQualifierHierarchy
    extends GraphQualifierHierarchy {
        public UnitsQualifierHierarchy(MultiGraphQualifierHierarchy.MultiGraphFactory f, AnnotationMirror bottom) {
            super(f, bottom);
        }

        @Override
        public boolean isSubtype(AnnotationMirror rhs, AnnotationMirror lhs) {
            if (AnnotationUtils.areSameIgnoringValues(lhs, rhs)) {
                return AnnotationUtils.areSame(lhs, rhs);
            }
            lhs = UnitsAnnotatedTypeFactory.this.stripValues(lhs);
            rhs = UnitsAnnotatedTypeFactory.this.stripValues(rhs);
            return super.isSubtype(rhs, lhs);
        }
    }

    private class UnitsTreeAnnotator
    extends TreeAnnotator {
        UnitsTreeAnnotator(UnitsAnnotatedTypeFactory atypeFactory) {
            super(atypeFactory);
        }

        @Override
        public Void visitBinary(BinaryTree node, AnnotatedTypeMirror type2) {
            AnnotatedTypeMirror lht = UnitsAnnotatedTypeFactory.this.getAnnotatedType(node.getLeftOperand());
            AnnotatedTypeMirror rht = UnitsAnnotatedTypeFactory.this.getAnnotatedType(node.getRightOperand());
            Tree.Kind kind = node.getKind();
            AnnotationMirror bestres = null;
            for (UnitsRelations ur : UnitsAnnotatedTypeFactory.this.unitsRel.values()) {
                AnnotationMirror res = this.useUnitsRelation(kind, ur, lht, rht);
                if (bestres != null && res != null && !bestres.equals(res)) {
                    System.out.println("UnitsRelation mismatch, taking neither! Previous: " + bestres + " and current: " + res);
                    return null;
                }
                if (res == null) continue;
                bestres = res;
            }
            if (bestres != null) {
                type2.addAnnotation(bestres);
            } else {
                switch (kind) {
                    case MINUS: 
                    case PLUS: {
                        if (lht.getAnnotations().equals(rht.getAnnotations())) {
                            type2.addAnnotations(lht.getAnnotations());
                            break;
                        }
                        type2.addAnnotation(UnitsAnnotatedTypeFactory.this.mixedUnits);
                        break;
                    }
                    case DIVIDE: {
                        if (!lht.getAnnotations().equals(rht.getAnnotations())) break;
                        break;
                    }
                    case MULTIPLY: {
                        if (this.noUnits(lht)) {
                            type2.addAnnotations(rht.getAnnotations());
                            break;
                        }
                        if (this.noUnits(rht)) {
                            type2.addAnnotations(lht.getAnnotations());
                            break;
                        }
                        type2.addAnnotation(UnitsAnnotatedTypeFactory.this.mixedUnits);
                        break;
                    }
                    case REMAINDER: {
                        break;
                    }
                }
            }
            return null;
        }

        private boolean noUnits(AnnotatedTypeMirror t) {
            Set<AnnotationMirror> annos = t.getAnnotations();
            return annos.isEmpty() || annos.size() == 1 && AnnotatedTypeMirror.isUnqualified(annos.iterator().next());
        }

        @Override
        public Void visitCompoundAssignment(CompoundAssignmentTree node, AnnotatedTypeMirror type2) {
            ExpressionTree var = node.getVariable();
            AnnotatedTypeMirror varType = UnitsAnnotatedTypeFactory.this.getAnnotatedType(var);
            type2.replaceAnnotations(varType.getAnnotations());
            return super.visitCompoundAssignment(node, type2);
        }

        private AnnotationMirror useUnitsRelation(Tree.Kind kind, UnitsRelations ur, AnnotatedTypeMirror lht, AnnotatedTypeMirror rht) {
            AnnotationMirror res = null;
            if (ur != null) {
                switch (kind) {
                    case DIVIDE: {
                        res = ur.division(lht, rht);
                        break;
                    }
                    case MULTIPLY: {
                        res = ur.multiplication(lht, rht);
                        break;
                    }
                }
            }
            return res;
        }
    }
}

