/*
 * Decompiled with CFR 0.152.
 */
package checkers.util;

import checkers.util.ExecUtil;
import checkers.util.PluginUtil;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CheckerMain {
    protected final File jdkJar;
    protected final File javacJar;
    protected final File checkersJar;
    private final List<String> compilationBootclasspath;
    private final List<String> runtimeBootClasspath;
    private final List<String> jvmOpts;
    private final List<String> cpOpts;
    private final List<String> toolOpts;
    private final List<File> argListFiles;
    protected static final Pattern BOOT_CLASS_PATH_REGEX = Pattern.compile("^(?:-J){0,1}-Xbootclasspath/p:(.*)$");
    protected static final Pattern JVM_OPTS_REGEX = Pattern.compile("^(?:-J)(.*)$");

    public static void main(String[] args2) {
        File pathToThisJar = new File(CheckerMain.findPathTo(CheckerMain.class, false));
        CheckerMain program = new CheckerMain(pathToThisJar, args2);
        int exitStatus = program.invokeCompiler();
        System.exit(exitStatus);
    }

    public CheckerMain(File checkersJar, String[] args2) {
        File searchPath = checkersJar.getParentFile();
        this.checkersJar = checkersJar;
        ArrayList<String> argsList = new ArrayList<String>(Arrays.asList(args2));
        this.argListFiles = this.collectArgLists(argsList);
        this.javacJar = CheckerMain.extractFileArg("-javacJar", new File(searchPath, "javac.jar"), argsList);
        String jdkJarName = CheckerMain.getJdkJarName();
        this.jdkJar = CheckerMain.extractFileArg("-jdkJar", new File(searchPath, jdkJarName), argsList);
        this.compilationBootclasspath = this.createCompilationBootclasspath(argsList);
        this.runtimeBootClasspath = this.createRuntimeBootclasspath(argsList);
        this.jvmOpts = CheckerMain.extractJvmOpts(argsList);
        this.cpOpts = this.createCpOpts(argsList);
        this.toolOpts = argsList;
        this.assertValidState();
    }

    protected void assertValidState() {
        CheckerMain.assertFilesExist(Arrays.asList(this.javacJar, this.jdkJar, this.checkersJar));
    }

    protected List<String> createRuntimeBootclasspath(List<String> argsList) {
        return new ArrayList<String>(Arrays.asList(this.javacJar.getAbsolutePath()));
    }

    protected List<String> createCompilationBootclasspath(List<String> argsList) {
        List<String> extractedBcp = CheckerMain.extractBootClassPath(argsList);
        extractedBcp.add(0, this.jdkJar.getAbsolutePath());
        return extractedBcp;
    }

    protected List<String> createCpOpts(List<String> argsList) {
        List<String> extractedOps = CheckerMain.extractCpOpts(argsList);
        extractedOps.add(0, this.checkersJar.getAbsolutePath());
        return extractedOps;
    }

    protected List<File> collectArgLists(List<String> args2) {
        ArrayList<File> argListFiles = new ArrayList<File>();
        for (String arg : args2) {
            if (!arg.startsWith("@")) continue;
            argListFiles.add(new File(arg.substring(1)));
        }
        return argListFiles;
    }

    protected static String extractArg(String argumentName, String alternative, List<String> args2) {
        for (int i = 0; i < args2.size(); ++i) {
            if (!args2.get(i).trim().equals(argumentName)) continue;
            if (i == args2.size() - 1) {
                throw new RuntimeException("Argument " + argumentName + " specified but given no value!");
            }
            args2.remove(i);
            return args2.remove(i);
        }
        return alternative;
    }

    protected static File extractFileArg(String argumentName, File alternative, List<String> args2) {
        String filePath = CheckerMain.extractArg(argumentName, null, args2);
        if (filePath == null) {
            return alternative;
        }
        return new File(filePath);
    }

    protected static String prepFilePath(String previous, File ... files) {
        if (files == null || files.length == 0) {
            throw new RuntimeException("Prepending empty or null array to file path! files == " + (files == null ? " null" : " Empty"));
        }
        String path = files[0].getAbsolutePath();
        for (int i = 1; i < files.length; ++i) {
            path = path + File.pathSeparator + files[i].getAbsolutePath();
        }
        if (previous == null || previous.isEmpty()) {
            return path;
        }
        return path + File.pathSeparator + previous;
    }

    protected static List<String> extractOptWPattern(Pattern pattern, boolean allowEmpties, List<String> args2) {
        ArrayList<String> matchedArgs = new ArrayList<String>();
        int i = 0;
        while (i < args2.size()) {
            Matcher matcher = pattern.matcher(args2.get(i));
            if (matcher.matches()) {
                String arg = matcher.group(1).trim();
                if (!arg.isEmpty() || allowEmpties) {
                    matchedArgs.add(arg);
                }
                args2.remove(i);
                continue;
            }
            ++i;
        }
        return matchedArgs;
    }

    protected static List<String> extractBootClassPath(List<String> args2) {
        return CheckerMain.extractOptWPattern(BOOT_CLASS_PATH_REGEX, false, args2);
    }

    protected static List<String> extractJvmOpts(List<String> args2) {
        return CheckerMain.extractOptWPattern(JVM_OPTS_REGEX, false, args2);
    }

    protected static List<String> extractCpOpts(List<String> args2) {
        ArrayList<String> actualArgs = new ArrayList<String>();
        String path = null;
        int i = 0;
        while (i < args2.size()) {
            if (args2.get(i).equals("-cp") || args2.get(i).equals("-classpath")) {
                if (args2.size() <= i) continue;
                args2.remove(i);
                path = args2.remove(i);
                continue;
            }
            ++i;
        }
        if (path == null) {
            String systemClassPath = System.getenv("CLASSPATH");
            if (systemClassPath != null && !systemClassPath.trim().isEmpty()) {
                actualArgs.add(System.getenv("CLASSPATH"));
            }
            actualArgs.add(".");
        } else {
            actualArgs.add(path);
        }
        return actualArgs;
    }

    protected void addMainArgs(List<String> args2) {
        args2.add("-jar");
        args2.add(this.javacJar.getAbsolutePath());
    }

    protected int invokeCompiler() {
        ArrayList<String> args2 = new ArrayList<String>(this.jvmOpts.size() + this.cpOpts.size() + this.toolOpts.size() + 5);
        String java = PluginUtil.getJavaCommand(System.getProperty("java.home"), System.out);
        args2.add(java);
        args2.add("-Xbootclasspath/p:" + PluginUtil.join(File.pathSeparator, this.runtimeBootClasspath));
        args2.add("-ea");
        args2.add("-ea:com.sun.tools...");
        args2.addAll(this.jvmOpts);
        this.addMainArgs(args2);
        args2.add("-Xbootclasspath/p:" + PluginUtil.join(File.pathSeparator, this.compilationBootclasspath));
        if (!CheckerMain.argsListHasClassPath(this.argListFiles)) {
            args2.add("-classpath");
            args2.add(CheckerMain.quote(PluginUtil.join(File.pathSeparator, this.cpOpts)));
        }
        args2.addAll(this.toolOpts);
        return ExecUtil.execute(args2.toArray(new String[args2.size()]), System.out, System.err);
    }

    private static boolean argsListHasClassPath(List<File> argListFiles) {
        for (String arg : CheckerMain.expandArgs(argListFiles)) {
            if (!arg.contains("-classpath ") && !arg.contains("-cp ")) continue;
            return true;
        }
        return false;
    }

    protected static List<String> expandArgs(List<File> args2) {
        ArrayList<String> actualArgs = new ArrayList<String>();
        for (File latest : args2) {
            try {
                actualArgs.addAll(PluginUtil.readArgFile(latest));
            }
            catch (IOException exc) {
                throw new RuntimeException("Could not open file: " + latest.getAbsolutePath(), exc);
            }
        }
        return actualArgs;
    }

    public static String getJdkJarName() {
        String fileName;
        double jreVersion = CheckerMain.getJreVersion();
        if (jreVersion == 1.4 || jreVersion == 1.5 || jreVersion == 1.6) {
            fileName = "jdk6.jar";
        } else if (jreVersion == 1.7) {
            fileName = "jdk7.jar";
        } else if (jreVersion == 1.8) {
            fileName = "jdk8.jar";
        } else {
            throw new AssertionError((Object)("Unsupported JRE version: " + jreVersion));
        }
        return fileName;
    }

    public static double getJreVersion() {
        String jreVersionStr;
        Pattern versionPattern = Pattern.compile("^(\\d\\.\\d+)\\..*$");
        Matcher versionMatcher = versionPattern.matcher(jreVersionStr = System.getProperty("java.version"));
        if (!versionMatcher.matches()) {
            throw new RuntimeException("Could not determine version from property java.version=" + jreVersionStr);
        }
        double version = Double.parseDouble(versionMatcher.group(1));
        return version;
    }

    public static String findPathTo(Class<?> context, boolean directory) throws IllegalStateException {
        String rawName;
        int idx;
        String classFileName;
        String uri;
        if (context == null) {
            context = CheckerMain.class;
        }
        if ((uri = context.getResource(classFileName = ((idx = (rawName = context.getName()).lastIndexOf(46)) == -1 ? rawName : rawName.substring(idx + 1)) + ".class").toString()).startsWith("file:")) {
            if (directory) {
                return uri;
            }
            throw new IllegalStateException("This class has been loaded from a directory and not from a jar file.");
        }
        if (!uri.startsWith("jar:file:")) {
            int idx2 = uri.indexOf(58);
            String protocol = idx2 == -1 ? "(unknown)" : uri.substring(0, idx2);
            throw new IllegalStateException("This class has been loaded remotely via the " + protocol + " protocol. Only loading from a jar on the local file system is supported.");
        }
        int idx3 = uri.indexOf(33);
        if (idx3 == -1) {
            throw new IllegalStateException("You appear to have loaded this class from a local jar file, but I can't make sense of the URL!");
        }
        try {
            String fileName = URLDecoder.decode(uri.substring("jar:file:".length(), idx3), Charset.defaultCharset().name());
            return new File(fileName).getAbsolutePath();
        }
        catch (UnsupportedEncodingException e) {
            throw new InternalError("default charset doesn't exist. Your VM is borked.");
        }
    }

    private static void assertFilesExist(List<File> expectedFiles) {
        ArrayList<File> missingFiles = new ArrayList<File>();
        for (File file2 : expectedFiles) {
            if (file2 != null && file2.exists()) continue;
            missingFiles.add(file2);
        }
        if (!missingFiles.isEmpty()) {
            File firstMissing = (File)missingFiles.remove(0);
            String message = "The following files could not be located: " + firstMissing.getAbsolutePath();
            for (File missing : missingFiles) {
                message = message + ", " + missing.getAbsolutePath();
            }
            throw new RuntimeException(message);
        }
    }

    private static String quote(String str) {
        if (str.contains(" ")) {
            return "\"" + str + "\"";
        }
        return str;
    }
}

