/*
 * Decompiled with CFR 0.152.
 */
package checkers.util;

import checkers.basetype.BaseTypeChecker;
import checkers.quals.Dependent;
import checkers.types.AnnotatedTypeMirror;
import checkers.types.GeneralAnnotatedTypeFactory;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.util.List;
import javacutils.AnnotationUtils;
import javacutils.InternalUtils;
import javacutils.TreeUtils;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.util.Elements;

public class DependentTypes {
    private final Elements elements;
    private final GeneralAnnotatedTypeFactory atypeFactory;

    public DependentTypes(BaseTypeChecker checker, GeneralAnnotatedTypeFactory atypeFactory) {
        this.elements = checker.getProcessingEnvironment().getElementUtils();
        this.atypeFactory = atypeFactory;
    }

    private AnnotationMirror getResult(AnnotationMirror anno) {
        Name valName = AnnotationUtils.getElementValueClassName(anno, "result", false);
        return AnnotationUtils.fromName(this.elements, valName);
    }

    private AnnotationMirror getWhen(AnnotationMirror anno) {
        Name valName = AnnotationUtils.getElementValueClassName(anno, "when", false);
        return AnnotationUtils.fromName(this.elements, valName);
    }

    private AnnotationMirror findDependent(Element element) {
        List<Attribute.TypeCompound> tas = ((Symbol)element).getRawTypeAttributes();
        for (Attribute.TypeCompound ta : tas) {
            if (!ta.getAnnotationType().toString().equals(Dependent.class.getCanonicalName())) continue;
            return ta;
        }
        return null;
    }

    public void doSubsitution(Element symbol, AnnotatedTypeMirror type2, AnnotatedTypeMirror receiver) {
        AnnotationMirror dependentInfo = this.findDependent(symbol);
        if (dependentInfo == null) {
            return;
        }
        if (receiver == null) {
            return;
        }
        AnnotationMirror ifpresent = this.getWhen(dependentInfo);
        if (receiver.hasAnnotation(ifpresent)) {
            AnnotationMirror then2 = this.getResult(dependentInfo);
            type2.replaceAnnotation(then2);
        }
    }

    public void handle(Tree tree, AnnotatedTypeMirror type2) {
        AnnotatedTypeMirror receiver;
        if (!TreeUtils.isExpressionTree(tree)) {
            return;
        }
        ExpressionTree expr = (ExpressionTree)tree;
        Element symbol = null;
        if (expr instanceof IdentifierTree) {
            symbol = TreeUtils.elementFromUse(expr);
        } else if (expr instanceof MemberSelectTree) {
            symbol = TreeUtils.elementFromUse(expr);
        }
        if (symbol == null || !symbol.getKind().isField() && symbol.getKind() != ElementKind.LOCAL_VARIABLE) {
            return;
        }
        try {
            receiver = this.atypeFactory.getReceiverType(expr);
        }
        catch (Throwable t) {
            receiver = null;
        }
        if (receiver != null) {
            this.doSubsitution(symbol, type2, receiver);
        }
    }

    public void handleConstructor(NewClassTree tree, AnnotatedTypeMirror ctr, AnnotatedTypeMirror.AnnotatedExecutableType type2) {
        ExecutableElement constructorElt = InternalUtils.constructor(tree);
        for (int i = 0; i < constructorElt.getParameters().size(); ++i) {
            Element parameter = constructorElt.getParameters().get(i);
            AnnotatedTypeMirror paramType = type2.getParameterTypes().get(i);
            this.doSubsitution(parameter, paramType, ctr);
        }
    }
}

