/*
 * Decompiled with CFR 0.152.
 */
package checkers.util.test;

import checkers.util.test.TestRun;
import java.io.File;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;

public class TestInput {
    private static final boolean debug = false;
    private final JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
    private final StandardJavaFileManager fileManager = this.compiler.getStandardFileManager(null, null, null);
    private final Iterable<? extends JavaFileObject> files;
    private final Iterable<String> processors;
    private final List<String> options;
    private static final String OUTDIR = System.getProperty("tests.outputDir", "tests" + File.separator + "build" + File.separator + "testclasses");

    public TestInput(Iterable<? extends JavaFileObject> files, Iterable<String> processors, String[] options) {
        this.files = files;
        this.processors = processors;
        this.options = new LinkedList<String>();
        String classpath = System.getProperty("tests.classpath", "tests" + File.separator + "build");
        String globalclasspath = System.getProperty("java.class.path", "");
        this.options.add("-Xmaxerrs");
        this.options.add("9999");
        this.options.add("-g");
        this.options.add("-d");
        this.options.add(OUTDIR);
        this.options.add("-classpath");
        this.options.add("build" + File.pathSeparator + "junit.jar" + File.pathSeparator + classpath + File.pathSeparator + globalclasspath);
        this.options.addAll(Arrays.asList(options));
    }

    private static void ensureExistance(String path) {
        File file2 = new File(path);
        if (!file2.exists()) {
            file2.mkdirs();
        }
    }

    public TestRun run() {
        StringWriter output = new StringWriter();
        DiagnosticCollector diagnostics = new DiagnosticCollector();
        JavaCompiler.CompilationTask task = this.compiler.getTask(output, this.fileManager, diagnostics, this.options, this.processors, this.files);
        Boolean result2 = task.call();
        return new TestRun(result2, output.toString(), diagnostics.getDiagnostics());
    }

    public static TestRun compileAndCheck(Iterable<? extends JavaFileObject> files, String processor, String[] options) {
        LinkedList<String> opts = new LinkedList<String>();
        if (processor != null) {
            opts.add("-processor");
            opts.add(processor);
        }
        opts.add("-source");
        opts.add("1.8");
        opts.add("-Xlint:unchecked");
        opts.add("-XDrawDiagnostics");
        for (String option : options) {
            opts.add(option);
        }
        TestInput input = new TestInput(files, Collections.<String>emptySet(), opts.toArray(new String[opts.size()]));
        return input.run();
    }

    static {
        TestInput.ensureExistance(OUTDIR);
    }
}

