/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.base;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;

@GwtIncompatible
public final class Defaults {
    private static final Map<Class<?>, Object> DEFAULTS;

    private Defaults() {
    }

    private static <T> void put(Map<Class<?>, Object> map3, Class<T> type2, T value2) {
        map3.put(type2, value2);
    }

    @Nullable
    public static <T> T defaultValue(Class<T> type2) {
        Object t = DEFAULTS.get(Preconditions.checkNotNull(type2));
        return (T)t;
    }

    static {
        HashMap map3 = new HashMap();
        Defaults.put(map3, Boolean.TYPE, false);
        Defaults.put(map3, Character.TYPE, Character.valueOf('\u0000'));
        Defaults.put(map3, Byte.TYPE, (byte)0);
        Defaults.put(map3, Short.TYPE, (short)0);
        Defaults.put(map3, Integer.TYPE, 0);
        Defaults.put(map3, Long.TYPE, 0L);
        Defaults.put(map3, Float.TYPE, Float.valueOf(0.0f));
        Defaults.put(map3, Double.TYPE, 0.0);
        DEFAULTS = Collections.unmodifiableMap(map3);
    }
}

