/*
 * Decompiled with CFR 0.152.
 */
package dataflow.cfg.node;

import com.sun.source.tree.Tree;
import dataflow.cfg.node.Node;
import dataflow.cfg.node.NodeVisitor;
import dataflow.util.HashCodeUtils;
import java.util.Collection;
import java.util.LinkedList;
import javacutils.InternalUtils;

public class FloatingDivisionNode
extends Node {
    protected Tree tree;
    protected Node left;
    protected Node right;

    public FloatingDivisionNode(Tree tree, Node left, Node right) {
        super(InternalUtils.typeOf(tree));
        assert (tree.getKind() == Tree.Kind.DIVIDE);
        this.tree = tree;
        this.left = left;
        this.right = right;
    }

    public Node getLeftOperand() {
        return this.left;
    }

    public Node getRightOperand() {
        return this.right;
    }

    @Override
    public Tree getTree() {
        return this.tree;
    }

    @Override
    public <R, P> R accept(NodeVisitor<R, P> visitor2, P p) {
        return visitor2.visitFloatingDivision(this, p);
    }

    public String toString() {
        return "(" + this.getLeftOperand() + " / " + this.getRightOperand() + ")";
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof FloatingDivisionNode)) {
            return false;
        }
        FloatingDivisionNode other = (FloatingDivisionNode)obj;
        return this.getLeftOperand().equals(other.getLeftOperand()) && this.getRightOperand().equals(other.getRightOperand());
    }

    public int hashCode() {
        return HashCodeUtils.hash(this.getLeftOperand(), this.getRightOperand());
    }

    @Override
    public Collection<Node> getOperands() {
        LinkedList<Node> list2 = new LinkedList<Node>();
        list2.add(this.getLeftOperand());
        list2.add(this.getRightOperand());
        return list2;
    }
}

