/*
 * Decompiled with CFR 0.152.
 */
package dataflow.cfg.node;

import com.sun.source.tree.Tree;
import dataflow.cfg.node.Node;
import dataflow.cfg.node.NodeVisitor;
import dataflow.util.HashCodeUtils;
import java.util.Collection;
import java.util.Collections;
import javacutils.TypesUtils;
import javax.lang.model.type.TypeMirror;

public class NarrowingConversionNode
extends Node {
    protected Tree tree;
    protected Node operand;

    public NarrowingConversionNode(Tree tree, Node operand, TypeMirror type2) {
        super(type2);
        assert (TypesUtils.isPrimitive(type2)) : "non-primitive type in narrowing conversion";
        this.tree = tree;
        this.operand = operand;
    }

    public Node getOperand() {
        return this.operand;
    }

    @Override
    public TypeMirror getType() {
        return this.type;
    }

    @Override
    public Tree getTree() {
        return this.tree;
    }

    @Override
    public <R, P> R accept(NodeVisitor<R, P> visitor2, P p) {
        return visitor2.visitNarrowingConversion(this, p);
    }

    public String toString() {
        return "NarrowingConversion(" + this.getOperand() + ", " + this.type + ")";
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof NarrowingConversionNode)) {
            return false;
        }
        NarrowingConversionNode other = (NarrowingConversionNode)obj;
        return this.getOperand().equals(other.getOperand()) && TypesUtils.areSamePrimitiveTypes(this.getType(), other.getType());
    }

    public int hashCode() {
        return HashCodeUtils.hash((Object)this.getOperand());
    }

    @Override
    public Collection<Node> getOperands() {
        return Collections.singletonList(this.getOperand());
    }
}

