/*
 * Decompiled with CFR 0.152.
 */
package javacutils;

import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.util.Name;
import java.lang.annotation.Annotation;
import java.lang.annotation.Inherited;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javacutils.ErrorReporter;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;

public class AnnotationUtils {
    private static final Map<CharSequence, AnnotationMirror> annotationsFromNames = new HashMap<CharSequence, AnnotationMirror>();
    private static final Map<AnnotationMirror, String> annotationMirrorNames = new HashMap<AnnotationMirror, String>();
    private static final Map<Class<? extends Annotation>, String> annotationClassNames = new HashMap<Class<? extends Annotation>, String>();
    private static final Comparator<AnnotationMirror> ANNOTATION_ORDERING = new Comparator<AnnotationMirror>(){

        @Override
        public int compare(AnnotationMirror a1, AnnotationMirror a2) {
            String n1 = a1.toString();
            String n2 = a2.toString();
            return n1.compareTo(n2);
        }
    };

    private AnnotationUtils() {
        throw new AssertionError((Object)"Class AnnotationUtils cannot be instantiated.");
    }

    public static AnnotationMirror fromName(Elements elements, CharSequence name) {
        if (annotationsFromNames.containsKey(name)) {
            return annotationsFromNames.get(name);
        }
        final DeclaredType annoType = AnnotationUtils.typeFromName(elements, name);
        if (annoType == null) {
            return null;
        }
        if (annoType.asElement().getKind() != ElementKind.ANNOTATION_TYPE) {
            ErrorReporter.errorAbort(annoType + " is not an annotation");
            return null;
        }
        AnnotationMirror result2 = new AnnotationMirror(){
            String toString;
            {
                this.toString = "@" + annoType;
            }

            @Override
            public DeclaredType getAnnotationType() {
                return annoType;
            }

            @Override
            public Map<? extends ExecutableElement, ? extends AnnotationValue> getElementValues() {
                return Collections.emptyMap();
            }

            public String toString() {
                return this.toString;
            }
        };
        annotationsFromNames.put(name, result2);
        return result2;
    }

    public static AnnotationMirror fromClass(Elements elements, Class<? extends Annotation> clazz) {
        return AnnotationUtils.fromName(elements, clazz.getCanonicalName());
    }

    private static DeclaredType typeFromName(Elements elements, CharSequence name) {
        TypeElement typeElt = elements.getTypeElement(name);
        if (typeElt == null) {
            return null;
        }
        return (DeclaredType)typeElt.asType();
    }

    public static final String annotationName(AnnotationMirror annotation) {
        if (annotationMirrorNames.containsKey(annotation)) {
            return annotationMirrorNames.get(annotation);
        }
        DeclaredType annoType = annotation.getAnnotationType();
        TypeElement elm = (TypeElement)annoType.asElement();
        String name = elm.getQualifiedName().toString().intern();
        annotationMirrorNames.put(annotation, name);
        return name;
    }

    public static boolean areSame(AnnotationMirror a1, AnnotationMirror a2) {
        if (a1 != null && a2 != null) {
            if (AnnotationUtils.annotationName(a1) != AnnotationUtils.annotationName(a2)) {
                return false;
            }
            Map<? extends ExecutableElement, ? extends AnnotationValue> elval1 = AnnotationUtils.getElementValuesWithDefaults(a1);
            Map<? extends ExecutableElement, ? extends AnnotationValue> elval2 = AnnotationUtils.getElementValuesWithDefaults(a2);
            return elval1.toString().equals(elval2.toString());
        }
        return a1 == a2;
    }

    public static boolean areSameIgnoringValues(AnnotationMirror a1, AnnotationMirror a2) {
        if (a1 != null && a2 != null) {
            return AnnotationUtils.annotationName(a1) == AnnotationUtils.annotationName(a2);
        }
        return a1 == a2;
    }

    public static boolean areSameByName(AnnotationMirror am, String aname) {
        return AnnotationUtils.annotationName(am) == aname;
    }

    public static boolean areSameByClass(AnnotationMirror am, Class<? extends Annotation> anno) {
        String canonicalName;
        if (annotationClassNames.containsKey(anno)) {
            canonicalName = annotationClassNames.get(anno).intern();
        } else {
            canonicalName = anno.getCanonicalName().intern();
            annotationClassNames.put(anno, canonicalName);
        }
        return AnnotationUtils.areSameByName(am, canonicalName);
    }

    public static boolean areSame(Collection<? extends AnnotationMirror> c1, Collection<? extends AnnotationMirror> c2) {
        if (c1.size() != c2.size()) {
            return false;
        }
        if (c1.size() == 1) {
            return AnnotationUtils.areSame(c1.iterator().next(), c2.iterator().next());
        }
        Set<AnnotationMirror> s1 = AnnotationUtils.createAnnotationSet();
        Set<AnnotationMirror> s2 = AnnotationUtils.createAnnotationSet();
        s1.addAll(c1);
        s2.addAll(c2);
        Iterator<AnnotationMirror> iter1 = s1.iterator();
        Iterator<AnnotationMirror> iter2 = s2.iterator();
        while (iter1.hasNext()) {
            AnnotationMirror anno2;
            AnnotationMirror anno1 = iter1.next();
            if (AnnotationUtils.areSame(anno1, anno2 = iter2.next())) continue;
            return false;
        }
        return true;
    }

    public static boolean containsSame(Collection<? extends AnnotationMirror> c, AnnotationMirror anno) {
        for (AnnotationMirror annotationMirror : c) {
            if (!AnnotationUtils.areSame(annotationMirror, anno)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsSameByClass(Collection<? extends AnnotationMirror> c, Class<? extends Annotation> anno) {
        for (AnnotationMirror annotationMirror : c) {
            if (!AnnotationUtils.areSameByClass(annotationMirror, anno)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsSameIgnoringValues(Collection<? extends AnnotationMirror> c, AnnotationMirror anno) {
        for (AnnotationMirror annotationMirror : c) {
            if (!AnnotationUtils.areSameIgnoringValues(annotationMirror, anno)) continue;
            return true;
        }
        return false;
    }

    public static Comparator<AnnotationMirror> annotationOrdering() {
        return ANNOTATION_ORDERING;
    }

    public static <V> Map<AnnotationMirror, V> createAnnotationMap() {
        return new TreeMap(AnnotationUtils.annotationOrdering());
    }

    public static Set<AnnotationMirror> createAnnotationSet() {
        return new TreeSet<AnnotationMirror>(AnnotationUtils.annotationOrdering());
    }

    public static boolean hasInheritedMeta(AnnotationMirror anno) {
        return anno.getAnnotationType().asElement().getAnnotation(Inherited.class) != null;
    }

    public static Map<? extends ExecutableElement, ? extends AnnotationValue> getElementValuesWithDefaults(AnnotationMirror ad) {
        HashMap<? extends ExecutableElement, ? extends AnnotationValue> valMap = new HashMap<ExecutableElement, AnnotationValue>();
        if (ad.getElementValues() != null) {
            valMap.putAll(ad.getElementValues());
        }
        for (ExecutableElement meth : ElementFilter.methodsIn(ad.getAnnotationType().asElement().getEnclosedElements())) {
            AnnotationValue defaultValue = meth.getDefaultValue();
            if (defaultValue == null || valMap.containsKey(meth)) continue;
            valMap.put(meth, defaultValue);
        }
        return valMap;
    }

    public static <T> T getElementValue(AnnotationMirror anno, CharSequence name, Class<T> expectedType, boolean useDefaults) {
        Map<? extends ExecutableElement, ? extends AnnotationValue> valmap = useDefaults ? AnnotationUtils.getElementValuesWithDefaults(anno) : anno.getElementValues();
        for (ExecutableElement executableElement : valmap.keySet()) {
            if (!executableElement.getSimpleName().contentEquals(name)) continue;
            AnnotationValue val = valmap.get(executableElement);
            return expectedType.cast(val.getValue());
        }
        ErrorReporter.errorAbort("No element with name '" + name + "' in annotation " + anno);
        return null;
    }

    public static <T extends Enum<T>> T getElementValueEnum(AnnotationMirror anno, CharSequence name, Class<T> t, boolean useDefaults) {
        Symbol.VarSymbol vs = AnnotationUtils.getElementValue(anno, name, Symbol.VarSymbol.class, useDefaults);
        T value2 = Enum.valueOf(t, ((Name)vs.getSimpleName()).toString());
        return value2;
    }

    public static <T> List<T> getElementValueArray(AnnotationMirror anno, CharSequence name, Class<T> expectedType, boolean useDefaults) {
        List la = AnnotationUtils.getElementValue(anno, name, List.class, useDefaults);
        ArrayList<T> result2 = new ArrayList<T>(la.size());
        for (AnnotationValue a : la) {
            result2.add(expectedType.cast(a.getValue()));
        }
        return result2;
    }

    public static <T extends Enum<T>> List<T> getElementValueEnumArray(AnnotationMirror anno, CharSequence name, Class<T> t, boolean useDefaults) {
        List la = AnnotationUtils.getElementValue(anno, name, List.class, useDefaults);
        ArrayList<T> result2 = new ArrayList<T>(la.size());
        for (AnnotationValue a : la) {
            T value2 = Enum.valueOf(t, a.getValue().toString());
            result2.add(value2);
        }
        return result2;
    }

    public static javax.lang.model.element.Name getElementValueClassName(AnnotationMirror anno, CharSequence name, boolean useDefaults) {
        Type.ClassType ct = AnnotationUtils.getElementValue(anno, name, Type.ClassType.class, useDefaults);
        return ((Symbol)ct.asElement()).getQualifiedName();
    }

    public static Class<?> getElementValueClass(AnnotationMirror anno, CharSequence name, boolean useDefaults) {
        javax.lang.model.element.Name cn = AnnotationUtils.getElementValueClassName(anno, name, useDefaults);
        try {
            Class<?> cls = Class.forName(cn.toString());
            return cls;
        }
        catch (ClassNotFoundException e) {
            ErrorReporter.errorAbort("Could not load class '" + cn + "' for field '" + name + "' in annotation " + anno, e);
            return null;
        }
    }

    public static <T> void updateMappingToImmutableSet(Map<T, Set<AnnotationMirror>> map3, T key, Set<AnnotationMirror> newQual) {
        Set<AnnotationMirror> result2 = AnnotationUtils.createAnnotationSet();
        if (!map3.containsKey(key)) {
            result2.addAll(newQual);
        } else {
            result2.addAll((Collection<AnnotationMirror>)map3.get(key));
            result2.addAll(newQual);
        }
        map3.put(key, Collections.unmodifiableSet(result2));
    }
}

