/*
 * Decompiled with CFR 0.152.
 */
package nonapi.io.github.classgraph.classloaderhandler;

import java.util.SortedSet;
import nonapi.io.github.classgraph.classloaderhandler.ClassLoaderHandler;
import nonapi.io.github.classgraph.classloaderhandler.URLClassLoaderHandler;
import nonapi.io.github.classgraph.classpath.ClassLoaderOrder;
import nonapi.io.github.classgraph.classpath.ClasspathOrder;
import nonapi.io.github.classgraph.scanspec.ScanSpec;
import nonapi.io.github.classgraph.utils.LogNode;
import nonapi.io.github.classgraph.utils.ReflectionUtils;

class PlexusClassWorldsClassRealmClassLoaderHandler
implements ClassLoaderHandler {
    private PlexusClassWorldsClassRealmClassLoaderHandler() {
    }

    public static boolean canHandle(Class<?> classLoaderClass, LogNode log) {
        return "org.codehaus.plexus.classworlds.realm.ClassRealm".equals(classLoaderClass.getName());
    }

    private static boolean isParentFirstStrategy(ClassLoader classRealmInstance) {
        String strategyClassName;
        Object strategy = ReflectionUtils.getFieldVal(classRealmInstance, "strategy", false);
        return strategy == null || !(strategyClassName = strategy.getClass().getName()).equals("org.codehaus.plexus.classworlds.strategy.SelfFirstStrategy") && !strategyClassName.equals("org.codehaus.plexus.classworlds.strategy.OsgiBundleStrategy");
    }

    public static void findClassLoaderOrder(ClassLoader classRealm, ClassLoaderOrder classLoaderOrder, LogNode log) {
        boolean isParentFirst;
        Object foreignImports = ReflectionUtils.getFieldVal(classRealm, "foreignImports", false);
        if (foreignImports != null) {
            SortedSet foreignImportEntries = (SortedSet)foreignImports;
            for (Object entry : foreignImportEntries) {
                ClassLoader foreignImportClassLoader = (ClassLoader)ReflectionUtils.invokeMethod(entry, "getClassLoader", false);
                classLoaderOrder.delegateTo(foreignImportClassLoader, true, log);
            }
        }
        if (!(isParentFirst = PlexusClassWorldsClassRealmClassLoaderHandler.isParentFirstStrategy(classRealm))) {
            classLoaderOrder.add(classRealm, log);
        }
        ClassLoader parentClassLoader = (ClassLoader)ReflectionUtils.invokeMethod(classRealm, "getParentClassLoader", false);
        classLoaderOrder.delegateTo(parentClassLoader, true, log);
        classLoaderOrder.delegateTo(classRealm.getParent(), true, log);
        if (isParentFirst) {
            classLoaderOrder.add(classRealm, log);
        }
    }

    public static void findClasspathOrder(ClassLoader classLoader2, ClasspathOrder classpathOrder, ScanSpec scanSpec, LogNode log) {
        URLClassLoaderHandler.findClasspathOrder(classLoader2, classpathOrder, scanSpec, log);
    }
}

