/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.operator.bc;

import java.io.IOException;
import org.bouncycastle.asn1.x9.ECNamedCurveTable;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.bcpg.ECDHPublicBCPGKey;
import org.bouncycastle.bcpg.ECSecretBCPGKey;
import org.bouncycastle.crypto.AsymmetricBlockCipher;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.BufferedAsymmetricBlockCipher;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.Wrapper;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.ElGamalPrivateKeyParameters;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.operator.PGPDataDecryptor;
import org.bouncycastle.openpgp.operator.PGPPad;
import org.bouncycastle.openpgp.operator.PublicKeyDataDecryptorFactory;
import org.bouncycastle.openpgp.operator.RFC6637Utils;
import org.bouncycastle.openpgp.operator.bc.BcImplProvider;
import org.bouncycastle.openpgp.operator.bc.BcKeyFingerprintCalculator;
import org.bouncycastle.openpgp.operator.bc.BcPGPDigestCalculatorProvider;
import org.bouncycastle.openpgp.operator.bc.BcPGPKeyConverter;
import org.bouncycastle.openpgp.operator.bc.BcUtil;
import org.bouncycastle.openpgp.operator.bc.RFC6637KDFCalculator;

public class BcPublicKeyDataDecryptorFactory
implements PublicKeyDataDecryptorFactory {
    private BcPGPKeyConverter keyConverter = new BcPGPKeyConverter();
    private PGPPrivateKey privKey;

    public BcPublicKeyDataDecryptorFactory(PGPPrivateKey pGPPrivateKey) {
        this.privKey = pGPPrivateKey;
    }

    public byte[] recoverSessionData(int n, byte[][] byArray) throws PGPException {
        try {
            if (n != 18) {
                AsymmetricBlockCipher asymmetricBlockCipher = BcImplProvider.createPublicKeyCipher(n);
                AsymmetricKeyParameter asymmetricKeyParameter = this.keyConverter.getPrivateKey(this.privKey);
                BufferedAsymmetricBlockCipher bufferedAsymmetricBlockCipher = new BufferedAsymmetricBlockCipher(asymmetricBlockCipher);
                bufferedAsymmetricBlockCipher.init(false, asymmetricKeyParameter);
                if (n == 2 || n == 1) {
                    byte[] byArray2 = byArray[0];
                    bufferedAsymmetricBlockCipher.processBytes(byArray2, 2, byArray2.length - 2);
                } else {
                    BcPGPKeyConverter bcPGPKeyConverter = new BcPGPKeyConverter();
                    ElGamalPrivateKeyParameters elGamalPrivateKeyParameters = (ElGamalPrivateKeyParameters)bcPGPKeyConverter.getPrivateKey(this.privKey);
                    int n2 = (elGamalPrivateKeyParameters.getParameters().getP().bitLength() + 7) / 8;
                    byte[] byArray3 = new byte[n2];
                    byte[] byArray4 = byArray[0];
                    if (byArray4.length - 2 > n2) {
                        bufferedAsymmetricBlockCipher.processBytes(byArray4, 3, byArray4.length - 3);
                    } else {
                        System.arraycopy(byArray4, 2, byArray3, byArray3.length - (byArray4.length - 2), byArray4.length - 2);
                        bufferedAsymmetricBlockCipher.processBytes(byArray3, 0, byArray3.length);
                    }
                    byArray4 = byArray[1];
                    for (int i = 0; i != byArray3.length; ++i) {
                        byArray3[i] = 0;
                    }
                    if (byArray4.length - 2 > n2) {
                        bufferedAsymmetricBlockCipher.processBytes(byArray4, 3, byArray4.length - 3);
                    } else {
                        System.arraycopy(byArray4, 2, byArray3, byArray3.length - (byArray4.length - 2), byArray4.length - 2);
                        bufferedAsymmetricBlockCipher.processBytes(byArray3, 0, byArray3.length);
                    }
                }
                return bufferedAsymmetricBlockCipher.doFinal();
            }
            ECDHPublicBCPGKey eCDHPublicBCPGKey = (ECDHPublicBCPGKey)this.privKey.getPublicKeyPacket().getKey();
            X9ECParameters x9ECParameters = ECNamedCurveTable.getByOID(eCDHPublicBCPGKey.getCurveOID());
            byte[] byArray5 = byArray[0];
            int n3 = (((byArray5[0] & 0xFF) << 8) + (byArray5[1] & 0xFF) + 7) / 8;
            if (n3 > byArray5.length) {
                throw new PGPException("encoded length out of range");
            }
            byte[] byArray6 = new byte[n3];
            System.arraycopy(byArray5, 2, byArray6, 0, n3);
            byte[] byArray7 = new byte[byArray5[n3 + 2] & 0xFF];
            System.arraycopy(byArray5, 2 + n3 + 1, byArray7, 0, byArray7.length);
            Wrapper wrapper = BcImplProvider.createWrapper(eCDHPublicBCPGKey.getSymmetricKeyAlgorithm());
            ECPoint eCPoint = x9ECParameters.getCurve().decodePoint(byArray6).multiply(((ECSecretBCPGKey)this.privKey.getPrivateKeyDataPacket()).getX()).normalize();
            RFC6637KDFCalculator rFC6637KDFCalculator = new RFC6637KDFCalculator(new BcPGPDigestCalculatorProvider().get(eCDHPublicBCPGKey.getHashAlgorithm()), eCDHPublicBCPGKey.getSymmetricKeyAlgorithm());
            KeyParameter keyParameter = new KeyParameter(rFC6637KDFCalculator.createKey(eCPoint, RFC6637Utils.createUserKeyingMaterial(this.privKey.getPublicKeyPacket(), new BcKeyFingerprintCalculator())));
            wrapper.init(false, keyParameter);
            return PGPPad.unpadSessionData(wrapper.unwrap(byArray7, 0, byArray7.length));
        }
        catch (IOException iOException) {
            throw new PGPException("exception creating user keying material: " + iOException.getMessage(), iOException);
        }
        catch (InvalidCipherTextException invalidCipherTextException) {
            throw new PGPException("exception decrypting session info: " + invalidCipherTextException.getMessage(), invalidCipherTextException);
        }
    }

    public PGPDataDecryptor createDataDecryptor(boolean bl, int n, byte[] byArray) throws PGPException {
        BlockCipher blockCipher = BcImplProvider.createBlockCipher(n);
        return BcUtil.createDataDecryptor(bl, blockCipher, byArray);
    }
}

