/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.github.core.service;

import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import org.eclipse.egit.github.core.CommitComment;
import org.eclipse.egit.github.core.CommitStatus;
import org.eclipse.egit.github.core.IRepositoryIdProvider;
import org.eclipse.egit.github.core.RepositoryCommit;
import org.eclipse.egit.github.core.RepositoryCommitCompare;
import org.eclipse.egit.github.core.client.GitHubClient;
import org.eclipse.egit.github.core.client.GitHubRequest;
import org.eclipse.egit.github.core.client.PageIterator;
import org.eclipse.egit.github.core.client.PagedRequest;
import org.eclipse.egit.github.core.service.GitHubService;

public class CommitService
extends GitHubService {
    public CommitService() {
    }

    public CommitService(GitHubClient client2) {
        super(client2);
    }

    public List<RepositoryCommit> getCommits(IRepositoryIdProvider repository) throws IOException {
        return this.getCommits(repository, null, null);
    }

    public List<RepositoryCommit> getCommits(IRepositoryIdProvider repository, String sha, String path) throws IOException {
        return this.getAll(this.pageCommits(repository, sha, path));
    }

    public PageIterator<RepositoryCommit> pageCommits(IRepositoryIdProvider repository) {
        return this.pageCommits(repository, null, null);
    }

    public PageIterator<RepositoryCommit> pageCommits(IRepositoryIdProvider repository, int size2) {
        return this.pageCommits(repository, null, null, size2);
    }

    public PageIterator<RepositoryCommit> pageCommits(IRepositoryIdProvider repository, String sha, String path) {
        return this.pageCommits(repository, sha, path, 100);
    }

    public PageIterator<RepositoryCommit> pageCommits(IRepositoryIdProvider repository, String sha, String path, int size2) {
        String id2 = this.getId(repository);
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(id2);
        uri.append("/commits");
        PagedRequest request2 = this.createPagedRequest(1, size2);
        request2.setUri(uri);
        request2.setType(new TypeToken<List<RepositoryCommit>>(){}.getType());
        if (sha != null || path != null) {
            HashMap<String, String> params2 = new HashMap<String, String>();
            if (sha != null) {
                params2.put("sha", sha);
            }
            if (path != null) {
                params2.put("path", path);
            }
            request2.setParams(params2);
        }
        return this.createPageIterator(request2);
    }

    public RepositoryCommit getCommit(IRepositoryIdProvider repository, String sha) throws IOException {
        GitHubRequest request2 = this.getCommitRequest(repository, sha);
        request2.setType((Type)((Object)RepositoryCommit.class));
        return (RepositoryCommit)this.client.get(request2).getBody();
    }

    public InputStream getCommitDiff(IRepositoryIdProvider repository, String sha) throws IOException {
        GitHubRequest request2 = this.getCommitRequest(repository, sha);
        request2.setResponseContentType("application/vnd.github.v3.diff");
        return this.client.getStream(request2);
    }

    public InputStream getCommitPatch(IRepositoryIdProvider repository, String sha) throws IOException {
        GitHubRequest request2 = this.getCommitRequest(repository, sha);
        request2.setResponseContentType("application/vnd.github.v3.patch");
        return this.client.getStream(request2);
    }

    private GitHubRequest getCommitRequest(IRepositoryIdProvider repository, String sha) {
        String id2 = this.getId(repository);
        if (sha == null) {
            throw new IllegalArgumentException("Sha cannot be null");
        }
        if (sha.length() == 0) {
            throw new IllegalArgumentException("Sha cannot be empty");
        }
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(id2);
        uri.append("/commits");
        uri.append('/').append(sha);
        return this.createRequest().setUri(uri);
    }

    public List<CommitComment> getComments(IRepositoryIdProvider repository, String sha) throws IOException {
        return this.getAll(this.pageComments(repository, sha));
    }

    public PageIterator<CommitComment> pageComments(IRepositoryIdProvider repository, String sha) {
        return this.pageComments(repository, sha, 100);
    }

    public PageIterator<CommitComment> pageComments(IRepositoryIdProvider repository, String sha, int size2) {
        return this.pageComments(repository, sha, 1, size2);
    }

    public PageIterator<CommitComment> pageComments(IRepositoryIdProvider repository, String sha, int start, int size2) {
        String id2 = this.getId(repository);
        if (sha == null) {
            throw new IllegalArgumentException("Sha cannot be null");
        }
        if (sha.length() == 0) {
            throw new IllegalArgumentException("Sha cannot be empty");
        }
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(id2);
        uri.append("/commits");
        uri.append('/').append(sha);
        uri.append("/comments");
        PagedRequest request2 = this.createPagedRequest(start, size2);
        request2.setUri(uri);
        request2.setType(new TypeToken<List<CommitComment>>(){}.getType());
        return this.createPageIterator(request2);
    }

    public CommitComment getComment(IRepositoryIdProvider repository, long commentId) throws IOException {
        String repoId = this.getId(repository);
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(repoId);
        uri.append("/comments");
        uri.append('/').append(commentId);
        GitHubRequest request2 = this.createRequest();
        request2.setUri(uri);
        request2.setType((Type)((Object)CommitComment.class));
        return (CommitComment)this.client.get(request2).getBody();
    }

    public CommitComment addComment(IRepositoryIdProvider repository, String sha, CommitComment comment) throws IOException {
        String id2 = this.getId(repository);
        if (sha == null) {
            throw new IllegalArgumentException("Sha cannot be null");
        }
        if (sha.length() == 0) {
            throw new IllegalArgumentException("Sha cannot be empty");
        }
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(id2);
        uri.append("/commits");
        uri.append('/').append(sha);
        uri.append("/comments");
        return (CommitComment)this.client.post(uri.toString(), comment, (Type)((Object)CommitComment.class));
    }

    public CommitComment editComment(IRepositoryIdProvider repository, CommitComment comment) throws IOException {
        String id2 = this.getId(repository);
        if (comment == null) {
            throw new IllegalArgumentException("Comment cannot be null");
        }
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(id2);
        uri.append("/comments");
        uri.append('/').append(comment.getId());
        return (CommitComment)this.client.post(uri.toString(), comment, (Type)((Object)CommitComment.class));
    }

    public void deleteComment(IRepositoryIdProvider repository, long commentId) throws IOException {
        String id2 = this.getId(repository);
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(id2);
        uri.append("/comments");
        uri.append('/').append(commentId);
        this.client.delete(uri.toString());
    }

    public RepositoryCommitCompare compare(IRepositoryIdProvider repository, String base, String head) throws IOException {
        GitHubRequest request2 = this.getCompareRequest(repository, base, head);
        request2.setType((Type)((Object)RepositoryCommitCompare.class));
        return (RepositoryCommitCompare)this.client.get(request2).getBody();
    }

    public InputStream compareDiff(IRepositoryIdProvider repository, String base, String head) throws IOException {
        GitHubRequest request2 = this.getCompareRequest(repository, base, head);
        request2.setResponseContentType("application/vnd.github.v3.diff");
        return this.client.getStream(request2);
    }

    public InputStream comparePatch(IRepositoryIdProvider repository, String base, String head) throws IOException {
        GitHubRequest request2 = this.getCompareRequest(repository, base, head);
        request2.setResponseContentType("application/vnd.github.v3.patch");
        return this.client.getStream(request2);
    }

    private GitHubRequest getCompareRequest(IRepositoryIdProvider repository, String base, String head) {
        String id2 = this.getId(repository);
        if (base == null) {
            throw new IllegalArgumentException("Base cannot be null");
        }
        if (base.length() == 0) {
            throw new IllegalArgumentException("Base cannot be empty");
        }
        if (head == null) {
            throw new IllegalArgumentException("Head cannot be null");
        }
        if (head.length() == 0) {
            throw new IllegalArgumentException("Head cannot be empty");
        }
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(id2);
        uri.append("/compare");
        uri.append('/').append(base).append("...").append(head);
        return this.createRequest().setUri(uri);
    }

    public List<CommitStatus> getStatuses(IRepositoryIdProvider repository, String sha) throws IOException {
        String id2 = this.getId(repository);
        if (sha == null) {
            throw new IllegalArgumentException("SHA-1 cannot be null");
        }
        if (sha.length() == 0) {
            throw new IllegalArgumentException("SHA-1 cannot be empty");
        }
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(id2);
        uri.append("/statuses");
        uri.append('/').append(sha);
        PagedRequest request2 = this.createPagedRequest();
        request2.setType(new TypeToken<List<CommitStatus>>(){}.getType());
        request2.setUri(uri);
        return this.getAll(request2);
    }

    public CommitStatus createStatus(IRepositoryIdProvider repository, String sha, CommitStatus status) throws IOException {
        String id2 = this.getId(repository);
        if (sha == null) {
            throw new IllegalArgumentException("SHA-1 cannot be null");
        }
        if (sha.length() == 0) {
            throw new IllegalArgumentException("SHA-1 cannot be empty");
        }
        if (status == null) {
            throw new IllegalArgumentException("Status cannot be null");
        }
        HashMap<String, String> params2 = new HashMap<String, String>(3, 1.0f);
        if (status.getState() != null) {
            params2.put("state", status.getState());
        }
        if (status.getTargetUrl() != null) {
            params2.put("target_url", status.getTargetUrl());
        }
        if (status.getDescription() != null) {
            params2.put("description", status.getDescription());
        }
        if (status.getContext() != null) {
            params2.put("context", status.getContext());
        }
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(id2);
        uri.append("/statuses");
        uri.append('/').append(sha);
        return (CommitStatus)this.client.post(uri.toString(), params2, (Type)((Object)CommitStatus.class));
    }

    public List<CommitComment> getComments(IRepositoryIdProvider repository) throws IOException {
        return this.getAll(this.pageComments(repository));
    }

    public PageIterator<CommitComment> pageComments(IRepositoryIdProvider repository) {
        return this.pageComments(repository, 100);
    }

    public PageIterator<CommitComment> pageComments(IRepositoryIdProvider repository, int size2) {
        return this.pageComments(repository, 1, size2);
    }

    public PageIterator<CommitComment> pageComments(IRepositoryIdProvider repository, int start, int size2) {
        String id2 = this.getId(repository);
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(id2);
        uri.append("/comments");
        PagedRequest request2 = this.createPagedRequest(start, size2);
        request2.setUri(uri);
        request2.setType(new TypeToken<List<CommitComment>>(){}.getType());
        return this.createPageIterator(request2);
    }
}

