/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.github.core.service;

import com.google.gson.reflect.TypeToken;
import java.util.List;
import org.eclipse.egit.github.core.IRepositoryIdProvider;
import org.eclipse.egit.github.core.client.GitHubClient;
import org.eclipse.egit.github.core.client.PageIterator;
import org.eclipse.egit.github.core.client.PagedRequest;
import org.eclipse.egit.github.core.event.Event;
import org.eclipse.egit.github.core.service.GitHubService;

public class EventService
extends GitHubService {
    public EventService() {
    }

    public EventService(GitHubClient client2) {
        super(client2);
    }

    public PageIterator<Event> pagePublicEvents() {
        return this.pagePublicEvents(100);
    }

    public PageIterator<Event> pagePublicEvents(int size2) {
        return this.pagePublicEvents(1, size2);
    }

    public PageIterator<Event> pagePublicEvents(int start, int size2) {
        PagedRequest request2 = this.createPagedRequest(start, size2);
        request2.setUri("/events");
        request2.setType(new TypeToken<List<Event>>(){}.getType());
        return this.createPageIterator(request2);
    }

    public PageIterator<Event> pageEvents(IRepositoryIdProvider repository) {
        return this.pageEvents(repository, 100);
    }

    public PageIterator<Event> pageEvents(IRepositoryIdProvider repository, int size2) {
        return this.pageEvents(repository, 1, size2);
    }

    public PageIterator<Event> pageEvents(IRepositoryIdProvider repository, int start, int size2) {
        PagedRequest<Event> request2 = this.createRepoEventRequest(repository, start, size2);
        return this.createPageIterator(request2);
    }

    public PageIterator<Event> pageNetworkEvents(IRepositoryIdProvider repository) {
        return this.pageNetworkEvents(repository, 100);
    }

    public PageIterator<Event> pageNetworkEvents(IRepositoryIdProvider repository, int size2) {
        return this.pageNetworkEvents(repository, 1, size2);
    }

    public PageIterator<Event> pageNetworkEvents(IRepositoryIdProvider repository, int start, int size2) {
        PagedRequest<Event> request2 = this.createNetworkRepoEventRequest(repository, start, size2);
        return this.createPageIterator(request2);
    }

    public PageIterator<Event> pageOrgEvents(String org) {
        return this.pageOrgEvents(org, 100);
    }

    public PageIterator<Event> pageOrgEvents(String org, int size2) {
        return this.pageOrgEvents(org, 1, size2);
    }

    public PageIterator<Event> pageOrgEvents(String org, int start, int size2) {
        PagedRequest<Event> request2 = this.createOrgEventRequest(org, start, size2);
        return this.createPageIterator(request2);
    }

    public PageIterator<Event> pageUserReceivedEvents(String user2) {
        return this.pageUserReceivedEvents(user2, false);
    }

    public PageIterator<Event> pageUserReceivedEvents(String user2, boolean isPublic) {
        return this.pageUserReceivedEvents(user2, isPublic, 100);
    }

    public PageIterator<Event> pageUserReceivedEvents(String user2, boolean isPublic, int size2) {
        return this.pageUserReceivedEvents(user2, isPublic, 1, size2);
    }

    public PageIterator<Event> pageUserReceivedEvents(String user2, boolean isPublic, int start, int size2) {
        PagedRequest<Event> request2 = this.createUserReceivedEventRequest(user2, isPublic, start, size2);
        return this.createPageIterator(request2);
    }

    public PageIterator<Event> pageUserEvents(String user2) {
        return this.pageUserEvents(user2, false);
    }

    public PageIterator<Event> pageUserEvents(String user2, boolean isPublic) {
        return this.pageUserEvents(user2, isPublic, 100);
    }

    public PageIterator<Event> pageUserEvents(String user2, boolean isPublic, int size2) {
        return this.pageUserEvents(user2, isPublic, 1, size2);
    }

    public PageIterator<Event> pageUserEvents(String user2, boolean isPublic, int start, int size2) {
        PagedRequest<Event> request2 = this.createUserEventRequest(user2, isPublic, start, size2);
        return this.createPageIterator(request2);
    }

    public PageIterator<Event> pageUserOrgEvents(String user2, String org) {
        return this.pageUserOrgEvents(user2, org, 100);
    }

    public PageIterator<Event> pageUserOrgEvents(String user2, String org, int size2) {
        return this.pageUserOrgEvents(user2, org, 1, size2);
    }

    public PageIterator<Event> pageUserOrgEvents(String user2, String org, int start, int size2) {
        PagedRequest<Event> request2 = this.createUserOrgEventRequest(user2, org, start, size2);
        return this.createPageIterator(request2);
    }

    protected PagedRequest<Event> createRepoEventRequest(IRepositoryIdProvider repository, int start, int size2) {
        String repoId = this.getId(repository);
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(repoId);
        uri.append("/events");
        PagedRequest<Event> request2 = this.createPagedRequest(start, size2);
        request2.setUri(uri).setType(new TypeToken<List<Event>>(){}.getType());
        return request2;
    }

    protected PagedRequest<Event> createNetworkRepoEventRequest(IRepositoryIdProvider repository, int start, int size2) {
        String repoId = this.getId(repository);
        StringBuilder uri = new StringBuilder("/networks");
        uri.append('/').append(repoId);
        uri.append("/events");
        PagedRequest<Event> request2 = this.createPagedRequest(start, size2);
        request2.setUri(uri).setType(new TypeToken<List<Event>>(){}.getType());
        return request2;
    }

    protected PagedRequest<Event> createOrgEventRequest(String org, int start, int size2) {
        StringBuilder uri = new StringBuilder("/orgs");
        uri.append('/').append(org);
        uri.append("/events");
        PagedRequest<Event> request2 = this.createPagedRequest(start, size2);
        request2.setUri(uri).setType(new TypeToken<List<Event>>(){}.getType());
        return request2;
    }

    protected PagedRequest<Event> createUserReceivedEventRequest(String user2, boolean isPublic, int start, int size2) {
        StringBuilder uri = new StringBuilder("/users");
        uri.append('/').append(user2);
        uri.append("/received_events");
        if (isPublic) {
            uri.append("/public");
        }
        PagedRequest<Event> request2 = this.createPagedRequest(start, size2);
        request2.setUri(uri).setType(new TypeToken<List<Event>>(){}.getType());
        return request2;
    }

    protected PagedRequest<Event> createUserEventRequest(String user2, boolean isPublic, int start, int size2) {
        StringBuilder uri = new StringBuilder("/users");
        uri.append('/').append(user2);
        uri.append("/events");
        if (isPublic) {
            uri.append("/public");
        }
        PagedRequest<Event> request2 = this.createPagedRequest(start, size2);
        request2.setUri(uri).setType(new TypeToken<List<Event>>(){}.getType());
        return request2;
    }

    protected PagedRequest<Event> createUserOrgEventRequest(String user2, String org, int start, int size2) {
        StringBuilder uri = new StringBuilder("/users");
        uri.append('/').append(user2);
        uri.append("/events").append("/orgs");
        uri.append('/').append(org);
        PagedRequest<Event> request2 = this.createPagedRequest(start, size2);
        request2.setUri(uri).setType(new TypeToken<List<Event>>(){}.getType());
        return request2;
    }
}

