/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.github.core.service;

import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import org.eclipse.egit.github.core.IRepositoryIdProvider;
import org.eclipse.egit.github.core.Repository;
import org.eclipse.egit.github.core.Team;
import org.eclipse.egit.github.core.TeamMembership;
import org.eclipse.egit.github.core.User;
import org.eclipse.egit.github.core.client.GitHubClient;
import org.eclipse.egit.github.core.client.GitHubRequest;
import org.eclipse.egit.github.core.client.PagedRequest;
import org.eclipse.egit.github.core.service.GitHubService;

public class TeamService
extends GitHubService {
    public TeamService() {
    }

    public TeamService(GitHubClient client2) {
        super(client2);
    }

    public Team getTeam(int id2) throws IOException {
        StringBuilder uri = new StringBuilder("/teams");
        uri.append('/').append(id2);
        GitHubRequest request2 = this.createRequest();
        request2.setUri(uri);
        request2.setType((Type)((Object)Team.class));
        return (Team)this.client.get(request2).getBody();
    }

    public List<Team> getTeams(String organization) throws IOException {
        if (organization == null) {
            throw new IllegalArgumentException("Organization cannot be null");
        }
        if (organization.length() == 0) {
            throw new IllegalArgumentException("Organization cannot be empty");
        }
        StringBuilder uri = new StringBuilder("/orgs");
        uri.append('/').append(organization);
        uri.append("/teams");
        PagedRequest request2 = this.createPagedRequest();
        request2.setUri(uri);
        request2.setType(new TypeToken<List<Team>>(){}.getType());
        return this.getAll(request2);
    }

    public Team createTeam(String organization, Team team) throws IOException {
        return this.createTeam(organization, team, null);
    }

    public Team createTeam(String organization, Team team, List<String> repoNames) throws IOException {
        if (organization == null) {
            throw new IllegalArgumentException("Organization cannot be null");
        }
        if (organization.length() == 0) {
            throw new IllegalArgumentException("Organization cannot be null");
        }
        if (team == null) {
            throw new IllegalArgumentException("Team cannot be null");
        }
        StringBuilder uri = new StringBuilder("/orgs");
        uri.append('/').append(organization);
        uri.append("/teams");
        HashMap<String, Object> params2 = new HashMap<String, Object>();
        params2.put("name", team.getName());
        params2.put("permission", team.getPermission());
        if (repoNames != null) {
            params2.put("repo_names", repoNames);
        }
        return (Team)this.client.post(uri.toString(), params2, (Type)((Object)Team.class));
    }

    public Team editTeam(Team team) throws IOException {
        if (team == null) {
            throw new IllegalArgumentException("Team cannot be null");
        }
        StringBuilder uri = new StringBuilder("/teams");
        uri.append('/').append(team.getId());
        return (Team)this.client.post(uri.toString(), team, (Type)((Object)Team.class));
    }

    public void deleteTeam(int id2) throws IOException {
        StringBuilder uri = new StringBuilder("/teams");
        uri.append('/').append(id2);
        this.client.delete(uri.toString());
    }

    public List<User> getMembers(int id2) throws IOException {
        StringBuilder uri = new StringBuilder("/teams");
        uri.append('/').append(id2);
        uri.append("/members");
        PagedRequest request2 = this.createPagedRequest();
        request2.setUri(uri);
        request2.setType(new TypeToken<List<User>>(){}.getType());
        return this.getAll(request2);
    }

    public boolean isMember(int id2, String user2) throws IOException {
        if (user2 == null) {
            throw new IllegalArgumentException("User cannot be null");
        }
        if (user2.length() == 0) {
            throw new IllegalArgumentException("User cannot be empty");
        }
        StringBuilder uri = new StringBuilder("/teams");
        uri.append('/').append(id2);
        uri.append("/members");
        uri.append('/').append(user2);
        return this.check(uri.toString());
    }

    public void addMember(int id2, String user2) throws IOException {
        if (user2 == null) {
            throw new IllegalArgumentException("User cannot be null");
        }
        if (user2.length() == 0) {
            throw new IllegalArgumentException("User cannot be empty");
        }
        StringBuilder uri = new StringBuilder("/teams");
        uri.append('/').append(id2);
        uri.append("/members");
        uri.append('/').append(user2);
        this.client.put(uri.toString());
    }

    public void removeMember(int id2, String user2) throws IOException {
        if (user2 == null) {
            throw new IllegalArgumentException("User cannot be null");
        }
        if (user2.length() == 0) {
            throw new IllegalArgumentException("User cannot be empty");
        }
        StringBuilder uri = new StringBuilder("/teams");
        uri.append('/').append(id2);
        uri.append("/members");
        uri.append('/').append(user2);
        this.client.delete(uri.toString());
    }

    public TeamMembership getMembership(int id2, String user2) throws IOException {
        if (user2 == null) {
            throw new IllegalArgumentException("User cannot be null");
        }
        if (user2.length() == 0) {
            throw new IllegalArgumentException("User cannot be empty");
        }
        StringBuilder uri = new StringBuilder("/teams");
        uri.append('/').append(id2);
        uri.append("/memberships");
        uri.append('/').append(user2);
        GitHubRequest request2 = this.createRequest();
        request2.setUri(uri);
        request2.setType((Type)((Object)TeamMembership.class));
        return (TeamMembership)this.client.get(request2).getBody();
    }

    public TeamMembership addMembership(int id2, String user2) throws IOException {
        if (user2 == null) {
            throw new IllegalArgumentException("User cannot be null");
        }
        if (user2.length() == 0) {
            throw new IllegalArgumentException("User cannot be empty");
        }
        StringBuilder uri = new StringBuilder("/teams");
        uri.append('/').append(id2);
        uri.append("/memberships");
        uri.append('/').append(user2);
        return (TeamMembership)this.client.put(uri.toString(), null, (Type)((Object)TeamMembership.class));
    }

    public void removeMembership(int id2, String user2) throws IOException {
        if (user2 == null) {
            throw new IllegalArgumentException("User cannot be null");
        }
        if (user2.length() == 0) {
            throw new IllegalArgumentException("User cannot be empty");
        }
        StringBuilder uri = new StringBuilder("/teams");
        uri.append('/').append(id2);
        uri.append("/memberships");
        uri.append('/').append(user2);
        this.client.delete(uri.toString());
    }

    public List<Repository> getRepositories(int id2) throws IOException {
        StringBuilder uri = new StringBuilder("/teams");
        uri.append('/').append(id2);
        uri.append("/repos");
        PagedRequest request2 = this.createPagedRequest();
        request2.setUri(uri);
        request2.setType(new TypeToken<List<Repository>>(){}.getType());
        return this.getAll(request2);
    }

    public boolean isTeamRepository(int id2, IRepositoryIdProvider repository) throws IOException {
        String repoId = this.getId(repository);
        StringBuilder uri = new StringBuilder("/teams");
        uri.append('/').append(id2);
        uri.append("/repos");
        uri.append('/').append(repoId);
        return this.check(uri.toString());
    }

    public void addRepository(int id2, IRepositoryIdProvider repository) throws IOException {
        String repoId = this.getId(repository);
        StringBuilder uri = new StringBuilder("/teams");
        uri.append('/').append(id2);
        uri.append("/repos");
        uri.append('/').append(repoId);
        this.client.put(uri.toString());
    }

    public void removeRepository(int id2, IRepositoryIdProvider repository) throws IOException {
        String repoId = this.getId(repository);
        StringBuilder uri = new StringBuilder("/teams");
        uri.append('/').append(id2);
        uri.append("/repos");
        uri.append('/').append(repoId);
        this.client.delete(uri.toString());
    }

    public List<Team> getTeams(IRepositoryIdProvider repository) throws IOException {
        String id2 = this.getId(repository);
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(id2);
        uri.append("/teams");
        PagedRequest request2 = this.createPagedRequest();
        request2.setUri(uri);
        request2.setType(new TypeToken<List<Team>>(){}.getType());
        return this.getAll(request2);
    }

    public List<Team> getTeams() throws IOException {
        StringBuilder uri = new StringBuilder("/user").append("/teams");
        PagedRequest request2 = this.createPagedRequest();
        request2.setUri(uri);
        request2.setType(new TypeToken<List<Team>>(){}.getType());
        return this.getAll(request2);
    }
}

