/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.github.core.service;

import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.List;
import org.eclipse.egit.github.core.Key;
import org.eclipse.egit.github.core.User;
import org.eclipse.egit.github.core.client.GitHubClient;
import org.eclipse.egit.github.core.client.GitHubRequest;
import org.eclipse.egit.github.core.client.PageIterator;
import org.eclipse.egit.github.core.client.PagedRequest;
import org.eclipse.egit.github.core.service.GitHubService;

public class UserService
extends GitHubService {
    public UserService() {
    }

    public UserService(GitHubClient client2) {
        super(client2);
    }

    public User getUser(String login) throws IOException {
        if (login == null) {
            throw new IllegalArgumentException("Login name cannot be null");
        }
        if (login.length() == 0) {
            throw new IllegalArgumentException("Login name cannot be empty");
        }
        GitHubRequest request2 = this.createRequest();
        StringBuilder uri = new StringBuilder("/users");
        uri.append('/').append(login);
        request2.setUri(uri);
        request2.setType((Type)((Object)User.class));
        return (User)this.client.get(request2).getBody();
    }

    public User getUser() throws IOException {
        GitHubRequest request2 = this.createRequest();
        request2.setUri("/user");
        request2.setType((Type)((Object)User.class));
        return (User)this.client.get(request2).getBody();
    }

    public User editUser(User user2) throws IOException {
        if (user2 == null) {
            throw new IllegalArgumentException("User cannot be null");
        }
        return (User)this.client.post("/user", user2, (Type)((Object)User.class));
    }

    protected PagedRequest<User> createFollowersRequest(int start, int size2, String user2) {
        PagedRequest<User> request2 = this.createPagedRequest(start, size2);
        if (user2 == null) {
            request2.setUri("/user/followers");
        } else {
            StringBuilder uri = new StringBuilder("/users");
            uri.append('/').append(user2);
            uri.append("/followers");
            request2.setUri(uri);
        }
        request2.setType(new TypeToken<List<User>>(){}.getType());
        return request2;
    }

    protected PagedRequest<User> createFollowingRequest(int start, int size2, String user2) {
        PagedRequest<User> request2 = this.createPagedRequest(start, size2);
        if (user2 == null) {
            request2.setUri("/user/following");
        } else {
            StringBuilder uri = new StringBuilder("/users");
            uri.append('/').append(user2);
            uri.append("/following");
            request2.setUri(uri);
        }
        request2.setType(new TypeToken<List<User>>(){}.getType());
        return request2;
    }

    public List<User> getFollowers() throws IOException {
        return this.getAll(this.pageFollowers());
    }

    public PageIterator<User> pageFollowers() {
        return this.pageFollowers(100);
    }

    public PageIterator<User> pageFollowers(int size2) {
        return this.pageFollowers(1, size2);
    }

    public PageIterator<User> pageFollowers(int start, int size2) {
        PagedRequest<User> request2 = this.createFollowersRequest(start, size2, null);
        return this.createPageIterator(request2);
    }

    public List<User> getFollowers(String user2) throws IOException {
        return this.getAll(this.pageFollowers(user2));
    }

    public PageIterator<User> pageFollowers(String user2) {
        return this.pageFollowers(user2, 100);
    }

    public PageIterator<User> pageFollowers(String user2, int size2) {
        return this.pageFollowers(user2, 1, size2);
    }

    public PageIterator<User> pageFollowers(String user2, int start, int size2) {
        if (user2 == null) {
            throw new IllegalArgumentException("User cannot be null");
        }
        if (user2.length() == 0) {
            throw new IllegalArgumentException("User cannot be empty");
        }
        PagedRequest<User> request2 = this.createFollowersRequest(start, size2, user2);
        return this.createPageIterator(request2);
    }

    public List<User> getFollowing() throws IOException {
        return this.getAll(this.pageFollowing());
    }

    public PageIterator<User> pageFollowing() {
        return this.pageFollowing(100);
    }

    public PageIterator<User> pageFollowing(int size2) {
        return this.pageFollowing(1, size2);
    }

    public PageIterator<User> pageFollowing(int start, int size2) {
        PagedRequest<User> request2 = this.createFollowingRequest(start, size2, null);
        return this.createPageIterator(request2);
    }

    public List<User> getFollowing(String user2) throws IOException {
        return this.getAll(this.pageFollowing(user2));
    }

    public PageIterator<User> pageFollowing(String user2) {
        return this.pageFollowing(user2, 100);
    }

    public PageIterator<User> pageFollowing(String user2, int size2) {
        return this.pageFollowing(user2, 1, size2);
    }

    public PageIterator<User> pageFollowing(String user2, int start, int size2) {
        if (user2 == null) {
            throw new IllegalArgumentException("User cannot be null");
        }
        if (user2.length() == 0) {
            throw new IllegalArgumentException("User cannot be empty");
        }
        PagedRequest<User> request2 = this.createFollowingRequest(start, size2, user2);
        return this.createPageIterator(request2);
    }

    public boolean isFollowing(String user2) throws IOException {
        if (user2 == null) {
            throw new IllegalArgumentException("User cannot be null");
        }
        if (user2.length() == 0) {
            throw new IllegalArgumentException("User cannot be empty");
        }
        StringBuilder uri = new StringBuilder("/user/following");
        uri.append('/').append(user2);
        return this.check(uri.toString());
    }

    public void follow(String user2) throws IOException {
        if (user2 == null) {
            throw new IllegalArgumentException("User cannot be null");
        }
        if (user2.length() == 0) {
            throw new IllegalArgumentException("User cannot be empty");
        }
        StringBuilder uri = new StringBuilder("/user/following");
        uri.append('/').append(user2);
        this.client.put(uri.toString());
    }

    public void unfollow(String user2) throws IOException {
        if (user2 == null) {
            throw new IllegalArgumentException("User cannot be null");
        }
        if (user2.length() == 0) {
            throw new IllegalArgumentException("User cannot be empty");
        }
        StringBuilder uri = new StringBuilder("/user/following");
        uri.append('/').append(user2);
        this.client.delete(uri.toString());
    }

    public List<String> getEmails() throws IOException {
        PagedRequest request2 = this.createPagedRequest();
        request2.setUri("/user/emails");
        request2.setType(new TypeToken<List<String>>(){}.getType());
        return this.getAll(request2);
    }

    public void addEmail(String ... emails) throws IOException {
        if (emails == null) {
            throw new IllegalArgumentException("Emails cannot be null");
        }
        if (emails.length == 0) {
            throw new IllegalArgumentException("Emails cannot be empty");
        }
        this.client.post("/user/emails", emails, null);
    }

    public void removeEmail(String ... emails) throws IOException {
        if (emails == null) {
            throw new IllegalArgumentException("Emails cannot be null");
        }
        if (emails.length == 0) {
            throw new IllegalArgumentException("Emails cannot be empty");
        }
        this.client.delete("/user/emails", emails);
    }

    public List<Key> getKeys() throws IOException {
        PagedRequest request2 = this.createPagedRequest();
        request2.setUri("/user/keys");
        request2.setType(new TypeToken<List<Key>>(){}.getType());
        return this.getAll(request2);
    }

    public Key getKey(int id2) throws IOException {
        GitHubRequest request2 = this.createRequest();
        StringBuilder uri = new StringBuilder("/user/keys");
        uri.append('/').append(id2);
        request2.setUri(uri);
        request2.setType((Type)((Object)Key.class));
        return (Key)this.client.get(request2).getBody();
    }

    public Key createKey(Key key) throws IOException {
        return (Key)this.client.post("/user/keys", key, (Type)((Object)Key.class));
    }

    public Key editKey(Key key) throws IOException {
        if (key == null) {
            throw new IllegalArgumentException("Key cannot be null");
        }
        StringBuilder uri = new StringBuilder("/user/keys");
        uri.append('/').append(key.getId());
        return (Key)this.client.post(uri.toString(), key, (Type)((Object)Key.class));
    }

    public void deleteKey(int id2) throws IOException {
        StringBuilder uri = new StringBuilder("/user/keys");
        uri.append('/').append(id2);
        this.client.delete(uri.toString());
    }
}

