/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.github.core.util;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Map;

public final class MultiPartUtils {
    private MultiPartUtils() {
    }

    public static HttpURLConnection post(String url2, Map<String, Object> parts) throws IOException {
        HttpURLConnection post = (HttpURLConnection)new URL(url2).openConnection();
        post.setRequestMethod("POST");
        return MultiPartUtils.post(post, parts);
    }

    public static HttpURLConnection post(HttpURLConnection post, Map<String, Object> parts) throws IOException {
        String boundary2 = "00content0boundary00";
        post.setDoOutput(true);
        post.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + boundary2);
        BufferedOutputStream output = new BufferedOutputStream(post.getOutputStream());
        byte[] buffer = new byte[8192];
        byte[] boundarySeparator = ("--" + boundary2 + "\r\n").getBytes("UTF-8");
        byte[] newline = "\r\n".getBytes("UTF-8");
        try {
            for (Map.Entry<String, Object> part : parts.entrySet()) {
                output.write(boundarySeparator);
                StringBuilder partBuffer = new StringBuilder("Content-Disposition: ");
                partBuffer.append("form-data; name=\"");
                partBuffer.append(part.getKey());
                partBuffer.append('\"');
                output.write(partBuffer.toString().getBytes("UTF-8"));
                output.write(newline);
                output.write(newline);
                Object value2 = part.getValue();
                if (value2 instanceof InputStream) {
                    int read2;
                    InputStream input = (InputStream)value2;
                    while ((read2 = input.read(buffer)) != -1) {
                        output.write(buffer, 0, read2);
                    }
                    input.close();
                } else {
                    output.write(part.getValue().toString().getBytes("UTF-8"));
                }
                output.write(newline);
            }
            output.write(("--" + boundary2 + "--\r\n").getBytes("UTF-8"));
        }
        finally {
            output.close();
        }
        return post;
    }
}

