/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.ketch;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.internal.storage.reftree.Command;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.transport.PushCertificate;
import org.eclipse.jgit.transport.ReceiveCommand;
import org.eclipse.jgit.util.time.ProposedTimestamp;

public class Proposal {
    private final List<Command> commands;
    private PersonIdent author;
    private String message;
    private PushCertificate pushCert;
    private List<ProposedTimestamp> timestamps;
    private final List<Runnable> listeners = new CopyOnWriteArrayList<Runnable>();
    private final AtomicReference<State> state = new AtomicReference<State>(State.NEW);

    public Proposal(List<Command> cmds) {
        this.commands = Collections.unmodifiableList(new ArrayList<Command>(cmds));
    }

    public Proposal(RevWalk rw, Collection<ReceiveCommand> cmds) throws MissingObjectException, IOException {
        this.commands = Proposal.asCommandList(rw, cmds);
    }

    private static List<Command> asCommandList(RevWalk rw, Collection<ReceiveCommand> cmds) throws MissingObjectException, IOException {
        ArrayList<Command> commands = new ArrayList<Command>(cmds.size());
        for (ReceiveCommand cmd : cmds) {
            commands.add(new Command(rw, cmd));
        }
        return Collections.unmodifiableList(commands);
    }

    public Collection<Command> getCommands() {
        return this.commands;
    }

    @Nullable
    public PersonIdent getAuthor() {
        return this.author;
    }

    public Proposal setAuthor(@Nullable PersonIdent who) {
        this.author = who;
        return this;
    }

    @Nullable
    public String getMessage() {
        return this.message;
    }

    public Proposal setMessage(@Nullable String msg) {
        this.message = msg != null && !msg.isEmpty() ? msg : null;
        return this;
    }

    @Nullable
    public PushCertificate getPushCertificate() {
        return this.pushCert;
    }

    public Proposal setPushCertificate(@Nullable PushCertificate cert) {
        this.pushCert = cert;
        return this;
    }

    public List<ProposedTimestamp> getProposedTimestamps() {
        if (this.timestamps != null) {
            return this.timestamps;
        }
        return Collections.emptyList();
    }

    public Proposal addProposedTimestamp(ProposedTimestamp ts) {
        if (this.timestamps == null) {
            this.timestamps = new ArrayList<ProposedTimestamp>(4);
        }
        this.timestamps.add(ts);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(Runnable callback) {
        boolean runNow = false;
        AtomicReference<State> atomicReference = this.state;
        synchronized (atomicReference) {
            if (this.state.get().isDone()) {
                runNow = true;
            } else {
                this.listeners.add(callback);
            }
        }
        if (runNow) {
            callback.run();
        }
    }

    void success() {
        for (Command c : this.commands) {
            if (c.getResult() != ReceiveCommand.Result.NOT_ATTEMPTED) continue;
            c.setResult(ReceiveCommand.Result.OK);
        }
        this.notifyState(State.EXECUTED);
    }

    void abort() {
        Command.abort(this.commands, null);
        this.notifyState(State.ABORTED);
    }

    public State getState() {
        return this.state.get();
    }

    public boolean isDone() {
        return this.state.get().isDone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void await() throws InterruptedException {
        AtomicReference<State> atomicReference = this.state;
        synchronized (atomicReference) {
            while (!this.state.get().isDone()) {
                this.state.wait();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean await(long wait, TimeUnit unit) throws InterruptedException {
        AtomicReference<State> atomicReference = this.state;
        synchronized (atomicReference) {
            block4: {
                if (!this.state.get().isDone()) break block4;
                return true;
            }
            this.state.wait(unit.toMillis(wait));
            return this.state.get().isDone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean awaitStateChange(State notIn, long wait, TimeUnit unit) throws InterruptedException {
        AtomicReference<State> atomicReference = this.state;
        synchronized (atomicReference) {
            block4: {
                if (this.state.get() == notIn) break block4;
                return true;
            }
            this.state.wait(unit.toMillis(wait));
            return this.state.get() != notIn;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyState(State s2) {
        AtomicReference<State> atomicReference = this.state;
        synchronized (atomicReference) {
            this.state.set(s2);
            this.state.notifyAll();
        }
        if (s2.isDone()) {
            for (Runnable callback : this.listeners) {
                callback.run();
            }
            this.listeners.clear();
        }
    }

    public String toString() {
        StringBuilder s2 = new StringBuilder();
        s2.append("Ketch Proposal {\n");
        s2.append("  ").append((Object)this.state.get()).append('\n');
        if (this.author != null) {
            s2.append("  author ").append(this.author).append('\n');
        }
        if (this.message != null) {
            s2.append("  message ").append(this.message).append('\n');
        }
        for (Command c : this.commands) {
            s2.append("  ");
            Proposal.format(s2, c.getOldRef(), "CREATE");
            s2.append(' ');
            Proposal.format(s2, c.getNewRef(), "DELETE");
            s2.append(' ').append(c.getRefName());
            if (c.getResult() != ReceiveCommand.Result.NOT_ATTEMPTED) {
                s2.append(' ').append((Object)c.getResult());
            }
            s2.append('\n');
        }
        s2.append('}');
        return s2.toString();
    }

    private static void format(StringBuilder s2, @Nullable Ref r, String n) {
        if (r == null) {
            s2.append(n);
        } else if (r.isSymbolic()) {
            s2.append(r.getTarget().getName());
        } else {
            ObjectId id2 = r.getObjectId();
            if (id2 != null) {
                s2.append(id2.abbreviate(8).name());
            }
        }
    }

    public static enum State {
        NEW(false),
        QUEUED(false),
        RUNNING(false),
        EXECUTED(true),
        ABORTED(true);

        private final boolean done;

        private State(boolean done) {
            this.done = done;
        }

        public boolean isDone() {
            return this.done;
        }
    }
}

