/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lib;

import java.io.IOException;
import java.text.MessageFormat;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefDatabase;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.transport.PushCertificate;
import org.eclipse.jgit.transport.ReceiveCommand;
import org.eclipse.jgit.util.time.ProposedTimestamp;

public class BatchRefUpdate {
    protected static final Duration MAX_WAIT = Duration.ofSeconds(5L);
    private final RefDatabase refdb;
    private final List<ReceiveCommand> commands;
    private boolean allowNonFastForwards;
    private PersonIdent refLogIdent;
    private String refLogMessage;
    private boolean refLogIncludeResult;
    private boolean forceRefLog;
    private PushCertificate pushCert;
    private boolean atomic;
    private List<String> pushOptions;
    private List<ProposedTimestamp> timestamps;

    protected BatchRefUpdate(RefDatabase refdb) {
        this.refdb = refdb;
        this.commands = new ArrayList<ReceiveCommand>();
        this.atomic = refdb.performsAtomicTransactions();
    }

    public boolean isAllowNonFastForwards() {
        return this.allowNonFastForwards;
    }

    public BatchRefUpdate setAllowNonFastForwards(boolean allow) {
        this.allowNonFastForwards = allow;
        return this;
    }

    public PersonIdent getRefLogIdent() {
        return this.refLogIdent;
    }

    public BatchRefUpdate setRefLogIdent(PersonIdent pi) {
        this.refLogIdent = pi;
        return this;
    }

    @Nullable
    public String getRefLogMessage() {
        return this.refLogMessage;
    }

    public boolean isRefLogIncludingResult() {
        return this.refLogIncludeResult;
    }

    public BatchRefUpdate setRefLogMessage(String msg, boolean appendStatus) {
        if (msg == null && !appendStatus) {
            this.disableRefLog();
        } else if (msg == null && appendStatus) {
            this.refLogMessage = "";
            this.refLogIncludeResult = true;
        } else {
            this.refLogMessage = msg;
            this.refLogIncludeResult = appendStatus;
        }
        return this;
    }

    public BatchRefUpdate disableRefLog() {
        this.refLogMessage = null;
        this.refLogIncludeResult = false;
        return this;
    }

    public BatchRefUpdate setForceRefLog(boolean force) {
        this.forceRefLog = force;
        return this;
    }

    public boolean isRefLogDisabled() {
        return this.refLogMessage == null;
    }

    protected boolean isForceRefLog() {
        return this.forceRefLog;
    }

    public BatchRefUpdate setAtomic(boolean atomic) {
        this.atomic = atomic;
        return this;
    }

    public boolean isAtomic() {
        return this.atomic;
    }

    public void setPushCertificate(PushCertificate cert) {
        this.pushCert = cert;
    }

    protected PushCertificate getPushCertificate() {
        return this.pushCert;
    }

    public List<ReceiveCommand> getCommands() {
        return Collections.unmodifiableList(this.commands);
    }

    public BatchRefUpdate addCommand(ReceiveCommand cmd) {
        this.commands.add(cmd);
        return this;
    }

    public BatchRefUpdate addCommand(ReceiveCommand ... cmd) {
        return this.addCommand(Arrays.asList(cmd));
    }

    public BatchRefUpdate addCommand(Collection<ReceiveCommand> cmd) {
        this.commands.addAll(cmd);
        return this;
    }

    @Nullable
    public List<String> getPushOptions() {
        return this.pushOptions;
    }

    protected void setPushOptions(List<String> options) {
        this.pushOptions = options;
    }

    public List<ProposedTimestamp> getProposedTimestamps() {
        if (this.timestamps != null) {
            return Collections.unmodifiableList(this.timestamps);
        }
        return Collections.emptyList();
    }

    public BatchRefUpdate addProposedTimestamp(ProposedTimestamp ts) {
        if (this.timestamps == null) {
            this.timestamps = new ArrayList<ProposedTimestamp>(4);
        }
        this.timestamps.add(ts);
        return this;
    }

    public void execute(RevWalk walk, ProgressMonitor monitor, List<String> options) throws IOException {
        if (this.atomic && !this.refdb.performsAtomicTransactions()) {
            for (ReceiveCommand c : this.commands) {
                if (c.getResult() != ReceiveCommand.Result.NOT_ATTEMPTED) continue;
                c.setResult(ReceiveCommand.Result.REJECTED_OTHER_REASON, JGitText.get().atomicRefUpdatesNotSupported);
            }
            return;
        }
        if (!this.blockUntilTimestamps(MAX_WAIT)) {
            return;
        }
        if (options != null) {
            this.setPushOptions(options);
        }
        monitor.beginTask(JGitText.get().updatingReferences, this.commands.size());
        ArrayList<ReceiveCommand> commands2 = new ArrayList<ReceiveCommand>(this.commands.size());
        for (ReceiveCommand cmd : this.commands) {
            try {
                if (cmd.getResult() != ReceiveCommand.Result.NOT_ATTEMPTED) continue;
                if (BatchRefUpdate.isMissing(walk, cmd.getOldId()) || BatchRefUpdate.isMissing(walk, cmd.getNewId())) {
                    cmd.setResult(ReceiveCommand.Result.REJECTED_MISSING_OBJECT);
                    continue;
                }
                cmd.updateType(walk);
                switch (cmd.getType()) {
                    case CREATE: {
                        commands2.add(cmd);
                        break;
                    }
                    case UPDATE: 
                    case UPDATE_NONFASTFORWARD: {
                        commands2.add(cmd);
                        break;
                    }
                    case DELETE: {
                        RefUpdate rud = this.newUpdate(cmd);
                        monitor.update(1);
                        cmd.setResult(rud.delete(walk));
                    }
                }
            }
            catch (IOException err) {
                cmd.setResult(ReceiveCommand.Result.REJECTED_OTHER_REASON, MessageFormat.format(JGitText.get().lockError, err.getMessage()));
            }
        }
        if (!commands2.isEmpty()) {
            Collection takenNames = this.refdb.getRefs().stream().map(Ref::getName).collect(Collectors.toCollection(HashSet::new));
            Collection<String> takenPrefixes = BatchRefUpdate.getTakenPrefixes(takenNames);
            for (ReceiveCommand cmd : commands2) {
                try {
                    try {
                        if (cmd.getResult() == ReceiveCommand.Result.NOT_ATTEMPTED) {
                            cmd.updateType(walk);
                            RefUpdate ru = this.newUpdate(cmd);
                            block8 : switch (cmd.getType()) {
                                case DELETE: {
                                    break;
                                }
                                case UPDATE: 
                                case UPDATE_NONFASTFORWARD: {
                                    RefUpdate ruu = this.newUpdate(cmd);
                                    cmd.setResult(ruu.update(walk));
                                    break;
                                }
                                case CREATE: {
                                    for (String prefix2 : BatchRefUpdate.getPrefixes(cmd.getRefName())) {
                                        if (!takenNames.contains(prefix2)) continue;
                                        cmd.setResult(RefUpdate.Result.LOCK_FAILURE);
                                        break block8;
                                    }
                                    if (takenPrefixes.contains(cmd.getRefName())) {
                                        cmd.setResult(RefUpdate.Result.LOCK_FAILURE);
                                        break;
                                    }
                                    ru.setCheckConflicting(false);
                                    takenPrefixes.addAll(BatchRefUpdate.getPrefixes(cmd.getRefName()));
                                    takenNames.add(cmd.getRefName());
                                    cmd.setResult(ru.update(walk));
                                }
                                default: {
                                    break;
                                }
                            }
                        }
                    }
                    catch (IOException err) {
                        cmd.setResult(ReceiveCommand.Result.REJECTED_OTHER_REASON, MessageFormat.format(JGitText.get().lockError, err.getMessage()));
                        monitor.update(1);
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    monitor.update(1);
                    throw throwable;
                }
                monitor.update(1);
            }
        }
        monitor.endTask();
    }

    private static boolean isMissing(RevWalk walk, ObjectId id2) throws IOException {
        if (id2.equals(ObjectId.zeroId())) {
            return false;
        }
        try {
            walk.parseAny(id2);
            return false;
        }
        catch (MissingObjectException e) {
            return true;
        }
    }

    /*
     * Unable to fully structure code
     */
    protected boolean blockUntilTimestamps(Duration maxWait) {
        if (this.timestamps == null) {
            return true;
        }
        try {
            ProposedTimestamp.blockUntil(this.timestamps, maxWait);
            return true;
        }
        catch (InterruptedException | TimeoutException e) {
            msg = JGitText.get().timeIsUncertain;
            ** for (c : this.commands)
        }
lbl-1000:
        // 1 sources

        {
            if (c.getResult() != ReceiveCommand.Result.NOT_ATTEMPTED) continue;
            c.setResult(ReceiveCommand.Result.REJECTED_OTHER_REASON, msg);
            continue;
        }
lbl12:
        // 1 sources

        return false;
    }

    public void execute(RevWalk walk, ProgressMonitor monitor) throws IOException {
        this.execute(walk, monitor, null);
    }

    private static Collection<String> getTakenPrefixes(Collection<String> names) {
        HashSet<String> ref = new HashSet<String>();
        for (String name : names) {
            BatchRefUpdate.addPrefixesTo(name, ref);
        }
        return ref;
    }

    protected static Collection<String> getPrefixes(String name) {
        HashSet<String> ret = new HashSet<String>();
        BatchRefUpdate.addPrefixesTo(name, ret);
        return ret;
    }

    protected static void addPrefixesTo(String name, Collection<String> out) {
        int p1 = name.indexOf(47);
        while (p1 > 0) {
            out.add(name.substring(0, p1));
            p1 = name.indexOf(47, p1 + 1);
        }
    }

    protected RefUpdate newUpdate(ReceiveCommand cmd) throws IOException {
        RefUpdate ru = this.refdb.newUpdate(cmd.getRefName(), false);
        if (this.isRefLogDisabled(cmd)) {
            ru.disableRefLog();
        } else {
            ru.setRefLogIdent(this.refLogIdent);
            ru.setRefLogMessage(this.getRefLogMessage(cmd), this.isRefLogIncludingResult(cmd));
            ru.setForceRefLog(this.isForceRefLog(cmd));
        }
        ru.setPushCertificate(this.pushCert);
        switch (cmd.getType()) {
            case DELETE: {
                if (!ObjectId.zeroId().equals(cmd.getOldId())) {
                    ru.setExpectedOldObjectId(cmd.getOldId());
                }
                ru.setForceUpdate(true);
                return ru;
            }
        }
        ru.setForceUpdate(this.isAllowNonFastForwards());
        ru.setExpectedOldObjectId(cmd.getOldId());
        ru.setNewObjectId(cmd.getNewId());
        return ru;
    }

    protected boolean isRefLogDisabled(ReceiveCommand cmd) {
        return cmd.hasCustomRefLog() ? cmd.isRefLogDisabled() : this.isRefLogDisabled();
    }

    protected String getRefLogMessage(ReceiveCommand cmd) {
        return cmd.hasCustomRefLog() ? cmd.getRefLogMessage() : this.getRefLogMessage();
    }

    protected boolean isRefLogIncludingResult(ReceiveCommand cmd) {
        return cmd.hasCustomRefLog() ? cmd.isRefLogIncludingResult() : this.isRefLogIncludingResult();
    }

    protected boolean isForceRefLog(ReceiveCommand cmd) {
        Boolean isForceRefLog = cmd.isForceRefLog();
        return isForceRefLog != null ? isForceRefLog.booleanValue() : this.isForceRefLog();
    }

    public String toString() {
        StringBuilder r = new StringBuilder();
        r.append(this.getClass().getSimpleName()).append('[');
        if (this.commands.isEmpty()) {
            return r.append(']').toString();
        }
        r.append('\n');
        for (ReceiveCommand cmd : this.commands) {
            r.append("  ");
            r.append(cmd);
            r.append("  (").append((Object)cmd.getResult());
            if (cmd.getMessage() != null) {
                r.append(": ").append(cmd.getMessage());
            }
            r.append(")\n");
        }
        return r.append(']').toString();
    }
}

