/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.revwalk;

import java.io.IOException;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.revwalk.AbstractRevQueue;
import org.eclipse.jgit.revwalk.Generator;
import org.eclipse.jgit.revwalk.RevCommit;

public class DateRevQueue
extends AbstractRevQueue {
    private static final int REBUILD_INDEX_COUNT = 1000;
    private Entry head;
    private Entry free;
    private int inQueue;
    private int sinceLastIndex;
    private Entry[] index;
    private int first;
    private int last = -1;

    public DateRevQueue() {
        super(false);
    }

    DateRevQueue(boolean firstParent) {
        super(firstParent);
    }

    DateRevQueue(Generator s2) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        super(s2.firstParent);
        RevCommit c;
        while ((c = s2.next()) != null) {
            this.add(c);
        }
    }

    @Override
    public void add(RevCommit c) {
        ++this.sinceLastIndex;
        if (++this.inQueue > 1000 && this.sinceLastIndex > 1000) {
            this.buildIndex();
        }
        Entry q = this.head;
        long when = c.commitTime;
        if (this.first <= this.last && (long)this.index[this.first].commit.commitTime > when) {
            int low = this.first;
            int high = this.last;
            while (low <= high) {
                int mid = low + high >>> 1;
                int t = this.index[mid].commit.commitTime;
                if ((long)t < when) {
                    high = mid - 1;
                    continue;
                }
                if ((long)t > when) {
                    low = mid + 1;
                    continue;
                }
                low = mid - 1;
                break;
            }
            low = Math.min(low, high);
            while (low > this.first && when == (long)this.index[low].commit.commitTime) {
                --low;
            }
            q = this.index[low];
        }
        Entry n = this.newEntry(c);
        if (q == null || q == this.head && when > (long)q.commit.commitTime) {
            n.next = q;
            this.head = n;
        } else {
            Entry p = q.next;
            while (p != null && (long)p.commit.commitTime > when) {
                q = p;
                p = q.next;
            }
            n.next = q.next;
            q.next = n;
        }
    }

    @Override
    public RevCommit next() {
        Entry q = this.head;
        if (q == null) {
            return null;
        }
        if (this.index != null && q == this.index[this.first]) {
            this.index[this.first++] = null;
        }
        --this.inQueue;
        this.head = q.next;
        this.freeEntry(q);
        return q.commit;
    }

    private void buildIndex() {
        this.sinceLastIndex = 0;
        this.first = 0;
        this.index = new Entry[this.inQueue / 100 + 1];
        int qi = 0;
        int ii = 0;
        Entry q = this.head;
        while (q != null) {
            if (++qi % 100 == 0) {
                this.index[ii++] = q;
            }
            q = q.next;
        }
        this.last = ii - 1;
    }

    public RevCommit peek() {
        return this.head != null ? this.head.commit : null;
    }

    @Override
    public void clear() {
        this.head = null;
        this.free = null;
        this.index = null;
        this.inQueue = 0;
        this.sinceLastIndex = 0;
        this.last = -1;
    }

    @Override
    boolean everbodyHasFlag(int f) {
        Entry q = this.head;
        while (q != null) {
            if ((q.commit.flags & f) == 0) {
                return false;
            }
            q = q.next;
        }
        return true;
    }

    @Override
    boolean anybodyHasFlag(int f) {
        Entry q = this.head;
        while (q != null) {
            if ((q.commit.flags & f) != 0) {
                return true;
            }
            q = q.next;
        }
        return false;
    }

    @Override
    int outputType() {
        return this.outputType | 1;
    }

    public String toString() {
        StringBuilder s2 = new StringBuilder();
        Entry q = this.head;
        while (q != null) {
            DateRevQueue.describe(s2, q.commit);
            q = q.next;
        }
        return s2.toString();
    }

    private Entry newEntry(RevCommit c) {
        Entry r = this.free;
        if (r == null) {
            r = new Entry();
        } else {
            this.free = r.next;
        }
        r.commit = c;
        return r;
    }

    private void freeEntry(Entry e) {
        e.next = this.free;
        this.free = e;
    }

    static class Entry {
        Entry next;
        RevCommit commit;

        Entry() {
        }
    }
}

