/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.revwalk;

import java.io.IOException;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.revwalk.BlockRevQueue;
import org.eclipse.jgit.revwalk.Generator;
import org.eclipse.jgit.revwalk.RevCommit;

class RewriteGenerator
extends Generator {
    private static final int REWRITE = 8;
    private static final int DUPLICATE = 16;
    private final Generator source;

    RewriteGenerator(Generator s2) {
        super(s2.firstParent);
        this.source = s2;
    }

    @Override
    void shareFreeList(BlockRevQueue q) {
        this.source.shareFreeList(q);
    }

    @Override
    int outputType() {
        return this.source.outputType() & 0xFFFFFFFB;
    }

    @Override
    RevCommit next() throws MissingObjectException, IncorrectObjectTypeException, IOException {
        RevCommit c = this.source.next();
        if (c == null) {
            return null;
        }
        boolean rewrote = false;
        RevCommit[] pList = c.parents;
        int nParents = pList.length;
        int i = 0;
        while (i < nParents) {
            RevCommit oldp = pList[i];
            RevCommit newp = this.rewrite(oldp);
            if (this.firstParent) {
                c.parents = newp == null ? RevCommit.NO_PARENTS : new RevCommit[]{newp};
                return c;
            }
            if (oldp != newp) {
                pList[i] = newp;
                rewrote = true;
            }
            ++i;
        }
        if (rewrote) {
            c.parents = this.cleanup(pList);
        }
        return c;
    }

    private RevCommit rewrite(RevCommit p) {
        RevCommit[] pList;
        while ((pList = p.parents).length <= 1) {
            if ((p.flags & 4) != 0) {
                return p;
            }
            if ((p.flags & 8) == 0) {
                return p;
            }
            if (pList.length == 0) {
                return null;
            }
            p = pList[0];
        }
        return p;
    }

    private RevCommit[] cleanup(RevCommit[] oldList) {
        RevCommit p2;
        int newCnt = 0;
        int o = 0;
        while (o < oldList.length) {
            p2 = oldList[o];
            if (p2 != null) {
                if ((p2.flags & 0x10) != 0) {
                    oldList[o] = null;
                } else {
                    p2.flags |= 0x10;
                    ++newCnt;
                }
            }
            ++o;
        }
        if (newCnt == oldList.length) {
            RevCommit[] revCommitArray = oldList;
            int n = oldList.length;
            int p2 = 0;
            while (p2 < n) {
                RevCommit p3 = revCommitArray[p2];
                p3.flags &= 0xFFFFFFEF;
                ++p2;
            }
            return oldList;
        }
        RevCommit[] newList = new RevCommit[newCnt];
        newCnt = 0;
        RevCommit[] revCommitArray = oldList;
        int n = oldList.length;
        int n2 = 0;
        while (n2 < n) {
            p2 = revCommitArray[n2];
            if (p2 != null) {
                newList[newCnt++] = p2;
                p2.flags &= 0xFFFFFFEF;
            }
            ++n2;
        }
        return newList;
    }
}

