/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.revwalk.filter;

import java.io.IOException;
import java.util.Collection;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.revwalk.filter.RevFilter;

public abstract class AndRevFilter
extends RevFilter {
    public static RevFilter create(RevFilter a, RevFilter b) {
        if (a == ALL) {
            return b;
        }
        if (b == ALL) {
            return a;
        }
        return new Binary(a, b);
    }

    public static RevFilter create(RevFilter[] list2) {
        if (list2.length == 2) {
            return AndRevFilter.create(list2[0], list2[1]);
        }
        if (list2.length < 2) {
            throw new IllegalArgumentException(JGitText.get().atLeastTwoFiltersNeeded);
        }
        RevFilter[] subfilters = new RevFilter[list2.length];
        System.arraycopy(list2, 0, subfilters, 0, list2.length);
        return new List(subfilters);
    }

    public static RevFilter create(Collection<RevFilter> list2) {
        if (list2.size() < 2) {
            throw new IllegalArgumentException(JGitText.get().atLeastTwoFiltersNeeded);
        }
        RevFilter[] subfilters = new RevFilter[list2.size()];
        list2.toArray(subfilters);
        if (subfilters.length == 2) {
            return AndRevFilter.create(subfilters[0], subfilters[1]);
        }
        return new List(subfilters);
    }

    private static class Binary
    extends AndRevFilter {
        private final RevFilter a;
        private final RevFilter b;
        private final boolean requiresCommitBody;

        Binary(RevFilter one, RevFilter two) {
            this.a = one;
            this.b = two;
            this.requiresCommitBody = this.a.requiresCommitBody() || this.b.requiresCommitBody();
        }

        @Override
        public boolean include(RevWalk walker, RevCommit c) throws MissingObjectException, IncorrectObjectTypeException, IOException {
            return this.a.include(walker, c) && this.b.include(walker, c);
        }

        @Override
        public boolean requiresCommitBody() {
            return this.requiresCommitBody;
        }

        @Override
        public RevFilter clone() {
            return new Binary(this.a.clone(), this.b.clone());
        }

        @Override
        public String toString() {
            return "(" + this.a.toString() + " AND " + this.b.toString() + ")";
        }
    }

    private static class List
    extends AndRevFilter {
        private final RevFilter[] subfilters;
        private final boolean requiresCommitBody;

        List(RevFilter[] list2) {
            this.subfilters = list2;
            boolean rcb = false;
            RevFilter[] revFilterArray = this.subfilters;
            int n = this.subfilters.length;
            int n2 = 0;
            while (n2 < n) {
                RevFilter filter2 = revFilterArray[n2];
                rcb |= filter2.requiresCommitBody();
                ++n2;
            }
            this.requiresCommitBody = rcb;
        }

        @Override
        public boolean include(RevWalk walker, RevCommit c) throws MissingObjectException, IncorrectObjectTypeException, IOException {
            RevFilter[] revFilterArray = this.subfilters;
            int n = this.subfilters.length;
            int n2 = 0;
            while (n2 < n) {
                RevFilter f = revFilterArray[n2];
                if (!f.include(walker, c)) {
                    return false;
                }
                ++n2;
            }
            return true;
        }

        @Override
        public boolean requiresCommitBody() {
            return this.requiresCommitBody;
        }

        @Override
        public RevFilter clone() {
            RevFilter[] s2 = new RevFilter[this.subfilters.length];
            int i = 0;
            while (i < s2.length) {
                s2[i] = this.subfilters[i].clone();
                ++i;
            }
            return new List(s2);
        }

        @Override
        public String toString() {
            StringBuilder r = new StringBuilder();
            r.append("(");
            int i = 0;
            while (i < this.subfilters.length) {
                if (i > 0) {
                    r.append(" AND ");
                }
                r.append(this.subfilters[i].toString());
                ++i;
            }
            r.append(")");
            return r.toString();
        }
    }
}

