/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.internal.storage.pack.PackWriter;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.storage.pack.PackConfig;
import org.eclipse.jgit.transport.ObjectCountCallback;

public class BundleWriter {
    private final Repository db;
    private final ObjectReader reader;
    private final Map<String, ObjectId> include;
    private final Set<RevCommit> assume;
    private final Set<ObjectId> tagTargets;
    private PackConfig packConfig;
    private ObjectCountCallback callback;

    public BundleWriter(Repository repo) {
        this.db = repo;
        this.reader = null;
        this.include = new TreeMap<String, ObjectId>();
        this.assume = new HashSet<RevCommit>();
        this.tagTargets = new HashSet<ObjectId>();
    }

    public BundleWriter(ObjectReader or) {
        this.db = null;
        this.reader = or;
        this.include = new TreeMap<String, ObjectId>();
        this.assume = new HashSet<RevCommit>();
        this.tagTargets = new HashSet<ObjectId>();
    }

    public void setPackConfig(PackConfig pc) {
        this.packConfig = pc;
    }

    public void include(String name, AnyObjectId id2) {
        boolean validRefName;
        boolean bl = validRefName = Repository.isValidRefName(name) || "HEAD".equals(name);
        if (!validRefName) {
            throw new IllegalArgumentException(MessageFormat.format(JGitText.get().invalidRefName, name));
        }
        if (this.include.containsKey(name)) {
            throw new IllegalStateException(String.valueOf(JGitText.get().duplicateRef) + name);
        }
        this.include.put(name, id2.toObjectId());
    }

    public void include(Ref r) {
        this.include(r.getName(), r.getObjectId());
        if (r.getPeeledObjectId() != null) {
            this.tagTargets.add(r.getPeeledObjectId());
        } else if (r.getObjectId() != null && r.getName().startsWith("refs/heads/")) {
            this.tagTargets.add(r.getObjectId());
        }
    }

    public void assume(RevCommit c) {
        if (c != null) {
            this.assume.add(c);
        }
    }

    public void writeBundle(ProgressMonitor monitor, OutputStream os) throws IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (PackWriter packWriter = this.newPackWriter();){
            packWriter.setObjectCountCallback(this.callback);
            HashSet<ObjectId> inc = new HashSet<ObjectId>();
            HashSet<ObjectId> exc = new HashSet<ObjectId>();
            inc.addAll(this.include.values());
            for (RevCommit r : this.assume) {
                exc.add(r.getId());
            }
            packWriter.setIndexDisabled(true);
            packWriter.setDeltaBaseAsOffset(true);
            packWriter.setThin(!exc.isEmpty());
            packWriter.setReuseValidatingObjects(false);
            if (exc.isEmpty()) {
                packWriter.setTagTargets(this.tagTargets);
            }
            packWriter.preparePack(monitor, inc, exc);
            OutputStreamWriter w = new OutputStreamWriter(os, StandardCharsets.UTF_8);
            w.write("# v2 git bundle");
            ((Writer)w).write(10);
            char[] tmp = new char[40];
            for (RevCommit revCommit : this.assume) {
                ((Writer)w).write(45);
                revCommit.copyTo(tmp, w);
                if (revCommit.getRawBuffer() != null) {
                    ((Writer)w).write(32);
                    w.write(revCommit.getShortMessage());
                }
                ((Writer)w).write(10);
            }
            for (Map.Entry entry : this.include.entrySet()) {
                ((ObjectId)entry.getValue()).copyTo(tmp, w);
                ((Writer)w).write(32);
                w.write((String)entry.getKey());
                ((Writer)w).write(10);
            }
            ((Writer)w).write(10);
            ((Writer)w).flush();
            packWriter.writePack(monitor, monitor, os);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private PackWriter newPackWriter() {
        PackConfig pc = this.packConfig;
        if (pc == null) {
            pc = this.db != null ? new PackConfig(this.db) : new PackConfig();
        }
        return new PackWriter(pc, this.reader != null ? this.reader : this.db.newObjectReader());
    }

    public BundleWriter setObjectCountCallback(ObjectCountCallback callback) {
        this.callback = callback;
        return this;
    }
}

