/*
 * Decompiled with CFR 0.152.
 */
package org.reflections.scanners;

import com.google.common.base.Joiner;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtBehavior;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.LoaderClassPath;
import javassist.NotFoundException;
import javassist.bytecode.MethodInfo;
import javassist.expr.ConstructorCall;
import javassist.expr.ExprEditor;
import javassist.expr.FieldAccess;
import javassist.expr.MethodCall;
import javassist.expr.NewExpr;
import org.reflections.ReflectionsException;
import org.reflections.scanners.AbstractScanner;
import org.reflections.util.ClasspathHelper;

public class MemberUsageScanner
extends AbstractScanner {
    private ClassPool classPool;

    @Override
    public void scan(Object cls) {
        try {
            CtClass ctClass = this.getClassPool().get(this.getMetadataAdapter().getClassName(cls));
            for (CtConstructor ctConstructor : ctClass.getDeclaredConstructors()) {
                this.scanMember(ctConstructor);
            }
            for (CtBehavior ctBehavior : ctClass.getDeclaredMethods()) {
                this.scanMember(ctBehavior);
            }
            ctClass.detach();
        }
        catch (Exception e) {
            throw new ReflectionsException("Could not scan method usage for " + this.getMetadataAdapter().getClassName(cls), e);
        }
    }

    void scanMember(CtBehavior member) throws CannotCompileException {
        final String key = member.getDeclaringClass().getName() + "." + member.getMethodInfo().getName() + "(" + this.parameterNames(member.getMethodInfo()) + ")";
        member.instrument(new ExprEditor(){

            @Override
            public void edit(NewExpr e) throws CannotCompileException {
                try {
                    MemberUsageScanner.this.put(e.getConstructor().getDeclaringClass().getName() + ".<init>(" + MemberUsageScanner.this.parameterNames(e.getConstructor().getMethodInfo()) + ")", e.getLineNumber(), key);
                }
                catch (NotFoundException e1) {
                    throw new ReflectionsException("Could not find new instance usage in " + key, e1);
                }
            }

            @Override
            public void edit(MethodCall m3) throws CannotCompileException {
                try {
                    MemberUsageScanner.this.put(m3.getMethod().getDeclaringClass().getName() + "." + m3.getMethodName() + "(" + MemberUsageScanner.this.parameterNames(m3.getMethod().getMethodInfo()) + ")", m3.getLineNumber(), key);
                }
                catch (NotFoundException e) {
                    throw new ReflectionsException("Could not find member " + m3.getClassName() + " in " + key, e);
                }
            }

            @Override
            public void edit(ConstructorCall c) throws CannotCompileException {
                try {
                    MemberUsageScanner.this.put(c.getConstructor().getDeclaringClass().getName() + ".<init>(" + MemberUsageScanner.this.parameterNames(c.getConstructor().getMethodInfo()) + ")", c.getLineNumber(), key);
                }
                catch (NotFoundException e) {
                    throw new ReflectionsException("Could not find member " + c.getClassName() + " in " + key, e);
                }
            }

            @Override
            public void edit(FieldAccess f) throws CannotCompileException {
                try {
                    MemberUsageScanner.this.put(f.getField().getDeclaringClass().getName() + "." + f.getFieldName(), f.getLineNumber(), key);
                }
                catch (NotFoundException e) {
                    throw new ReflectionsException("Could not find member " + f.getFieldName() + " in " + key, e);
                }
            }
        });
    }

    private void put(String key, int lineNumber, String value2) {
        if (this.acceptResult(key)) {
            this.getStore().put(key, value2 + " #" + lineNumber);
        }
    }

    String parameterNames(MethodInfo info) {
        return Joiner.on(", ").join(this.getMetadataAdapter().getParameterNames(info));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClassPool getClassPool() {
        if (this.classPool == null) {
            MemberUsageScanner memberUsageScanner = this;
            synchronized (memberUsageScanner) {
                this.classPool = new ClassPool();
                ClassLoader[] classLoaders = this.getConfiguration().getClassLoaders();
                if (classLoaders == null) {
                    classLoaders = ClasspathHelper.classLoaders(new ClassLoader[0]);
                }
                for (ClassLoader classLoader2 : classLoaders) {
                    this.classPool.appendClassPath(new LoaderClassPath(classLoader2));
                }
            }
        }
        return this.classPool;
    }
}

