/*
 * Decompiled with CFR 0.152.
 */
package cfjapa.parser;

import cfjapa.parser.ast.CompilationUnit;
import cfjapa.parser.ast.body.BodyDeclaration;
import cfjapa.parser.ast.body.FieldDeclaration;
import cfjapa.parser.ast.body.MethodDeclaration;
import cfjapa.parser.ast.body.Parameter;
import cfjapa.parser.ast.body.TypeDeclaration;
import cfjapa.parser.ast.body.VariableDeclarator;
import cfjapa.parser.ast.body.VariableDeclaratorId;
import cfjapa.parser.ast.expr.Expression;
import cfjapa.parser.ast.expr.MethodCallExpr;
import cfjapa.parser.ast.expr.NameExpr;
import cfjapa.parser.ast.expr.QualifiedNameExpr;
import cfjapa.parser.ast.expr.VariableDeclarationExpr;
import cfjapa.parser.ast.stmt.BlockStmt;
import cfjapa.parser.ast.stmt.ExpressionStmt;
import cfjapa.parser.ast.stmt.Statement;
import cfjapa.parser.ast.type.ClassOrInterfaceType;
import cfjapa.parser.ast.type.PrimitiveType;
import cfjapa.parser.ast.type.ReferenceType;
import cfjapa.parser.ast.type.Type;
import cfjapa.parser.ast.type.VoidType;
import java.util.ArrayList;
import java.util.List;

public final class ASTHelper {
    public static final PrimitiveType BYTE_TYPE = new PrimitiveType(PrimitiveType.Primitive.Byte);
    public static final PrimitiveType SHORT_TYPE = new PrimitiveType(PrimitiveType.Primitive.Short);
    public static final PrimitiveType INT_TYPE = new PrimitiveType(PrimitiveType.Primitive.Int);
    public static final PrimitiveType LONG_TYPE = new PrimitiveType(PrimitiveType.Primitive.Long);
    public static final PrimitiveType FLOAT_TYPE = new PrimitiveType(PrimitiveType.Primitive.Float);
    public static final PrimitiveType DOUBLE_TYPE = new PrimitiveType(PrimitiveType.Primitive.Double);
    public static final PrimitiveType BOOLEAN_TYPE = new PrimitiveType(PrimitiveType.Primitive.Boolean);
    public static final PrimitiveType CHAR_TYPE = new PrimitiveType(PrimitiveType.Primitive.Char);
    public static final VoidType VOID_TYPE = new VoidType();

    private ASTHelper() {
    }

    public static NameExpr createNameExpr(String string) {
        String[] stringArray = string.split("\\.");
        NameExpr nameExpr = new NameExpr(stringArray[0]);
        for (int i = 1; i < stringArray.length; ++i) {
            nameExpr = new QualifiedNameExpr(nameExpr, stringArray[i]);
        }
        return nameExpr;
    }

    public static Parameter createParameter(Type type2, String string) {
        return new Parameter(type2, new VariableDeclaratorId(string));
    }

    public static FieldDeclaration createFieldDeclaration(int n, Type type2, VariableDeclarator variableDeclarator) {
        ArrayList<VariableDeclarator> arrayList = new ArrayList<VariableDeclarator>();
        arrayList.add(variableDeclarator);
        FieldDeclaration fieldDeclaration = new FieldDeclaration(n, type2, arrayList);
        return fieldDeclaration;
    }

    public static FieldDeclaration createFieldDeclaration(int n, Type type2, String string) {
        VariableDeclaratorId variableDeclaratorId = new VariableDeclaratorId(string);
        VariableDeclarator variableDeclarator = new VariableDeclarator(variableDeclaratorId);
        return ASTHelper.createFieldDeclaration(n, type2, variableDeclarator);
    }

    public static VariableDeclarationExpr createVariableDeclarationExpr(Type type2, String string) {
        ArrayList<VariableDeclarator> arrayList = new ArrayList<VariableDeclarator>();
        arrayList.add(new VariableDeclarator(new VariableDeclaratorId(string)));
        return new VariableDeclarationExpr(type2, arrayList);
    }

    public static void addParameter(MethodDeclaration methodDeclaration, Parameter parameter) {
        List<Parameter> list2 = methodDeclaration.getParameters();
        if (list2 == null) {
            list2 = new ArrayList<Parameter>();
            methodDeclaration.setParameters(list2);
        }
        list2.add(parameter);
    }

    public static void addArgument(MethodCallExpr methodCallExpr, Expression expression) {
        List<Expression> list2 = methodCallExpr.getArgs();
        if (list2 == null) {
            list2 = new ArrayList<Expression>();
            methodCallExpr.setArgs(list2);
        }
        list2.add(expression);
    }

    public static void addTypeDeclaration(CompilationUnit compilationUnit, TypeDeclaration typeDeclaration) {
        List<TypeDeclaration> list2 = compilationUnit.getTypes();
        if (list2 == null) {
            list2 = new ArrayList<TypeDeclaration>();
            compilationUnit.setTypes(list2);
        }
        list2.add(typeDeclaration);
    }

    public static ReferenceType createReferenceType(String string, int n) {
        return new ReferenceType(new ClassOrInterfaceType(string), n);
    }

    public static ReferenceType createReferenceType(PrimitiveType primitiveType, int n) {
        return new ReferenceType(primitiveType, n);
    }

    public static void addStmt(BlockStmt blockStmt, Statement statement) {
        List<Statement> list2 = blockStmt.getStmts();
        if (list2 == null) {
            list2 = new ArrayList<Statement>();
            blockStmt.setStmts(list2);
        }
        list2.add(statement);
    }

    public static void addStmt(BlockStmt blockStmt, Expression expression) {
        ASTHelper.addStmt(blockStmt, new ExpressionStmt(expression));
    }

    public static void addMember(TypeDeclaration typeDeclaration, BodyDeclaration bodyDeclaration) {
        List<BodyDeclaration> list2 = typeDeclaration.getMembers();
        if (list2 == null) {
            list2 = new ArrayList<BodyDeclaration>();
            typeDeclaration.setMembers(list2);
        }
        list2.add(bodyDeclaration);
    }
}

