/*
 * Decompiled with CFR 0.152.
 */
package cfjapa.parser.ast.type;

import cfjapa.parser.ast.expr.AnnotationExpr;
import cfjapa.parser.ast.type.Type;
import cfjapa.parser.ast.visitor.GenericVisitor;
import cfjapa.parser.ast.visitor.VoidVisitor;
import java.util.List;

public final class ReferenceType
extends Type {
    private Type type;
    private int arrayCount;
    private List<List<AnnotationExpr>> arrayAnnotations;

    public ReferenceType() {
    }

    public ReferenceType(Type type2) {
        this.type = type2;
    }

    public ReferenceType(Type type2, int n) {
        this.type = type2;
        this.arrayCount = n;
    }

    public ReferenceType(int n, int n2, int n3, int n4, Type type2, int n5, List<List<AnnotationExpr>> list2) {
        super(n, n2, n3, n4);
        this.type = type2;
        this.arrayCount = n5;
        this.arrayAnnotations = list2;
        assert (n5 == list2.size());
    }

    @Override
    public <R, A> R accept(GenericVisitor<R, A> genericVisitor, A a) {
        return genericVisitor.visit(this, a);
    }

    @Override
    public <A> void accept(VoidVisitor<A> voidVisitor, A a) {
        voidVisitor.visit(this, a);
    }

    public int getArrayCount() {
        return this.arrayCount;
    }

    public List<List<AnnotationExpr>> getArrayAnnotations() {
        return this.arrayAnnotations;
    }

    public List<AnnotationExpr> getAnnotationsAtLevel(int n) {
        if (n == -1) {
            return this.type.getAnnotations();
        }
        return this.arrayAnnotations.get(n);
    }

    public Type getType() {
        return this.type;
    }

    public void setArrayCount(int n) {
        this.arrayCount = n;
    }

    public void setArrayAnnotations(List<List<AnnotationExpr>> list2) {
        this.arrayAnnotations = list2;
    }

    public void setType(Type type2) {
        this.type = type2;
    }
}

