/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.joran.action;

import ch.qos.logback.core.joran.action.BaseModelAction;
import ch.qos.logback.core.joran.spi.ElementPath;
import ch.qos.logback.core.joran.spi.InterpretationContext;
import ch.qos.logback.core.model.IncludeModel;
import ch.qos.logback.core.model.Model;
import ch.qos.logback.core.util.OptionHelper;
import org.xml.sax.Attributes;

public class IncludeModelAction
extends BaseModelAction {
    private static final String FILE_ATTR = "file";
    private static final String URL_ATTR = "url";
    private static final String RESOURCE_ATTR = "resource";
    private static final String OPTIONAL_ATTR = "optional";

    @Override
    protected Model buildCurrentModel(InterpretationContext intercon, String name, Attributes attributes) {
        IncludeModel includeModel = new IncludeModel();
        includeModel.setOptional(attributes.getValue(OPTIONAL_ATTR));
        includeModel.setFile(attributes.getValue(FILE_ATTR));
        includeModel.setUrl(attributes.getValue(URL_ATTR));
        includeModel.setResource(attributes.getValue(RESOURCE_ATTR));
        ElementPath elementPath = intercon.getSaxEventInterpreter().getCopyOfElementPath();
        String lastPath = elementPath.peekLast();
        if (!"include".equalsIgnoreCase(lastPath)) {
            this.addWarn("expecting [include] but got [" + lastPath + "]");
        }
        elementPath.pop();
        includeModel.setElementPath(elementPath);
        return includeModel;
    }

    @Override
    protected boolean validPreconditions(InterpretationContext intercon, String name, Attributes attributes) {
        String fileAttribute = attributes.getValue(FILE_ATTR);
        String urlAttribute = attributes.getValue(URL_ATTR);
        String resourceAttribute = attributes.getValue(RESOURCE_ATTR);
        int count2 = 0;
        if (!OptionHelper.isNullOrEmpty(fileAttribute)) {
            ++count2;
        }
        if (!OptionHelper.isNullOrEmpty(urlAttribute)) {
            ++count2;
        }
        if (!OptionHelper.isNullOrEmpty(resourceAttribute)) {
            ++count2;
        }
        String attributeNames = "\"file\", \"resource\" or \"url\"";
        if (count2 == 1) {
            return true;
        }
        this.addError("One and only one of the attributes " + attributeNames + " should be set. " + this.nearLine(intercon));
        return false;
    }
}

