/*
 * Decompiled with CFR 0.152.
 */
package checkers.basetype;

import checkers.basetype.BaseTypeChecker;
import checkers.basetype.BaseTypeVisitor;
import checkers.source.Result;
import checkers.types.AnnotatedTypeFactory;
import checkers.types.AnnotatedTypeMirror;
import checkers.types.visitors.AnnotatedTypeScanner;
import com.sun.source.tree.AnnotatedTypeTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.ParameterizedTypeTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import java.util.List;
import java.util.Set;
import javacutils.AnnotationUtils;
import javacutils.Pair;
import javacutils.TreeUtils;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;

public class BaseTypeValidator
extends AnnotatedTypeScanner<Void, Tree> {
    protected boolean isValid = true;
    protected final BaseTypeChecker checker;
    protected final BaseTypeVisitor<?> visitor;
    protected final AnnotatedTypeFactory atypeFactory;

    public BaseTypeValidator(BaseTypeChecker checker, BaseTypeVisitor<?> visitor2, AnnotatedTypeFactory atypeFactory) {
        this.checker = checker;
        this.visitor = visitor2;
        this.atypeFactory = atypeFactory;
    }

    public boolean isValid(AnnotatedTypeMirror type2, Tree tree2) {
        this.isValid = true;
        this.visit(type2, tree2);
        return this.isValid;
    }

    protected void reportValidityResult(String errorType, AnnotatedTypeMirror type2, Tree p) {
        this.checker.report(Result.failure(errorType, type2.getAnnotations(), type2.toString()), p);
        this.isValid = false;
    }

    protected void reportError(AnnotatedTypeMirror type2, Tree p) {
        this.reportValidityResult("type.invalid", type2, p);
    }

    @Override
    public Void visitDeclared(AnnotatedTypeMirror.AnnotatedDeclaredType type2, Tree tree2) {
        if (this.checker.shouldSkipUses(type2.getUnderlyingType().asElement())) {
            return (Void)super.visitDeclared(type2, tree2);
        }
        AnnotatedTypeMirror.AnnotatedDeclaredType elemType = (AnnotatedTypeMirror.AnnotatedDeclaredType)this.atypeFactory.getAnnotatedType(type2.getUnderlyingType().asElement());
        if (!this.visitor.isValidUse(elemType, type2, tree2)) {
            this.reportError(type2, tree2);
        }
        Pair<ParameterizedTypeTree, AnnotatedTypeMirror.AnnotatedDeclaredType> p = this.extractParameterizedTypeTree(tree2, type2);
        ParameterizedTypeTree typeargtree = (ParameterizedTypeTree)p.first;
        type2 = (AnnotatedTypeMirror.AnnotatedDeclaredType)p.second;
        if (typeargtree != null) {
            this.visitParameterizedType(type2, typeargtree);
            List<AnnotatedTypeMirror> tatypes = type2.getTypeArguments();
            if (tatypes == null) {
                return null;
            }
            int numTypeArgs = typeargtree.getTypeArguments().size();
            if (numTypeArgs != 0) {
                assert (tatypes.size() <= numTypeArgs) : "size mismatch for type arguments: " + type2 + " and " + typeargtree;
                for (int i = 0; i < tatypes.size(); ++i) {
                    this.scan(tatypes.get(i), typeargtree.getTypeArguments().get(i));
                }
            }
            return null;
        }
        return (Void)super.visitDeclared(type2, tree2);
    }

    private Pair<ParameterizedTypeTree, AnnotatedTypeMirror.AnnotatedDeclaredType> extractParameterizedTypeTree(Tree tree2, AnnotatedTypeMirror.AnnotatedDeclaredType type2) {
        ParameterizedTypeTree typeargtree = null;
        switch (tree2.getKind()) {
            case VARIABLE: {
                Tree lt = ((VariableTree)tree2).getType();
                if (!(lt instanceof ParameterizedTypeTree)) break;
                typeargtree = (ParameterizedTypeTree)lt;
                break;
            }
            case PARAMETERIZED_TYPE: {
                typeargtree = (ParameterizedTypeTree)tree2;
                break;
            }
            case NEW_CLASS: {
                NewClassTree nct = (NewClassTree)tree2;
                ExpressionTree nctid = nct.getIdentifier();
                if (nctid.getKind() != Tree.Kind.PARAMETERIZED_TYPE) break;
                typeargtree = (ParameterizedTypeTree)((Object)nctid);
                type2 = (AnnotatedTypeMirror.AnnotatedDeclaredType)this.atypeFactory.getAnnotatedType(typeargtree);
                break;
            }
            case ANNOTATED_TYPE: {
                AnnotatedTypeTree tr = (AnnotatedTypeTree)tree2;
                ExpressionTree undtr = tr.getUnderlyingType();
                if (undtr instanceof ParameterizedTypeTree) {
                    typeargtree = (ParameterizedTypeTree)((Object)undtr);
                    break;
                }
                if (undtr instanceof IdentifierTree) break;
                Pair<ParameterizedTypeTree, AnnotatedTypeMirror.AnnotatedDeclaredType> p = this.extractParameterizedTypeTree(undtr, type2);
                typeargtree = (ParameterizedTypeTree)p.first;
                type2 = (AnnotatedTypeMirror.AnnotatedDeclaredType)p.second;
                break;
            }
            case IDENTIFIER: 
            case ARRAY_TYPE: 
            case NEW_ARRAY: 
            case MEMBER_SELECT: 
            case UNBOUNDED_WILDCARD: 
            case EXTENDS_WILDCARD: 
            case SUPER_WILDCARD: 
            case TYPE_PARAMETER: {
                break;
            }
            default: {
                System.err.printf("TypeValidator.visitDeclared unhandled tree: %s of kind %s\n", new Object[]{tree2, tree2.getKind()});
            }
        }
        return Pair.of(typeargtree, type2);
    }

    @Override
    public Void visitPrimitive(AnnotatedTypeMirror.AnnotatedPrimitiveType type2, Tree tree2) {
        if (this.checker.shouldSkipUses(type2.getUnderlyingType().toString())) {
            return (Void)super.visitPrimitive(type2, tree2);
        }
        if (!this.visitor.isValidUse(type2, tree2)) {
            this.reportError(type2, tree2);
        }
        return (Void)super.visitPrimitive(type2, tree2);
    }

    @Override
    public Void visitArray(AnnotatedTypeMirror.AnnotatedArrayType type2, Tree tree2) {
        AnnotatedTypeMirror comp = type2;
        while ((comp = ((AnnotatedTypeMirror.AnnotatedArrayType)comp).getComponentType()).getKind() == TypeKind.ARRAY) {
        }
        if (comp != null && comp.getKind() == TypeKind.DECLARED && this.checker.shouldSkipUses(((AnnotatedTypeMirror.AnnotatedDeclaredType)comp).getUnderlyingType().asElement())) {
            return (Void)super.visitArray(type2, tree2);
        }
        if (!this.visitor.isValidUse(type2, tree2)) {
            this.reportError(type2, tree2);
        }
        return (Void)super.visitArray(type2, tree2);
    }

    protected Void visitParameterizedType(AnnotatedTypeMirror.AnnotatedDeclaredType type2, ParameterizedTypeTree tree2) {
        if (TreeUtils.isDiamondTree(tree2)) {
            return null;
        }
        TypeElement element = (TypeElement)type2.getUnderlyingType().asElement();
        if (this.checker.shouldSkipUses(element)) {
            return null;
        }
        List<AnnotatedTypeMirror.AnnotatedTypeVariable> typevars = this.atypeFactory.typeVariablesFromUse(type2, element);
        this.visitor.checkTypeArguments(tree2, typevars, type2.getTypeArguments(), tree2.getTypeArguments());
        return null;
    }

    @Override
    public Void visitTypeVariable(AnnotatedTypeMirror.AnnotatedTypeVariable type2, Tree tree2) {
        if (this.visitedNodes.containsKey(type2)) {
            return (Void)this.visitedNodes.get(type2);
        }
        Set<AnnotationMirror> onVar = type2.getAnnotations();
        if (!onVar.isEmpty()) {
            Set<AnnotationMirror> seenTops = AnnotationUtils.createAnnotationSet();
            for (AnnotationMirror aOnVar : onVar) {
                AnnotationMirror top = this.atypeFactory.getQualifierHierarchy().getTopAnnotation(aOnVar);
                if (seenTops.contains(top)) {
                    this.reportError(type2, tree2);
                }
                seenTops.add(top);
            }
            if (type2.getLowerBoundField() != null) {
                AnnotatedTypeMirror lower = type2.getLowerBoundField();
                for (AnnotationMirror aOnVar : onVar) {
                    if (!lower.isAnnotatedInHierarchy(aOnVar) || this.atypeFactory.getQualifierHierarchy().isSubtype(lower.getAnnotationInHierarchy(aOnVar), aOnVar)) continue;
                    this.reportError(type2, tree2);
                }
                lower.replaceAnnotations(onVar);
            }
        }
        return (Void)super.visitTypeVariable(type2, tree2);
    }

    @Override
    public Void visitWildcard(AnnotatedTypeMirror.AnnotatedWildcardType type2, Tree tree2) {
        if (this.visitedNodes.containsKey(type2)) {
            return (Void)this.visitedNodes.get(type2);
        }
        Set<AnnotationMirror> onVar = type2.getAnnotations();
        if (!onVar.isEmpty()) {
            Set<AnnotationMirror> seenTops = AnnotationUtils.createAnnotationSet();
            for (AnnotationMirror aOnVar : onVar) {
                AnnotationMirror top = this.atypeFactory.getQualifierHierarchy().getTopAnnotation(aOnVar);
                if (seenTops.contains(top)) {
                    this.reportError(type2, tree2);
                }
                seenTops.add(top);
            }
            if (type2.getExtendsBoundField() != null) {
                AnnotatedTypeMirror upper = type2.getExtendsBoundField();
                for (AnnotationMirror aOnVar : onVar) {
                    if (!upper.isAnnotatedInHierarchy(aOnVar) || this.atypeFactory.getQualifierHierarchy().isSubtype(aOnVar, upper.getAnnotationInHierarchy(aOnVar))) continue;
                    this.reportError(type2, tree2);
                }
                upper.replaceAnnotations(onVar);
            }
            if (type2.getSuperBoundField() != null) {
                AnnotatedTypeMirror lower = type2.getSuperBoundField();
                for (AnnotationMirror aOnVar : onVar) {
                    if (!lower.isAnnotatedInHierarchy(aOnVar) || this.atypeFactory.getQualifierHierarchy().isSubtype(lower.getAnnotationInHierarchy(aOnVar), aOnVar)) continue;
                    this.reportError(type2, tree2);
                }
                lower.replaceAnnotations(onVar);
            }
        }
        return (Void)super.visitWildcard(type2, tree2);
    }
}

