/*
 * Decompiled with CFR 0.152.
 */
package checkers.flow;

import checkers.basetype.BaseTypeChecker;
import checkers.flow.CFTreeBuilder;
import checkers.types.AnnotatedTypeFactory;
import checkers.types.AnnotatedTypeMirror;
import com.sun.source.tree.ArrayAccessTree;
import com.sun.source.tree.AssertTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.EnhancedForLoopTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import dataflow.cfg.CFGBuilder;
import dataflow.cfg.ControlFlowGraph;
import dataflow.cfg.UnderlyingAST;
import dataflow.cfg.node.ArrayAccessNode;
import dataflow.cfg.node.AssignmentNode;
import dataflow.cfg.node.FieldAccessNode;
import dataflow.cfg.node.IntegerLiteralNode;
import dataflow.cfg.node.LessThanNode;
import dataflow.cfg.node.LocalVariableNode;
import dataflow.cfg.node.MethodAccessNode;
import dataflow.cfg.node.MethodInvocationNode;
import dataflow.cfg.node.Node;
import dataflow.cfg.node.NumericalAdditionNode;
import dataflow.cfg.node.VariableDeclarationNode;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import javacutils.ErrorReporter;
import javacutils.InternalUtils;
import javacutils.TreeUtils;
import javacutils.TypesUtils;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;

public class CFCFGBuilder
extends CFGBuilder {
    protected final BaseTypeChecker checker;
    protected final AnnotatedTypeFactory factory;

    public CFCFGBuilder(BaseTypeChecker checker, AnnotatedTypeFactory factory) {
        super(checker.hasOption("assumeAssertionsAreEnabled"), checker.hasOption("assumeAssertionsAreDisabled"));
        if (this.assumeAssertionsEnabled && this.assumeAssertionsDisabled) {
            ErrorReporter.errorAbort("Assertions cannot be assumed to be enabled and disabled at the same time.");
        }
        this.checker = checker;
        this.factory = factory;
    }

    @Override
    public ControlFlowGraph run(CompilationUnitTree root, ProcessingEnvironment env, UnderlyingAST underlyingAST) {
        this.declaredClasses = new LinkedList();
        CFTreeBuilder builder = new CFTreeBuilder(env);
        CFGBuilder.PhaseOneResult phase1result = new CFCFGTranslationPhaseOne().process(root, env, underlyingAST, this.exceptionalExitLabel, builder, this.factory);
        ControlFlowGraph phase2result = new CFGBuilder.CFGTranslationPhaseTwo(this).process(phase1result);
        ControlFlowGraph phase3result = CFGBuilder.CFGTranslationPhaseThree.process(phase2result);
        return phase3result;
    }

    public class CFCFGTranslationPhaseOne
    extends CFGBuilder.CFGTranslationPhaseOne {
        public CFCFGTranslationPhaseOne() {
            super(CFCFGBuilder.this);
        }

        @Override
        protected boolean assumeAssertionsEnabledFor(AssertTree tree2) {
            ExpressionTree detail = tree2.getDetail();
            if (detail != null) {
                String msg = detail.toString();
                Collection<String> warningKeys = CFCFGBuilder.this.checker.getSuppressWarningsKeys();
                for (String warningKey : warningKeys) {
                    String key = "@AssumeAssertion(" + warningKey + ")";
                    if (!msg.contains(key)) continue;
                    return true;
                }
            }
            return super.assumeAssertionsEnabledFor(tree2);
        }

        @Override
        public void handleArtificialTree(Tree tree2) {
            MethodTree enclosingMethod = TreeUtils.enclosingMethod(this.getCurrentPath());
            if (enclosingMethod != null) {
                ExecutableElement methodElement = TreeUtils.elementFromDeclaration(enclosingMethod);
                CFCFGBuilder.this.factory.setPathHack(tree2, methodElement);
            } else {
                ClassTree enclosingClass = TreeUtils.enclosingClass(this.getCurrentPath());
                if (enclosingClass != null) {
                    TypeElement classElement = TreeUtils.elementFromDeclaration(enclosingClass);
                    CFCFGBuilder.this.factory.setPathHack(tree2, classElement);
                }
            }
        }

        @Override
        public Node visitEnhancedForLoop(EnhancedForLoopTree tree2, Void p) {
            Name parentLabel = this.getLabel(this.getCurrentPath());
            CFGBuilder.Label conditionStart = new CFGBuilder.Label();
            CFGBuilder.Label loopEntry = new CFGBuilder.Label();
            CFGBuilder.Label loopExit = new CFGBuilder.Label();
            CFGBuilder.Label updateStart = parentLabel != null ? (CFGBuilder.Label)this.continueLabels.get(parentLabel) : new CFGBuilder.Label();
            CFGBuilder.Label oldBreakTargetL = this.breakTargetL;
            this.breakTargetL = loopExit;
            CFGBuilder.Label oldContinueTargetL = this.continueTargetL;
            this.continueTargetL = updateStart;
            TypeElement iterableElement = this.elements.getTypeElement("java.lang.Iterable");
            TypeMirror iterableType = this.types.erasure(iterableElement.asType());
            VariableTree variable = tree2.getVariable();
            VariableElement variableElement = TreeUtils.elementFromDeclaration(variable);
            ExpressionTree expression = tree2.getExpression();
            StatementTree statement = tree2.getStatement();
            TypeMirror exprType = InternalUtils.typeOf(expression);
            if (this.types.isSubtype(exprType, iterableType)) {
                exprType = TypesUtils.upperBound(exprType);
                assert (exprType instanceof DeclaredType) : "an Iterable must be a DeclaredType";
                DeclaredType declaredExprType = (DeclaredType)exprType;
                declaredExprType.getTypeArguments();
                MemberSelectTree iteratorSelect = this.treeBuilder.buildIteratorMethodAccess(expression);
                this.handleArtificialTree(iteratorSelect);
                MethodInvocationTree iteratorCall = this.treeBuilder.buildMethodInvocation(iteratorSelect);
                this.handleArtificialTree(iteratorCall);
                boolean oldShouldCache = CFCFGBuilder.this.factory.shouldCache;
                CFCFGBuilder.this.factory.shouldCache = false;
                AnnotatedTypeMirror annotatedIteratorType = CFCFGBuilder.this.factory.getAnnotatedType(iteratorCall);
                CFCFGBuilder.this.factory.shouldCache = oldShouldCache;
                Tree annotatedIteratorTypeTree = ((CFTreeBuilder)this.treeBuilder).buildAnnotatedType(annotatedIteratorType);
                this.handleArtificialTree(annotatedIteratorTypeTree);
                VariableTree iteratorVariable = this.treeBuilder.buildVariableDecl(annotatedIteratorTypeTree, this.uniqueName("iter"), variableElement.getEnclosingElement(), (ExpressionTree)iteratorCall);
                this.handleArtificialTree(iteratorVariable);
                VariableDeclarationNode iteratorVariableDecl = new VariableDeclarationNode(iteratorVariable);
                iteratorVariableDecl.setInSource(false);
                this.extendWithNode(iteratorVariableDecl);
                Node expressionNode = (Node)this.scan(expression, p);
                MethodAccessNode iteratorAccessNode = new MethodAccessNode(iteratorSelect, expressionNode);
                iteratorAccessNode.setInSource(false);
                this.extendWithNode(iteratorAccessNode);
                MethodInvocationNode iteratorCallNode = new MethodInvocationNode(iteratorCall, iteratorAccessNode, Collections.<Node>emptyList(), this.getCurrentPath());
                iteratorCallNode.setInSource(false);
                this.extendWithNode(iteratorCallNode);
                this.translateAssignment((Tree)iteratorVariable, (Node)new LocalVariableNode(iteratorVariable), iteratorCallNode);
                this.addLabelForNextNode(conditionStart);
                IdentifierTree iteratorUse1 = this.treeBuilder.buildVariableUse(iteratorVariable);
                this.handleArtificialTree(iteratorUse1);
                LocalVariableNode iteratorReceiverNode = new LocalVariableNode(iteratorUse1);
                iteratorReceiverNode.setInSource(false);
                this.extendWithNode(iteratorReceiverNode);
                MemberSelectTree hasNextSelect = this.treeBuilder.buildHasNextMethodAccess(iteratorUse1);
                this.handleArtificialTree(hasNextSelect);
                MethodAccessNode hasNextAccessNode = new MethodAccessNode(hasNextSelect, iteratorReceiverNode);
                hasNextAccessNode.setInSource(false);
                this.extendWithNode(hasNextAccessNode);
                MethodInvocationTree hasNextCall = this.treeBuilder.buildMethodInvocation(hasNextSelect);
                this.handleArtificialTree(hasNextCall);
                MethodInvocationNode hasNextCallNode = new MethodInvocationNode(hasNextCall, hasNextAccessNode, Collections.<Node>emptyList(), this.getCurrentPath());
                hasNextCallNode.setInSource(false);
                this.extendWithNode(hasNextCallNode);
                this.extendWithExtendedNode(new CFGBuilder.ConditionalJump(loopEntry, loopExit));
                this.addLabelForNextNode(loopEntry);
                this.extendWithNode(new VariableDeclarationNode(variable));
                IdentifierTree iteratorUse2 = this.treeBuilder.buildVariableUse(iteratorVariable);
                this.handleArtificialTree(iteratorUse2);
                LocalVariableNode iteratorReceiverNode2 = new LocalVariableNode(iteratorUse2);
                iteratorReceiverNode2.setInSource(false);
                this.extendWithNode(iteratorReceiverNode2);
                MemberSelectTree nextSelect = this.treeBuilder.buildNextMethodAccess(iteratorUse2);
                this.handleArtificialTree(nextSelect);
                MethodAccessNode nextAccessNode = new MethodAccessNode(nextSelect, iteratorReceiverNode2);
                nextAccessNode.setInSource(false);
                this.extendWithNode(nextAccessNode);
                MethodInvocationTree nextCall = this.treeBuilder.buildMethodInvocation(nextSelect);
                this.handleArtificialTree(nextCall);
                MethodInvocationNode nextCallNode = new MethodInvocationNode(nextCall, nextAccessNode, Collections.<Node>emptyList(), this.getCurrentPath());
                nextCallNode.setInSource(false);
                this.extendWithNode(nextCallNode);
                this.translateAssignment((Tree)variable, (Node)new LocalVariableNode(variable), nextCall);
                if (statement != null) {
                    this.scan(statement, p);
                }
                this.addLabelForNextNode(updateStart);
                this.extendWithExtendedNode(new CFGBuilder.UnconditionalJump(conditionStart));
            } else {
                boolean oldShouldCache = CFCFGBuilder.this.factory.shouldCache;
                CFCFGBuilder.this.factory.shouldCache = false;
                AnnotatedTypeMirror annotatedArrayType = CFCFGBuilder.this.factory.getAnnotatedType(expression);
                CFCFGBuilder.this.factory.shouldCache = oldShouldCache;
                assert (annotatedArrayType instanceof AnnotatedTypeMirror.AnnotatedArrayType) : "ArrayType must be represented by AnnotatedArrayType";
                Tree annotatedArrayTypeTree = ((CFTreeBuilder)this.treeBuilder).buildAnnotatedType(annotatedArrayType);
                this.handleArtificialTree(annotatedArrayTypeTree);
                VariableTree arrayVariable = this.treeBuilder.buildVariableDecl(annotatedArrayTypeTree, this.uniqueName("array"), variableElement.getEnclosingElement(), expression);
                this.handleArtificialTree(arrayVariable);
                VariableDeclarationNode arrayVariableNode = new VariableDeclarationNode(arrayVariable);
                arrayVariableNode.setInSource(false);
                this.extendWithNode(arrayVariableNode);
                Node expressionNode = (Node)this.scan(expression, p);
                this.translateAssignment((Tree)arrayVariable, (Node)new LocalVariableNode(arrayVariable), expressionNode);
                PrimitiveType intType = this.types.getPrimitiveType(TypeKind.INT);
                LiteralTree zero = this.treeBuilder.buildLiteral(new Integer(0));
                this.handleArtificialTree(zero);
                VariableTree indexVariable = this.treeBuilder.buildVariableDecl(intType, this.uniqueName("index"), variableElement.getEnclosingElement(), (ExpressionTree)zero);
                this.handleArtificialTree(indexVariable);
                VariableDeclarationNode indexVariableNode = new VariableDeclarationNode(indexVariable);
                indexVariableNode.setInSource(false);
                this.extendWithNode(indexVariableNode);
                IntegerLiteralNode zeroNode = this.extendWithNode(new IntegerLiteralNode(zero));
                this.translateAssignment((Tree)indexVariable, (Node)new LocalVariableNode(indexVariable), zeroNode);
                this.addLabelForNextNode(conditionStart);
                IdentifierTree indexUse1 = this.treeBuilder.buildVariableUse(indexVariable);
                this.handleArtificialTree(indexUse1);
                LocalVariableNode indexNode1 = new LocalVariableNode(indexUse1);
                indexNode1.setInSource(false);
                this.extendWithNode(indexNode1);
                IdentifierTree arrayUse1 = this.treeBuilder.buildVariableUse(arrayVariable);
                this.handleArtificialTree(arrayUse1);
                LocalVariableNode arrayNode1 = this.extendWithNode(new LocalVariableNode(arrayUse1));
                MemberSelectTree lengthSelect = this.treeBuilder.buildArrayLengthAccess(arrayUse1);
                this.handleArtificialTree(lengthSelect);
                FieldAccessNode lengthAccessNode = new FieldAccessNode(lengthSelect, (Node)arrayNode1);
                lengthAccessNode.setInSource(false);
                this.extendWithNode(lengthAccessNode);
                BinaryTree lessThan = this.treeBuilder.buildLessThan(indexUse1, lengthSelect);
                this.handleArtificialTree(lessThan);
                LessThanNode lessThanNode = new LessThanNode(lessThan, indexNode1, lengthAccessNode);
                lessThanNode.setInSource(false);
                this.extendWithNode(lessThanNode);
                this.extendWithExtendedNode(new CFGBuilder.ConditionalJump(loopEntry, loopExit));
                this.addLabelForNextNode(loopEntry);
                this.extendWithNode(new VariableDeclarationNode(variable));
                IdentifierTree arrayUse2 = this.treeBuilder.buildVariableUse(arrayVariable);
                this.handleArtificialTree(arrayUse2);
                LocalVariableNode arrayNode2 = new LocalVariableNode(arrayUse2);
                arrayNode2.setInSource(false);
                this.extendWithNode(arrayNode2);
                IdentifierTree indexUse2 = this.treeBuilder.buildVariableUse(indexVariable);
                this.handleArtificialTree(indexUse2);
                LocalVariableNode indexNode2 = new LocalVariableNode(indexUse2);
                indexNode2.setInSource(false);
                this.extendWithNode(indexNode2);
                ArrayAccessTree arrayAccess = this.treeBuilder.buildArrayAccess(arrayUse2, indexUse2);
                this.handleArtificialTree(arrayAccess);
                ArrayAccessNode arrayAccessNode = new ArrayAccessNode(arrayAccess, arrayNode2, indexNode2);
                arrayAccessNode.setInSource(false);
                this.extendWithNode(arrayAccessNode);
                this.translateAssignment((Tree)variable, (Node)new LocalVariableNode(variable), arrayAccessNode);
                if (statement != null) {
                    this.scan(statement, p);
                }
                this.addLabelForNextNode(updateStart);
                IdentifierTree indexUse3 = this.treeBuilder.buildVariableUse(indexVariable);
                this.handleArtificialTree(indexUse3);
                LocalVariableNode indexNode3 = new LocalVariableNode(indexUse3);
                indexNode3.setInSource(false);
                this.extendWithNode(indexNode3);
                LiteralTree oneTree = this.treeBuilder.buildLiteral(1);
                this.handleArtificialTree(oneTree);
                IntegerLiteralNode one = new IntegerLiteralNode(oneTree);
                one.setInSource(false);
                this.extendWithNode(one);
                BinaryTree addOneTree = this.treeBuilder.buildBinary(intType, Tree.Kind.PLUS, indexUse3, oneTree);
                this.handleArtificialTree(addOneTree);
                NumericalAdditionNode addOneNode = new NumericalAdditionNode(addOneTree, indexNode3, one);
                addOneNode.setInSource(false);
                this.extendWithNode(addOneNode);
                AssignmentTree assignTree = this.treeBuilder.buildAssignment(indexUse3, (ExpressionTree)addOneTree);
                this.handleArtificialTree(assignTree);
                AssignmentNode assignNode = new AssignmentNode(assignTree, indexNode3, addOneNode);
                assignNode.setInSource(false);
                this.extendWithNode(assignNode);
                this.extendWithExtendedNode(new CFGBuilder.UnconditionalJump(conditionStart));
            }
            this.addLabelForNextNode(loopExit);
            this.breakTargetL = oldBreakTargetL;
            this.continueTargetL = oldContinueTargetL;
            return null;
        }
    }
}

