/*
 * Decompiled with CFR 0.152.
 */
package checkers.i18n;

import checkers.basetype.BaseAnnotatedTypeFactory;
import checkers.basetype.BaseTypeChecker;
import checkers.i18n.quals.Localized;
import checkers.types.AnnotatedTypeFactory;
import checkers.types.AnnotatedTypeMirror;
import checkers.types.TreeAnnotator;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.Tree;
import javacutils.AnnotationUtils;
import javax.lang.model.element.AnnotationMirror;

public class I18nAnnotatedTypeFactory
extends BaseAnnotatedTypeFactory {
    public I18nAnnotatedTypeFactory(BaseTypeChecker checker) {
        super(checker);
        this.postInit();
    }

    @Override
    public TreeAnnotator createTreeAnnotator() {
        return new I18nTreeAnnotator(this);
    }

    private class I18nTreeAnnotator
    extends TreeAnnotator {
        private final AnnotationMirror LOCALIZED;

        public I18nTreeAnnotator(AnnotatedTypeFactory atypeFactory) {
            super(atypeFactory);
            this.LOCALIZED = AnnotationUtils.fromClass(I18nAnnotatedTypeFactory.this.elements, Localized.class);
        }

        @Override
        public Void visitBinary(BinaryTree tree2, AnnotatedTypeMirror type2) {
            type2.removeAnnotation(this.LOCALIZED);
            return null;
        }

        @Override
        public Void visitCompoundAssignment(CompoundAssignmentTree node, AnnotatedTypeMirror type2) {
            type2.removeAnnotation(this.LOCALIZED);
            return null;
        }

        @Override
        public Void visitLiteral(LiteralTree tree2, AnnotatedTypeMirror type2) {
            if (!type2.isAnnotatedInHierarchy(this.LOCALIZED) && tree2.getKind() == Tree.Kind.STRING_LITERAL && tree2.getValue().equals("")) {
                type2.addAnnotation(this.LOCALIZED);
            }
            return super.visitLiteral(tree2, type2);
        }
    }
}

