/*
 * Decompiled with CFR 0.152.
 */
package checkers.interning;

import checkers.basetype.BaseAnnotatedTypeFactory;
import checkers.basetype.BaseTypeChecker;
import checkers.interning.quals.Interned;
import checkers.quals.Unqualified;
import checkers.types.AnnotatedTypeMirror;
import checkers.types.TreeAnnotator;
import checkers.types.TypeAnnotator;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.Tree;
import javacutils.AnnotationUtils;
import javacutils.ElementUtils;
import javacutils.TreeUtils;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;

public class InterningAnnotatedTypeFactory
extends BaseAnnotatedTypeFactory {
    final AnnotationMirror INTERNED;
    final AnnotationMirror UNQUALIFIED;

    public InterningAnnotatedTypeFactory(BaseTypeChecker checker) {
        super(checker);
        this.INTERNED = AnnotationUtils.fromClass(this.elements, Interned.class);
        this.UNQUALIFIED = AnnotationUtils.fromClass(this.elements, Unqualified.class);
        this.addAliasedAnnotation(com.sun.istack.Interned.class, this.INTERNED);
        this.postInit();
        this.typeAnnotator.addTypeName(Void.class, this.INTERNED);
    }

    @Override
    protected TreeAnnotator createTreeAnnotator() {
        return new InterningTreeAnnotator(this);
    }

    @Override
    protected TypeAnnotator createTypeAnnotator() {
        return new InterningTypeAnnotator(this);
    }

    @Override
    public void annotateImplicit(Element element, AnnotatedTypeMirror type2) {
        if (!type2.isAnnotatedInHierarchy(this.INTERNED) && ElementUtils.isCompileTimeConstant(element)) {
            type2.addAnnotation(this.INTERNED);
        }
        super.annotateImplicit(element, type2);
    }

    @Override
    public AnnotatedTypeMirror.AnnotatedPrimitiveType getUnboxedType(AnnotatedTypeMirror.AnnotatedDeclaredType type2) {
        AnnotatedTypeMirror.AnnotatedPrimitiveType primitive = super.getUnboxedType(type2);
        primitive.replaceAnnotation(this.INTERNED);
        return primitive;
    }

    private class InterningTypeAnnotator
    extends TypeAnnotator {
        InterningTypeAnnotator(InterningAnnotatedTypeFactory atypeFactory) {
            super(atypeFactory);
        }

        @Override
        public Void visitDeclared(AnnotatedTypeMirror.AnnotatedDeclaredType t, Element elem) {
            Element elt = t.getUnderlyingType().asElement();
            assert (elt != null);
            if (elt.getKind() == ElementKind.ENUM) {
                t.replaceAnnotation(InterningAnnotatedTypeFactory.this.INTERNED);
            }
            return (Void)super.visitDeclared(t, elem);
        }
    }

    private class InterningTreeAnnotator
    extends TreeAnnotator {
        InterningTreeAnnotator(InterningAnnotatedTypeFactory atypeFactory) {
            super(atypeFactory);
        }

        @Override
        public Void visitBinary(BinaryTree node, AnnotatedTypeMirror type2) {
            if (TreeUtils.isCompileTimeString(node)) {
                type2.replaceAnnotation(InterningAnnotatedTypeFactory.this.INTERNED);
            } else if (TreeUtils.isStringConcatenation(node)) {
                type2.replaceAnnotation(InterningAnnotatedTypeFactory.this.UNQUALIFIED);
            } else if (type2.getKind().isPrimitive() || node.getKind() == Tree.Kind.EQUAL_TO || node.getKind() == Tree.Kind.NOT_EQUAL_TO) {
                type2.replaceAnnotation(InterningAnnotatedTypeFactory.this.INTERNED);
            } else {
                type2.replaceAnnotation(InterningAnnotatedTypeFactory.this.UNQUALIFIED);
            }
            return super.visitBinary(node, type2);
        }

        @Override
        public Void visitCompoundAssignment(CompoundAssignmentTree node, AnnotatedTypeMirror type2) {
            type2.replaceAnnotation(InterningAnnotatedTypeFactory.this.UNQUALIFIED);
            return super.visitCompoundAssignment(node, type2);
        }
    }
}

