/*
 * Decompiled with CFR 0.152.
 */
package checkers.interning;

import checkers.basetype.BaseTypeChecker;
import checkers.basetype.BaseTypeVisitor;
import checkers.interning.InterningAnnotatedTypeFactory;
import checkers.interning.quals.Interned;
import checkers.interning.quals.UsesObjectEquals;
import checkers.source.Result;
import checkers.types.AnnotatedTypeMirror;
import checkers.util.Heuristics;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ConditionalExpressionTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.IfTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ParenthesizedTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.Scope;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Type;
import java.util.Comparator;
import java.util.List;
import javacutils.AnnotationUtils;
import javacutils.InternalUtils;
import javacutils.TreeUtils;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.ElementFilter;

public final class InterningVisitor
extends BaseTypeVisitor<InterningAnnotatedTypeFactory> {
    private final AnnotationMirror INTERNED;
    private final DeclaredType typeToCheck;

    public InterningVisitor(BaseTypeChecker checker) {
        super(checker);
        this.INTERNED = AnnotationUtils.fromClass(this.elements, Interned.class);
        this.typeToCheck = this.typeToCheck();
    }

    private boolean shouldCheckFor(ExpressionTree tree2) {
        if (this.typeToCheck == null) {
            return true;
        }
        TypeMirror type2 = InternalUtils.typeOf(tree2);
        return this.types.isSubtype(type2, this.typeToCheck) || this.types.isSubtype(this.typeToCheck, type2);
    }

    @Override
    public Void visitBinary(BinaryTree node, Void p) {
        if (node.getKind() != Tree.Kind.EQUAL_TO && node.getKind() != Tree.Kind.NOT_EQUAL_TO) {
            return (Void)super.visitBinary(node, p);
        }
        ExpressionTree leftOp = node.getLeftOperand();
        ExpressionTree rightOp = node.getRightOperand();
        if (leftOp.getKind() == Tree.Kind.NULL_LITERAL || rightOp.getKind() == Tree.Kind.NULL_LITERAL) {
            return (Void)super.visitBinary(node, p);
        }
        AnnotatedTypeMirror left = ((InterningAnnotatedTypeFactory)this.atypeFactory).getAnnotatedType(leftOp);
        AnnotatedTypeMirror right = ((InterningAnnotatedTypeFactory)this.atypeFactory).getAnnotatedType(rightOp);
        if (left.getKind().isPrimitive() || right.getKind().isPrimitive()) {
            return (Void)super.visitBinary(node, p);
        }
        if (!this.shouldCheckFor(leftOp) || !this.shouldCheckFor(rightOp)) {
            return (Void)super.visitBinary(node, p);
        }
        if (this.suppressInsideComparison(node)) {
            return (Void)super.visitBinary(node, p);
        }
        if (this.suppressEarlyEquals(node)) {
            return (Void)super.visitBinary(node, p);
        }
        if (this.suppressEarlyCompareTo(node)) {
            return (Void)super.visitBinary(node, p);
        }
        if (this.suppressClassAnnotation(left, right)) {
            return (Void)super.visitBinary(node, p);
        }
        Element leftElt = null;
        Element rightElt = null;
        if (left instanceof AnnotatedTypeMirror.AnnotatedDeclaredType) {
            leftElt = ((DeclaredType)left.getUnderlyingType()).asElement();
        }
        if (right instanceof AnnotatedTypeMirror.AnnotatedDeclaredType) {
            rightElt = ((DeclaredType)right.getUnderlyingType()).asElement();
        }
        if (!(left.hasEffectiveAnnotation(this.INTERNED) || leftElt != null && leftElt.getAnnotation(UsesObjectEquals.class) != null)) {
            this.checker.report(Result.failure("not.interned", left), leftOp);
        }
        if (!(right.hasEffectiveAnnotation(this.INTERNED) || rightElt != null && rightElt.getAnnotation(UsesObjectEquals.class) != null)) {
            this.checker.report(Result.failure("not.interned", right), rightOp);
        }
        return (Void)super.visitBinary(node, p);
    }

    @Override
    public Void visitMethodInvocation(MethodInvocationTree node, Void p) {
        if (this.isInvocationOfEquals(node)) {
            AnnotatedTypeMirror recv = ((InterningAnnotatedTypeFactory)this.atypeFactory).getReceiverType(node);
            AnnotatedTypeMirror comp = ((InterningAnnotatedTypeFactory)this.atypeFactory).getAnnotatedType(node.getArguments().get(0));
            if (this.checker.getLintOption("dotequals", true) && recv.hasEffectiveAnnotation(this.INTERNED) && comp.hasEffectiveAnnotation(this.INTERNED)) {
                this.checker.report(Result.warning("unnecessary.equals", new Object[0]), node);
            }
        }
        return super.visitMethodInvocation(node, p);
    }

    @Override
    public Void visitClass(ClassTree node, Void p) {
        TypeElement elt = TreeUtils.elementFromDeclaration(node);
        UsesObjectEquals annotation = elt.getAnnotation(UsesObjectEquals.class);
        Tree superClass = node.getExtendsClause();
        Element elmt = null;
        if (superClass != null && (superClass instanceof IdentifierTree || superClass instanceof MemberSelectTree)) {
            elmt = TreeUtils.elementFromUse((ExpressionTree)superClass);
        }
        if (annotation != null) {
            if (this.overridesEquals(node)) {
                this.checker.report(Result.failure("overrides.equals", new Object[0]), node);
            }
            if (superClass != null && (elmt == null || elmt.getAnnotation(UsesObjectEquals.class) == null)) {
                this.checker.report(Result.failure("superclass.unmarked", new Object[0]), node);
            }
        } else if (superClass != null && elmt != null && elmt.getAnnotation(UsesObjectEquals.class) != null) {
            this.checker.report(Result.failure("superclass.marked", new Object[0]), node);
        }
        return super.visitClass(node, p);
    }

    private boolean overridesEquals(ClassTree node) {
        List<? extends Tree> members2 = node.getMembers();
        for (Tree tree2 : members2) {
            MethodTree mTree;
            ExecutableElement enclosing;
            if (!(tree2 instanceof MethodTree) || !this.overrides(enclosing = TreeUtils.elementFromDeclaration(mTree = (MethodTree)tree2), Object.class, "equals")) continue;
            return true;
        }
        return false;
    }

    private boolean isInvocationOfEquals(MethodInvocationTree node) {
        ExecutableElement method = TreeUtils.elementFromUse(node);
        return method.getParameters().size() == 1 && method.getReturnType().getKind() == TypeKind.BOOLEAN && method.getSimpleName().contentEquals("equals");
    }

    private boolean isInvocationOfCompareTo(MethodInvocationTree node) {
        ExecutableElement method = TreeUtils.elementFromUse(node);
        return method.getParameters().size() == 1 && method.getReturnType().getKind() == TypeKind.INT && method.getSimpleName().contentEquals("compareTo");
    }

    private boolean suppressInsideComparison(BinaryTree node) {
        if (node.getKind() != Tree.Kind.EQUAL_TO) {
            return false;
        }
        ExpressionTree left = node.getLeftOperand();
        ExpressionTree right = node.getRightOperand();
        if (left.getKind() != Tree.Kind.IDENTIFIER || right.getKind() != Tree.Kind.IDENTIFIER) {
            return false;
        }
        if (!Heuristics.matchParents(this.getCurrentPath(), Tree.Kind.IF, Tree.Kind.METHOD)) {
            return false;
        }
        ExecutableElement enclosing = TreeUtils.elementFromDeclaration(this.visitorState.getMethodTree());
        assert (enclosing != null);
        Element lhs = TreeUtils.elementFromUse((IdentifierTree)left);
        Element rhs = TreeUtils.elementFromUse((IdentifierTree)right);
        Heuristics.Matcher matcher = new Heuristics.Matcher(){

            @Override
            public Boolean visitIf(IfTree tree2, Void p) {
                return (Boolean)this.visit(tree2.getThenStatement(), p);
            }

            @Override
            public Boolean visitBlock(BlockTree tree2, Void p) {
                if (tree2.getStatements().size() > 0) {
                    return (Boolean)this.visit(tree2.getStatements().get(0), p);
                }
                return false;
            }

            @Override
            public Boolean visitReturn(ReturnTree tree2, Void p) {
                ExpressionTree expr = tree2.getExpression();
                return expr != null && expr.getKind() == Tree.Kind.INT_LITERAL && ((LiteralTree)expr).getValue().equals(0);
            }
        };
        if (this.overrides(enclosing, Comparator.class, "compare")) {
            boolean returnsZero = Heuristics.Matchers.withIn(Heuristics.Matchers.ofKind(Tree.Kind.IF, matcher)).match(this.getCurrentPath());
            if (!returnsZero) {
                return false;
            }
            assert (enclosing.getParameters().size() == 2);
            Element p1 = enclosing.getParameters().get(0);
            Element p2 = enclosing.getParameters().get(1);
            return p1.equals(lhs) && p2.equals(rhs) || p2.equals(lhs) && p1.equals(rhs);
        }
        if (this.overrides(enclosing, Object.class, "equals")) {
            assert (enclosing.getParameters().size() == 1);
            Element param = enclosing.getParameters().get(0);
            Element thisElt = this.getThis(this.trees.getScope(this.getCurrentPath()));
            assert (thisElt != null);
            return thisElt.equals(lhs) && param.equals(rhs) || param.equals(lhs) && thisElt.equals(rhs);
        }
        if (this.overrides(enclosing, Comparable.class, "compareTo")) {
            boolean returnsZero = Heuristics.Matchers.withIn(Heuristics.Matchers.ofKind(Tree.Kind.IF, matcher)).match(this.getCurrentPath());
            if (!returnsZero) {
                return false;
            }
            assert (enclosing.getParameters().size() == 1);
            Element param = enclosing.getParameters().get(0);
            Element thisElt = this.getThis(this.trees.getScope(this.getCurrentPath()));
            assert (thisElt != null);
            return thisElt.equals(lhs) && param.equals(rhs) || param.equals(lhs) && thisElt.equals(rhs);
        }
        return false;
    }

    private static ExpressionTree unparenthesize(ExpressionTree t) {
        while (t.getKind() == Tree.Kind.PARENTHESIZED) {
            t = ((ParenthesizedTree)t).getExpression();
        }
        return t;
    }

    private static boolean sameTree(ExpressionTree a, ExpressionTree b) {
        return InterningVisitor.unparenthesize(a).toString().equals(InterningVisitor.unparenthesize(b).toString());
    }

    private boolean suppressEarlyEquals(final BinaryTree node) {
        if (node.getKind() != Tree.Kind.EQUAL_TO) {
            return false;
        }
        final ExpressionTree left = InterningVisitor.unparenthesize(node.getLeftOperand());
        final ExpressionTree right = InterningVisitor.unparenthesize(node.getRightOperand());
        Heuristics.Matcher matcher = new Heuristics.Matcher(){

            private boolean isNeqNull(ExpressionTree e, ExpressionTree e1, ExpressionTree e2) {
                if ((e = InterningVisitor.unparenthesize(e)).getKind() != Tree.Kind.NOT_EQUAL_TO) {
                    return false;
                }
                ExpressionTree neqLeft = ((BinaryTree)e).getLeftOperand();
                ExpressionTree neqRight = ((BinaryTree)e).getRightOperand();
                return (InterningVisitor.sameTree(neqLeft, e1) || InterningVisitor.sameTree(neqLeft, e2)) && neqRight.getKind() == Tree.Kind.NULL_LITERAL || (InterningVisitor.sameTree(neqRight, e1) || InterningVisitor.sameTree(neqRight, e2)) && neqLeft.getKind() == Tree.Kind.NULL_LITERAL;
            }

            @Override
            public Boolean visitBinary(BinaryTree tree2, Void p) {
                ExpressionTree leftTree = tree2.getLeftOperand();
                ExpressionTree rightTree = tree2.getRightOperand();
                if (tree2.getKind() == Tree.Kind.CONDITIONAL_OR) {
                    if (InterningVisitor.sameTree(leftTree, node)) {
                        return (Boolean)this.visit(rightTree, p);
                    }
                    return false;
                }
                if (tree2.getKind() == Tree.Kind.CONDITIONAL_AND) {
                    if (this.isNeqNull(leftTree, left, right)) {
                        return (Boolean)this.visit(rightTree, p);
                    }
                    return false;
                }
                return false;
            }

            @Override
            public Boolean visitConditionalExpression(ConditionalExpressionTree tree2, Void p) {
                ExpressionTree cond = tree2.getCondition();
                ExpressionTree trueExp = tree2.getTrueExpression();
                ExpressionTree falseExp = tree2.getFalseExpression();
                if (this.isNeqNull(cond, left, right) && falseExp.getKind() == Tree.Kind.BOOLEAN_LITERAL && ((LiteralTree)falseExp).getValue().equals(false)) {
                    return (Boolean)this.visit(trueExp, p);
                }
                return false;
            }

            @Override
            public Boolean visitMethodInvocation(MethodInvocationTree tree2, Void p) {
                if (!InterningVisitor.this.isInvocationOfEquals(tree2)) {
                    return false;
                }
                List<? extends ExpressionTree> args2 = tree2.getArguments();
                if (args2.size() != 1) {
                    return false;
                }
                ExpressionTree arg = args2.get(0);
                ExpressionTree exp = tree2.getMethodSelect();
                if (exp.getKind() != Tree.Kind.MEMBER_SELECT) {
                    return false;
                }
                MemberSelectTree member = (MemberSelectTree)exp;
                ExpressionTree receiver = member.getExpression();
                if (InterningVisitor.sameTree(receiver, left) && InterningVisitor.sameTree(arg, right)) {
                    return true;
                }
                if (InterningVisitor.sameTree(receiver, right) && InterningVisitor.sameTree(arg, left)) {
                    return true;
                }
                return false;
            }
        };
        boolean okay = Heuristics.Matchers.withIn(Heuristics.Matchers.ofKind(Tree.Kind.CONDITIONAL_OR, matcher)).match(this.getCurrentPath());
        return okay;
    }

    private boolean suppressEarlyCompareTo(final BinaryTree node) {
        if (node.getKind() != Tree.Kind.EQUAL_TO) {
            return false;
        }
        ExpressionTree left = node.getLeftOperand();
        ExpressionTree right = node.getRightOperand();
        if (left.getKind() != Tree.Kind.IDENTIFIER || right.getKind() != Tree.Kind.IDENTIFIER) {
            return false;
        }
        final Element lhs = TreeUtils.elementFromUse((IdentifierTree)left);
        final Element rhs = TreeUtils.elementFromUse((IdentifierTree)right);
        Heuristics.Matcher matcher = new Heuristics.Matcher(){

            @Override
            public Boolean visitBinary(BinaryTree tree2, Void p) {
                if (tree2.getKind() == Tree.Kind.EQUAL_TO) {
                    ExpressionTree leftTree = tree2.getLeftOperand();
                    ExpressionTree rightTree = tree2.getRightOperand();
                    if (rightTree.getKind() != Tree.Kind.INT_LITERAL) {
                        return false;
                    }
                    LiteralTree rightLiteral = (LiteralTree)rightTree;
                    if (!rightLiteral.getValue().equals(0)) {
                        return false;
                    }
                    return (Boolean)this.visit(leftTree, p);
                }
                ExpressionTree leftTree = tree2.getLeftOperand();
                ExpressionTree rightTree = tree2.getRightOperand();
                if (leftTree != node) {
                    return false;
                }
                if (rightTree.getKind() != Tree.Kind.EQUAL_TO) {
                    return false;
                }
                return (Boolean)this.visit(rightTree, p);
            }

            @Override
            public Boolean visitMethodInvocation(MethodInvocationTree tree2, Void p) {
                if (!InterningVisitor.this.isInvocationOfCompareTo(tree2)) {
                    return false;
                }
                List<? extends ExpressionTree> args2 = tree2.getArguments();
                if (args2.size() != 1) {
                    return false;
                }
                ExpressionTree arg = args2.get(0);
                if (arg.getKind() != Tree.Kind.IDENTIFIER) {
                    return false;
                }
                Element argElt = TreeUtils.elementFromUse(arg);
                ExpressionTree exp = tree2.getMethodSelect();
                if (exp.getKind() != Tree.Kind.MEMBER_SELECT) {
                    return false;
                }
                MemberSelectTree member = (MemberSelectTree)exp;
                if (member.getExpression().getKind() != Tree.Kind.IDENTIFIER) {
                    return false;
                }
                Element refElt = TreeUtils.elementFromUse(member.getExpression());
                if (!(refElt.equals(lhs) && argElt.equals(rhs) || refElt.equals(rhs) && argElt.equals(lhs))) {
                    return false;
                }
                return true;
            }
        };
        boolean okay = Heuristics.Matchers.withIn(Heuristics.Matchers.ofKind(Tree.Kind.CONDITIONAL_OR, matcher)).match(this.getCurrentPath());
        return okay;
    }

    private boolean suppressClassAnnotation(AnnotatedTypeMirror left, AnnotatedTypeMirror right) {
        return this.classIsAnnotated(left) || this.classIsAnnotated(right);
    }

    private boolean classIsAnnotated(AnnotatedTypeMirror type2) {
        Element classElt;
        TypeMirror tm = type2.getUnderlyingType();
        if (tm == null) {
            return false;
        }
        if ((tm = ((Type)tm).unannotatedType()).getKind() == TypeKind.TYPEVAR) {
            tm = ((TypeVariable)tm).getUpperBound();
        }
        if (tm.getKind() == TypeKind.WILDCARD) {
            tm = ((WildcardType)tm).getExtendsBound();
        }
        if (tm == null || tm.getKind() == TypeKind.ARRAY) {
            return false;
        }
        if ((tm = ((Type)tm).unannotatedType()).getKind() != TypeKind.DECLARED) {
            System.out.printf("InterningVisitor.classIsAnnotated: tm = %s (%s)%n", tm, tm.getClass());
        }
        if ((classElt = ((DeclaredType)tm).asElement()) == null) {
            System.out.printf("InterningVisitor.classIsAnnotated: classElt = null for tm = %s (%s)%n", tm, tm.getClass());
        }
        if (classElt != null) {
            AnnotatedTypeMirror classType = ((InterningAnnotatedTypeFactory)this.atypeFactory).fromElement(classElt);
            assert (classType != null);
            for (AnnotationMirror anno : classType.getAnnotations()) {
                if (!this.INTERNED.equals(anno)) continue;
                return true;
            }
        }
        return false;
    }

    private Element getThis(Scope scope2) {
        for (Element element : scope2.getLocalElements()) {
            if (!element.getSimpleName().contentEquals("this")) continue;
            return element;
        }
        return null;
    }

    private boolean overrides(ExecutableElement e, Class<?> clazz, String method) {
        TypeElement clazzElt = this.elements.getTypeElement(clazz.getCanonicalName());
        assert (clazzElt != null);
        for (ExecutableElement elt : ElementFilter.methodsIn(clazzElt.getEnclosedElements())) {
            if (!elt.getSimpleName().contentEquals(method) || !this.elements.overrides(e, elt, clazzElt)) continue;
            return true;
        }
        return false;
    }

    DeclaredType typeToCheck() {
        String className = this.checker.getOption("checkclass");
        if (className == null) {
            return null;
        }
        TypeElement classElt = this.elements.getTypeElement(className);
        if (classElt == null) {
            return null;
        }
        return this.types.getDeclaredType(classElt, new TypeMirror[0]);
    }
}

